/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.queryref;

import aglobe.container.agent.CMAgent;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.protocol.query.QueryInitiatorTask;

public abstract class QueryRefInitiatorTask
extends QueryInitiatorTask {
    public static int DEFAULT_TIMEOUT = 1000;
    protected Object queryContent;
    public boolean metaWillRefuse;

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content) {
        this(owner, participant, content, DEFAULT_TIMEOUT);
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, boolean autostart) {
        this(owner, participant, content, DEFAULT_TIMEOUT, autostart);
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, String action) {
        this(owner, participant, content, DEFAULT_TIMEOUT, action);
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, boolean autostart, boolean willRef) {
        super(owner, participant, content, timeout, "QUERY-REF", false);
        this.queryContent = content;
        this.metaWillRefuse = willRef;
        if (autostart) {
            this.start();
        }
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, int timeout) {
        this(owner, participant, content, timeout, true);
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, String action) {
        this(owner, participant, content, timeout, false, action);
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, boolean autostart, String action) {
        super(owner, participant, content, timeout, "QUERY", true, action);
        this.queryContent = content;
        if (autostart) {
            this.start();
        }
    }

    public QueryRefInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, boolean autostart) {
        super(owner, participant, content, timeout, "QUERY-REF", false);
        this.queryContent = content;
        if (autostart) {
            this.start();
        }
    }

    protected void handleIncomingMessage(Message msg) {
        String performative = msg.getPerformative();
        if (!"QUERY".equalsIgnoreCase(msg.getProtocol())) {
            this.notUnderstood(msg);
        } else if ("INFORM-RESULT".equalsIgnoreCase(performative)) {
            this.informResult(msg.getContent());
        } else if ("NOT-UNDERSTOOD".equalsIgnoreCase(performative)) {
            this.notUnderstoodReceived(msg);
        } else {
            String stringContent = new String();
            if (msg.getContent() != null) {
                String string = stringContent = msg.getContent() instanceof String ? (String)msg.getContent() : msg.getContent().toString();
            }
            if ("FAILURE".equalsIgnoreCase(performative)) {
                this.failure(stringContent);
            } else if ("AGREE".equalsIgnoreCase(performative)) {
                this.queryAgreed();
            } else if ("REFUSE".equalsIgnoreCase(performative)) {
                this.queryRefused();
            } else {
                this.notUnderstood(msg);
            }
        }
        msg.release();
    }

    protected void notUnderstoodReceived(Message msg) {
    }

    protected abstract void informResult(Object var1);
}

