/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.queryif;

import aglobe.container.agent.CMAgent;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.protocol.query.QueryInitiatorTask;

public abstract class QueryIfInitiatorTask
extends QueryInitiatorTask {
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static int DEFAULT_TIMEOUT = 1000;

    public QueryIfInitiatorTask(CMAgent owner, Address participant, Object content) {
        this(owner, participant, content, true);
    }

    public QueryIfInitiatorTask(CMAgent owner, Address participant, Object content, boolean autostart) {
        this(owner, participant, content, DEFAULT_TIMEOUT, autostart);
    }

    public QueryIfInitiatorTask(CMAgent owner, Address participant, Object content, int timeout) {
        this(owner, participant, content, timeout, true);
    }

    public QueryIfInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, boolean autostart) {
        super(owner, participant, content, timeout, "QUERY-IF", autostart);
    }

    protected void handleIncomingMessage(Message msg) {
        String performative = msg.getPerformative();
        if (!"QUERY".equalsIgnoreCase(msg.getProtocol())) {
            this.notUnderstood(msg);
        } else if ("INFORM-T/F".equalsIgnoreCase(performative)) {
            if (msg.getContent() instanceof String) {
                String reply = (String)msg.getContent();
                if (TRUE.equalsIgnoreCase(reply)) {
                    this.informTrue();
                } else if (FALSE.equalsIgnoreCase(reply)) {
                    this.informFalse();
                } else {
                    this.notUnderstood(msg);
                }
            } else {
                this.notUnderstood(msg);
            }
        } else if (!"NOT-UNDERSTOOD".equalsIgnoreCase(performative)) {
            String stringContent;
            String string = stringContent = msg.getContent() instanceof String ? (String)msg.getContent() : msg.getContent().toString();
            if ("FAILURE".equalsIgnoreCase(performative)) {
                this.failure(stringContent);
            } else if ("AGREE".equalsIgnoreCase(performative)) {
                this.queryAgreed();
            } else if ("REFUSE".equalsIgnoreCase(performative)) {
                this.queryRefused();
            } else {
                this.notUnderstood(msg);
            }
        }
        msg.release();
    }

    protected abstract void informTrue();

    protected abstract void informFalse();
}

