/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.queryif;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiQueryIfInitiatorTask
extends Task {
    protected Collection participants;
    private Iterator participantsIterator;
    private Object content;
    private Address owner;
    private final CMAgent ownerAgent;
    private Set<Address> positiveReplies = new HashSet<Address>();
    private Set<Address> negativeReplies = new HashSet<Address>();

    public MultiQueryIfInitiatorTask(CMAgent owner, Collection participants, Object content) {
        this(owner, participants, content, true);
    }

    public MultiQueryIfInitiatorTask(CMAgent owner, Collection participants, Object content, boolean autostart) {
        super(owner);
        this.participants = participants;
        this.content = content;
        this.owner = owner.getAddress();
        this.ownerAgent = owner;
        if (autostart) {
            this.start();
        }
    }

    public void start() {
        this.participantsIterator = this.participants.iterator();
        this.sendNextQueryIf();
    }

    private void sendNextQueryIf() {
        if (!this.participantsIterator.hasNext()) {
            this.processReplies(this.positiveReplies, this.negativeReplies);
            return;
        }
        Address participant = (Address)this.participantsIterator.next();
        Message queryMsg = Message.newInstance("QUERY-IF", this.owner, participant);
        queryMsg.setProtocol("QUERY");
        queryMsg.setContent(this.content);
        try {
            this.sendMessage(queryMsg);
        }
        catch (InvisibleContainerException ex) {
            this.ownerAgent.logSevere("Cannot send query_if message: " + ex + "\nparticipant removed.");
            this.participantsIterator.remove();
        }
        queryMsg.release();
    }

    protected abstract void processReplies(Set<Address> var1, Set<Address> var2);

    @Override
    protected void handleIncomingMessage(Message msg) {
        String performative = msg.getPerformative();
        if (!"QUERY".equalsIgnoreCase(msg.getProtocol())) {
            this.notUnderstood(msg);
            if ("INFORM-T/F".equalsIgnoreCase(performative)) {
                if (msg.getContent() instanceof String) {
                    String reply = (String)msg.getContent();
                    if ("TRUE".equalsIgnoreCase(reply)) {
                        this.positiveReplies.add(msg.getSender());
                        this.sendNextQueryIf();
                    } else if ("FALSE".equalsIgnoreCase(reply)) {
                        this.negativeReplies.add(msg.getSender());
                        this.sendNextQueryIf();
                    } else {
                        this.notUnderstood(msg);
                    }
                } else {
                    this.notUnderstood(msg);
                }
            } else {
                this.notUnderstood(msg);
            }
        } else {
            this.notUnderstood(msg);
        }
        msg.release();
    }

    protected void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }

    public Object getContent() {
        return this.content;
    }
}

