/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.query;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.Task;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class QueryParticipantTask
extends Task {
    protected Message queryMessage;
    protected final CMAgent owner;

    public QueryParticipantTask(CMAgent owner, Message queryMessage) {
        this(owner, queryMessage, true);
    }

    public QueryParticipantTask(CMAgent owner, Message queryMessage, boolean autoprocess) {
        super(owner);
        this.queryMessage = queryMessage;
        this.owner = owner;
        if (!"QUERY".equalsIgnoreCase(queryMessage.getProtocol())) {
            throw new IllegalArgumentException(String.valueOf(queryMessage.getProtocol()) + "." + queryMessage.getPerformative() + " is not good subscribe combination...");
        }
        if (autoprocess) {
            owner.addEvent(new Runnable(){

                public void run() {
                    QueryParticipantTask.this.start();
                }
            });
        }
    }

    public void start() {
        this.processQuery(this.queryMessage);
    }

    protected void handleIncomingMessage(Message msg) {
        this.notUnderstood(msg);
        msg.release();
    }

    protected void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }

    protected abstract void processQuery(Message var1);

    protected void agree() {
        Message re = this.queryMessage.getReply();
        re.setPerformative("AGREE");
        re.setContent(this.queryMessage.getContent());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.logSevere("Cannot send agree message: " + ex);
        }
        re.release();
    }

    protected void refuse() {
        Message re = this.queryMessage.getReply();
        re.setPerformative("REFUSE");
        re.setContent(this.queryMessage.getContent());
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.logSevere("Cannot send refuse message: " + ex);
        }
        re.release();
    }

    protected void failure(Object reason) {
        Message re = this.queryMessage.getReply();
        re.setPerformative("FAILURE");
        re.setContent(reason);
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException ex) {
            this.owner.logSevere("Cannot send failure message: " + ex);
        }
        re.release();
    }

    public void cancelTask() {
        if (this.queryMessage != null) {
            this.queryMessage.release();
            this.queryMessage = null;
        }
        super.cancelTask();
    }
}

