/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.query;

import aglobe.container.agent.CMAgent;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;

public abstract class QueryInitiatorTask
extends TimeoutTask {
    public static int DEFAULT_TIMEOUT = 1000;
    protected Address participant;
    protected Message queryMsg;

    public QueryInitiatorTask(CMAgent owner, Address participant, Object content, String performative) {
        this(owner, participant, content, DEFAULT_TIMEOUT, performative);
    }

    public QueryInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, String performative) {
        this(owner, participant, content, timeout, performative, true);
    }

    public QueryInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, String performative, boolean autostart) {
        super(owner, timeout);
        this.participant = participant;
        this.queryMsg = Message.newInstance(performative, owner.getAddress(), participant);
        this.queryMsg.setProtocol("QUERY");
        this.queryMsg.setContent(content);
        if (autostart) {
            this.start();
        }
    }

    public QueryInitiatorTask(CMAgent owner, Address participant, Object content, int timeout, String performative, boolean autostart, String action) {
        super(owner, timeout);
        this.participant = participant;
        this.queryMsg = Message.newInstance(performative, owner.getAddress(), participant);
        this.queryMsg.setProtocol("QUERY-REF");
        this.queryMsg.setContent(content);
        this.queryMsg.setReason(action);
        if (autostart) {
            this.start();
        }
    }

    protected void timeout() {
    }

    public void start() {
        try {
            this.sendMessage(this.queryMsg);
        }
        catch (InvisibleContainerException ex) {
            super.rescheduleTimer(0L);
            this.timeout();
        }
    }

    protected void queryAgreed() {
    }

    protected void queryRefused() {
    }

    protected void failure(String reason) {
    }

    protected void notUnderstood(Message msg) {
        this.sendNotUnderstood(msg, null);
    }

    public void cancelTask() {
        if (this.queryMsg != null) {
            this.queryMsg.release();
            this.queryMsg = null;
        }
        super.cancelTask();
    }
}

