/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.ecnp;

import aglobe.container.task.Task;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.protocol.cnp.CNPParticipantTask;
import aglobex.protocol.cnp.CNPTaskOwner;
import aglobex.protocol.ecnp.ECNPSubInitiatorTask;
import aglobex.protocol.ecnp.ECNPSubParticipantTask;
import aglobex.protocol.ecnp.ECNPTaskFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECNPTask<InitTask extends ECNPSubInitiatorTask, ParticipantTask extends ECNPSubParticipantTask>
extends TimeoutTask {
    public static final String TEMPORARY_ACCEPT_PROPOSAL = "TEMPORARY-ACCEPT-PROPOSAL";
    public static final int TOTALTIMEOUT = 5000;
    public static final int SHORTTIMEOUT = 1000;
    public static final int LONGTIMEOUT = 2000;
    ECNPTaskMap ownerTaskMap = null;
    String mapKey = null;
    protected List<InitTask> init = new LinkedList<InitTask>();
    protected List<ParticipantTask> particip = new LinkedList<ParticipantTask>();
    protected ECNPTaskFactory<InitTask, ParticipantTask> factory;
    protected int totalTimeout;
    protected int shortTimeout;
    protected int longTimeout;

    public ECNPTask(ECNPTaskMap taskMap, String mapKey, ECNPTaskFactory<InitTask, ParticipantTask> factory, int totalTimeout, int shortTimeout, int longTimeout) {
        super(taskMap.owner, totalTimeout);
        this.ownerTaskMap = taskMap;
        this.mapKey = mapKey;
        this.factory = factory;
        this.totalTimeout = totalTimeout;
        this.shortTimeout = shortTimeout;
        this.longTimeout = longTimeout;
    }

    public void createOffer(Collection<Address> participants, Object offer) {
        InitTask initTask = this.factory.getInitiatorInstance(this.ownerTaskMap.owner, participants, offer, this.shortTimeout, this.longTimeout, this.mapKey, this);
        if (!((Task)initTask).isCancelled()) {
            this.init.add(initTask);
        }
    }

    public void start() {
        for (ECNPSubInitiatorTask sit : this.init) {
            sit.start();
        }
        this.rescheduleTimer(this.totalTimeout);
    }

    @Override
    public void handleIncomingMessage(Message m) {
        if ("CFP".equalsIgnoreCase(m.getPerformative())) {
            ParticipantTask participTask = this.factory.getParticipantInstance(this.ownerTaskMap.owner, this.shortTimeout, this.longTimeout, m, this);
            this.particip.add(participTask);
            ((CNPParticipantTask)participTask).start();
            this.handleParticipantCFPMessage(participTask, m);
        }
    }

    protected void handleParticipantCFPMessage(ParticipantTask participantTask, Message m) {
    }

    protected void handleInitiatorReplies(ECNPSubInitiatorTask initTask, Collection<Address> participants, HashMap<Address, Message> receivedOffers) {
    }

    protected boolean handleInitiatorTemporaryAcceptTimeout(ECNPSubInitiatorTask initTask) {
        return true;
    }

    protected void handleParticipantProposalTemporaryAccepted(ECNPSubParticipantTask participantTask, Message acceptMessage) {
    }

    protected void handleParticipantProposalAccepted(ECNPSubParticipantTask participantTask, Message acceptMessage) {
        participantTask.cancelTask();
    }

    protected void handleParticipantProposalRefused(ECNPSubParticipantTask participantTask, Message refuseMessage) {
        participantTask.cancelTask();
    }

    protected boolean handleInitiatorAcceptReply(ECNPSubInitiatorTask initTask, Message m) {
        return true;
    }

    protected void handleInitiatorAcceptTimeout(ECNPSubInitiatorTask initTask) {
    }

    @Override
    protected void timeout() {
        LinkedList<InitTask> i = new LinkedList<InitTask>(this.init);
        for (ECNPSubInitiatorTask it : i) {
            it.cancelTask();
        }
        LinkedList<ParticipantTask> p = new LinkedList<ParticipantTask>(this.particip);
        for (ECNPSubParticipantTask pt : p) {
            pt.cancelTask();
        }
    }

    @Override
    public void cancelTask() {
        if (this.ownerTaskMap != null && this.mapKey != null) {
            this.ownerTaskMap.remove(this.mapKey);
        }
        super.cancelTask();
    }

    public String getMapKey() {
        return this.mapKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ECNPTaskMap<InitTask extends ECNPSubInitiatorTask, ParticipantTask extends ECNPSubParticipantTask>
    extends LinkedHashMap<String, ECNPTask<InitTask, ParticipantTask>> {
        private static final long serialVersionUID = -3879935600442791038L;
        protected CNPTaskOwner owner;
        protected ECNPTaskFactory<InitTask, ParticipantTask> factory;

        public ECNPTaskMap(CNPTaskOwner owner, ECNPTaskFactory<InitTask, ParticipantTask> factory) {
            this.owner = owner;
            this.factory = factory;
        }

        public void handleMessage(Message msg, String keyToUse) {
            ECNPTask<InitTask, ParticipantTask> task = (ECNPTask<InitTask, ParticipantTask>)this.get(keyToUse);
            if (task == null) {
                task = this.factory.getECNPTaskInstance(5000, this, keyToUse);
                this.put(keyToUse, task);
            }
            task.handleIncomingMessage(msg);
        }

        public void createOffer(String keyToUse, Object offer, Collection<Address> participants) {
            ECNPTask<InitTask, ParticipantTask> task = (ECNPTask<InitTask, ParticipantTask>)this.get(keyToUse);
            if (task == null) {
                task = this.factory.getECNPTaskInstance(5000, this, keyToUse);
                this.put(keyToUse, task);
            }
            task.createOffer(participants, offer);
        }

        public void startECNP(String keyToUse) {
            ECNPTask<InitTask, ParticipantTask> task = (ECNPTask<InitTask, ParticipantTask>)this.get(keyToUse);
            if (task == null) {
                task = this.factory.getECNPTaskInstance(5000, this, keyToUse);
                this.put(keyToUse, task);
            }
            task.start();
        }
    }
}

