/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.ecnp;

import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobex.protocol.cnp.CNPParticipantTask;
import aglobex.protocol.cnp.CNPTaskOwner;
import aglobex.protocol.ecnp.ECNPTask;

public abstract class ECNPSubParticipantTask
extends CNPParticipantTask {
    public static final int STATUS_CREATE = 0;
    public static final int STATUS_PROPOSE = 1;
    public static final int STATUS_TEMP_ACCEPTED = 2;
    public static final int STATUS_ACCEPTED = 3;
    protected ECNPTask<?, ?> ownerTask;
    protected Message temporaryAcceptMessage;
    protected int shortTimeout;
    protected int longTimeout;
    protected int status = 0;

    public ECNPSubParticipantTask(CNPTaskOwner owner, int shortTimeout, int longTimeout, Message cfpMessage, ECNPTask ownerTask) {
        super(owner, shortTimeout, cfpMessage, false);
        this.ownerTask = ownerTask;
        this.shortTimeout = shortTimeout;
        this.longTimeout = longTimeout;
    }

    protected void prepareProposal() {
    }

    protected void proposalTemporaryAccepted(Message acceptMessage) {
        this.status = 2;
        this.ownerTask.handleParticipantProposalTemporaryAccepted(this, acceptMessage);
    }

    protected void proposalAccepted(Message acceptMessage) {
        this.status = 2;
        this.ownerTask.handleParticipantProposalAccepted(this, acceptMessage);
    }

    protected void proposalRefused(Message refuseMessage) {
        this.ownerTask.handleParticipantProposalRefused(this, refuseMessage);
    }

    public void sendProposal(Object content) {
        super.sendProposal(content);
        this.rescheduleTimer(this.longTimeout);
        this.status = 1;
    }

    public void sendRefuse() {
        super.sendRefuse();
    }

    public void sendRefuse(String reason) {
        super.sendRefuse(reason);
    }

    public void sendDone(Object content) {
        try {
            super.sendDone(content);
        }
        catch (InvisibleContainerException e) {
            this.cancelTask();
        }
    }

    public void sendFailure(Object content) {
        try {
            super.sendFailure(content);
        }
        catch (InvisibleContainerException e) {
            this.cancelTask();
        }
    }

    protected void handleIncomingMessage(Message m) {
        if (this.initiator.equals(m.getSender())) {
            if ("TEMPORARY-ACCEPT-PROPOSAL".equalsIgnoreCase(m.getPerformative())) {
                this.temporaryAcceptMessage = m;
                this.proposalTemporaryAccepted(m);
                this.rescheduleTimer(this.longTimeout);
            } else {
                super.handleIncomingMessage(m);
            }
        }
    }

    public void cancelTask() {
        this.ownerTask.particip.remove(this);
        super.cancelTask();
    }

    public int getStatus() {
        return this.status;
    }
}

