/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.ecnp;

import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobex.protocol.cnp.CNPInitiatorTask;
import aglobex.protocol.cnp.CNPTaskOwner;
import aglobex.protocol.ecnp.ECNPTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECNPSubInitiatorTask
extends CNPInitiatorTask {
    public static final int STATUS_TEMPORARY_ACCEPT_SENT = 4;
    protected ECNPTask<?, ?> ownerTask;
    protected String replyWithTAR;
    protected int shortTimeout;
    protected int longTimeout;

    public ECNPSubInitiatorTask(CNPTaskOwner cu, Collection<Address> participants, Object cfpContent, int shortTimeout, int longTimeout, String reason, ECNPTask ownerTask) {
        super(cu, participants, cfpContent, longTimeout, reason, false);
        this.ownerTask = ownerTask;
        this.shortTimeout = shortTimeout;
        this.longTimeout = longTimeout;
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        super.handleIncomingMessage(m);
    }

    @Override
    protected List<Address> evaluateReplies() {
        return null;
    }

    @Override
    protected void handleReplies() {
        this.status = 3;
        this.ownerTask.handleInitiatorReplies(this, this.participants, this.receivedOffers);
    }

    protected boolean evaluateTemporaryAcceptTimeout() {
        return this.ownerTask.handleInitiatorTemporaryAcceptTimeout(this);
    }

    @Override
    protected boolean evaluateAcceptReply(Message m) {
        return this.ownerTask.handleInitiatorAcceptReply(this, m);
    }

    @Override
    protected void evaluateAcceptTimeout() {
        this.ownerTask.handleInitiatorAcceptTimeout(this);
    }

    @Override
    public void cancelTask() {
        this.ownerTask.init.remove(this);
        super.cancelTask();
    }

    @Override
    protected void timeout() {
        if (4 == this.status) {
            if (this.evaluateTemporaryAcceptTimeout()) {
                this.sendAcceptsToParticipants(new HashMap<Address, Object>());
                this.cancelTask();
            }
        } else {
            super.timeout();
        }
    }

    public void sendTemporaryAcceptsToParticipants(Map<Address, Object> tempAcceptedParticipants) {
        LinkedList refusedParticipants = new LinkedList(this.participants);
        this.status = 4;
        this.replyWithTAR = "TAR" + this.replyWith;
        for (Map.Entry<Address, Object> elem : tempAcceptedParticipants.entrySet()) {
            Address address = elem.getKey();
            Object replyObject = elem.getValue();
            refusedParticipants.remove(address);
            Message tempAcceptProposal = ((Message)this.receivedOffers.get(address)).getReply();
            tempAcceptProposal.setPerformative("TEMPORARY-ACCEPT-PROPOSAL");
            tempAcceptProposal.setReplyWith(this.replyWithTAR);
            if (replyObject != null) {
                tempAcceptProposal.setContent(replyObject);
            }
            try {
                this.sendMessage(tempAcceptProposal);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            tempAcceptProposal.release();
        }
        for (Address address : refusedParticipants) {
            Message loser;
            this.participants.remove(address);
            Object m1 = this.receivedOffers.get(address);
            if (m1 == null || !(loser = (Message)m1).getPerformative().equalsIgnoreCase("PROPOSAL")) continue;
            Message rejectProposal = loser.getReply();
            rejectProposal.setPerformative("REJECT-PROPOSAL");
            rejectProposal.setContent(loser.getContent());
            rejectProposal.setReplyWith(this.replyWithAR);
            try {
                this.sendMessage(rejectProposal);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            rejectProposal.release();
        }
        if (tempAcceptedParticipants.size() != 0) {
            this.rescheduleTimer(this.shortTimeout);
        } else {
            this.cancelTask();
        }
    }

    public void sendAcceptsToParticipants(Map<Address, Object> acceptedParticipants) {
        LinkedList refusedParticipants = new LinkedList(this.participants);
        this.status = 2;
        this.replyWithAR = "AR" + this.replyWith;
        for (Map.Entry<Address, Object> elem : acceptedParticipants.entrySet()) {
            Address address = elem.getKey();
            if (!this.participants.contains(address)) continue;
            Object replyObject = elem.getValue();
            refusedParticipants.remove(address);
            Message acceptProposal = ((Message)this.receivedOffers.get(address)).getReply();
            acceptProposal.setPerformative("ACCEPT-PROPOSAL");
            acceptProposal.setReplyWith(this.replyWithAR);
            if (replyObject != null) {
                acceptProposal.setContent(replyObject);
            }
            try {
                this.sendMessage(acceptProposal);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            acceptProposal.release();
        }
        for (Address address : refusedParticipants) {
            Message loser;
            this.participants.remove(address);
            Object m1 = this.receivedOffers.get(address);
            if (m1 == null || !(loser = (Message)m1).getPerformative().equalsIgnoreCase("PROPOSAL")) continue;
            Message rejectProposal = loser.getReply();
            rejectProposal.setPerformative("REJECT-PROPOSAL");
            rejectProposal.setContent(loser.getContent());
            rejectProposal.setReplyWith(this.replyWithAR);
            try {
                this.sendMessage(rejectProposal);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            rejectProposal.release();
        }
        if (acceptedParticipants.size() != 0) {
            this.rescheduleTimer(this.longTimeout);
        } else {
            this.cancelTask();
        }
    }

    public Collection<Address> getParticipants() {
        return this.participants;
    }
}

