/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.cnp;

import aglobe.container.task.ConversationUnit;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobex.protocol.cnp.CNPInitiatorTask;

public abstract class CNPParticipantTask
extends TimeoutTask {
    protected ConversationUnit owner;
    protected Address initiator;
    protected Message cfpMessage;
    protected Object submitedProposal = null;
    protected Message acceptMessage;
    private CNPInitiatorTask ownerCNPInitiatorTask = null;

    public CNPParticipantTask(ConversationUnit owner, int msec, Message cfpMessage, boolean autoprocess) {
        super(owner, msec);
        this.owner = owner;
        this.cfpMessage = cfpMessage;
        this.initiator = cfpMessage.getSender();
        if (autoprocess) {
            owner.getConversationManager().getElementaryConversationEntity().addEvent(new Runnable(){

                public void run() {
                    CNPParticipantTask.this.start();
                }
            });
        }
    }

    public CNPParticipantTask(ConversationUnit owner, int msec, Message cfpMessage) {
        this(owner, msec, cfpMessage, true);
    }

    public Address getInitiator() {
        return this.initiator;
    }

    public CNPParticipantTask(ConversationUnit owner, int msec) {
        super(owner, msec);
        this.owner = owner;
        this.cfpMessage = null;
    }

    protected abstract void prepareProposal();

    protected abstract void proposalAccepted(Message var1);

    protected abstract void proposalRefused(Message var1);

    public void sendProposal(Object content) {
        if (!this.isCancelled()) {
            Message prop = this.cfpMessage.getReply();
            prop.setPerformative("PROPOSAL");
            prop.setContent(content);
            this.submitedProposal = content;
            try {
                this.sendMessage(prop);
            }
            catch (InvisibleContainerException e) {
                this.proposalRefused(null);
                this.cancelTask();
            }
            prop.release();
        }
    }

    public Object getSubmitedProposal() {
        return this.submitedProposal;
    }

    public void sendRefuse(String reason) {
        Message ref = this.cfpMessage.getReply();
        ref.setPerformative("REFUSE");
        ref.setContent(this.cfpMessage.getContent());
        ref.setReason(reason);
        try {
            this.sendMessage(ref);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
        ref.release();
        this.cancelTask();
    }

    public void sendRefuse() {
        this.sendRefuse("");
    }

    public void sendDone(Object content) throws InvisibleContainerException {
        Message doneMsg = this.acceptMessage.getReply();
        doneMsg.setPerformative("INFORM-DONE");
        doneMsg.setContent(content);
        this.sendMessage(doneMsg);
        doneMsg.release();
    }

    public void sendFailure(Object content) throws InvisibleContainerException {
        Message doneMsg = this.acceptMessage.getReply();
        doneMsg.setPerformative("FAILURE");
        doneMsg.setContent(content);
        this.sendMessage(doneMsg);
        doneMsg.release();
    }

    protected void handleIncomingMessage(Message m) {
        if (!this.isCancelled() && this.initiator.equals(m.getSender())) {
            if ("ACCEPT-PROPOSAL".equalsIgnoreCase(m.getPerformative())) {
                this.acceptMessage = m;
                this.proposalAccepted(m);
                return;
            }
            if ("REJECT-PROPOSAL".equalsIgnoreCase(m.getPerformative())) {
                this.proposalRefused(m);
                this.cancelTask();
            }
        }
        m.release();
    }

    protected void timeout() {
        String proposal = this.submitedProposal == null ? "\nbefore the proposal was sent!" : "\nsent proposal was:\n" + this.submitedProposal;
        this.owner.getConversationManager().getElementaryConversationEntity().logWarning("Timeout elapsed for the task: " + this.cfpMessage + proposal);
        this.proposalRefused(null);
        this.cancelTask();
    }

    public void start() {
        this.prepareProposal();
    }

    void setOwnerCNPInitiatorTask(CNPInitiatorTask it) throws Exception {
        if (this.ownerCNPInitiatorTask != null) {
            throw new Exception("Owner CNPInitiatorTask is already set.");
        }
        this.ownerCNPInitiatorTask = it;
    }

    protected final void sendMessage(final Message m) throws InvisibleContainerException {
        if (this.ownerCNPInitiatorTask == null) {
            this.log(m);
            super.sendMessage(m);
        } else {
            this.owner.getConversationManager().getElementaryConversationEntity().addEvent(new Runnable(){

                public void run() {
                    CNPParticipantTask.this.ownerCNPInitiatorTask.handleIncomingMessage(m);
                }
            });
        }
    }

    protected void log(Message message) {
    }

    public void cancelTask() {
        if (this.cfpMessage != null) {
            this.cfpMessage.release();
            this.cfpMessage = null;
        }
        if (this.acceptMessage != null) {
            this.acceptMessage.release();
            this.acceptMessage = null;
        }
        super.cancelTask();
    }
}

