/*
 * Decompiled with CFR 0.152.
 */
package aglobex.protocol.cnp;

import aglobe.container.task.ConversationUnit;
import aglobe.container.task.TimeoutTask;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobex.protocol.cnp.CNPParticipantTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CNPInitiatorTask
extends TimeoutTask {
    protected ConversationUnit towner = null;
    protected int status = 0;
    public static final int STATUS_NOT_SENT = 0;
    public static final int STATUS_CFP_SENT = 1;
    public static final int STATUS_REPLIES_EVALUATED = 3;
    public static final int STATUS_ACCEPT_SENT = 2;
    protected LinkedHashMap<Address, Message> receivedOffers = new LinkedHashMap();
    protected String replyWith;
    protected String replyWithAR;
    protected Collection<Address> participants;
    protected int accTimeout;
    private String reason;
    private Object cfpContent;
    private CNPParticipantTask ownParticipantTask = null;

    public CNPInitiatorTask(ConversationUnit cu, Collection<Address> participants, Object cfpContent, int timeout, String reason, boolean autostart) {
        super(cu, timeout);
        this.towner = cu;
        this.accTimeout = timeout;
        this.cfpContent = cfpContent;
        this.reason = reason;
        this.participants = new LinkedList<Address>(participants);
        if (autostart) {
            this.start();
        }
    }

    public CNPInitiatorTask(ConversationUnit cu, Collection<Address> participants, Object cfpContent, int timeout, String reason) {
        this(cu, participants, cfpContent, timeout, reason, true);
    }

    public void start() {
        this.sendCfp(this.cfpContent, this.accTimeout, this.reason);
    }

    public void setCfpContent(Object content) {
        this.cfpContent = content;
    }

    protected void sendCfp(Object cfpContent, int timeout, String reason) {
        Message cfp = Message.newInstance("CFP", this.towner.getConversationManager().getElementaryConversationEntity().getAddress(), this.towner.getConversationManager().getElementaryConversationEntity().getAddress());
        cfp.setContent(cfpContent);
        cfp.setProtocol("CONTRACT-NET");
        StringBuffer sb = new StringBuffer(this.towner.getConversationManager().getElementaryConversationEntity().getAddress().getName());
        sb.append(System.currentTimeMillis());
        sb.append(Math.floor(Math.random() * 1000.0));
        this.replyWith = sb.toString();
        cfp.setReplyWith(this.replyWith);
        if (reason != null) {
            cfp.setReason(reason);
        }
        this.status = 1;
        Iterator<Address> i = this.participants.iterator();
        while (i.hasNext()) {
            Address address = i.next();
            cfp.setReceiver(address);
            try {
                this.sendMessage(cfp);
            }
            catch (InvisibleContainerException e) {
                i.remove();
            }
        }
        cfp.release();
        if (this.participants.size() == 0) {
            this.cancelTask();
        }
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        if (m.getInReplyTo().equalsIgnoreCase(this.replyWith)) {
            if (1 == this.status && this.participants.contains(m.getSender())) {
                this.receivedOffers.put(m.getSender(), m);
                if (this.receivedOffers.size() == this.participants.size()) {
                    this.rescheduleTimer(0L);
                    this.handleReplies();
                }
            }
        } else if (m.getInReplyTo().equalsIgnoreCase(this.replyWithAR) && 2 == this.status && !this.isCancelled() && this.participants.contains(m.getSender())) {
            this.handleAcceptReply(m);
        }
    }

    protected abstract List<Address> evaluateReplies();

    protected Map<Address, Object> evaluateRepliesWithContent() {
        List<Address> retVal = this.evaluateReplies();
        if (retVal == null) {
            return null;
        }
        LinkedHashMap<Address, Object> returnVal = new LinkedHashMap<Address, Object>();
        for (Address elem : retVal) {
            returnVal.put(elem, null);
        }
        return returnVal;
    }

    protected abstract boolean evaluateAcceptReply(Message var1);

    protected abstract void evaluateAcceptTimeout();

    protected void handleReplies() {
        this.status = 3;
        Map<Address, Object> accepted = this.evaluateRepliesWithContent();
        if (accepted != null) {
            this.sendAnswersToParticipants(accepted);
        }
    }

    private void handleAcceptReply(Message m) {
        if (!this.evaluateAcceptReply(m)) {
            this.cancelTask();
            m.release();
        }
    }

    @Override
    protected void timeout() {
        if (1 == this.status) {
            this.handleReplies();
        } else if (2 == this.status) {
            this.evaluateAcceptTimeout();
            this.cancelTask();
        }
    }

    protected void sendAnswersToParticipants(List acceptedParticipants) {
        LinkedHashMap<Address, Object> tmpVal = new LinkedHashMap<Address, Object>();
        for (Address item : acceptedParticipants) {
            tmpVal.put(item, null);
        }
        this.sendAnswersToParticipants(tmpVal);
    }

    protected void sendAnswersToParticipants(Map<Address, Object> acceptedParticipants) {
        LinkedList<Address> refusedParticipants = new LinkedList<Address>(this.participants);
        this.status = 2;
        this.replyWithAR = "AR" + this.replyWith;
        for (Map.Entry<Address, Object> elem : acceptedParticipants.entrySet()) {
            Address address = elem.getKey();
            Object replyObject = elem.getValue();
            refusedParticipants.remove(address);
            Message acceptProposal = this.receivedOffers.get(address).getReply();
            acceptProposal.setPerformative("ACCEPT-PROPOSAL");
            acceptProposal.setReplyWith(this.replyWithAR);
            if (replyObject != null) {
                acceptProposal.setContent(replyObject);
            }
            try {
                this.sendMessage(acceptProposal);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            acceptProposal.release();
        }
        for (Address address : refusedParticipants) {
            Message loser;
            this.participants.remove(address);
            Message m1 = this.receivedOffers.get(address);
            if (m1 == null || !(loser = m1).getPerformative().equalsIgnoreCase("PROPOSAL")) continue;
            Message rejectProposal = loser.getReply();
            rejectProposal.setPerformative("REJECT-PROPOSAL");
            rejectProposal.setContent(loser.getContent());
            rejectProposal.setReplyWith(this.replyWithAR);
            try {
                this.sendMessage(rejectProposal);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            rejectProposal.release();
        }
        if (acceptedParticipants.size() != 0) {
            this.rescheduleTimer(this.accTimeout);
        } else {
            this.cancelTask();
        }
    }

    public void registerOwnCNPParticipantTask(CNPParticipantTask pT) throws Exception {
        if (this.ownParticipantTask == null) {
            try {
                pT.setOwnerCNPInitiatorTask(this);
                this.ownParticipantTask = pT;
            }
            catch (Exception ex) {
                throw new Exception("The specified task is already assigned to another CNPInitiatorTask.");
            }
        } else {
            throw new Exception("Own CNPParticipantTask is already registered.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final void sendMessage(final Message m) throws InvisibleContainerException {
        if (m.getReceiver().equals(this.towner.getConversationManager().getElementaryConversationEntity().getAddress())) {
            if (this.ownParticipantTask == null) throw new RuntimeException("Trying to send message to itself without registering own CNPParticipantTask.");
            this.towner.getConversationManager().getElementaryConversationEntity().addEvent(new Runnable(){

                public void run() {
                    if ("CFP".equals(m.getPerformative())) {
                        ((CNPInitiatorTask)CNPInitiatorTask.this).ownParticipantTask.cfpMessage = m;
                        ((CNPInitiatorTask)CNPInitiatorTask.this).ownParticipantTask.initiator = m.getSender();
                        CNPInitiatorTask.this.ownParticipantTask.prepareProposal();
                    } else {
                        CNPInitiatorTask.this.ownParticipantTask.handleIncomingMessage(m);
                    }
                }
            });
            return;
        } else {
            this.log(m);
            super.sendMessage(m);
        }
    }

    protected void log(Message message) {
    }

    @Override
    public void cancelTask() {
        for (Message elem : this.receivedOffers.values()) {
            elem.release();
        }
        this.receivedOffers.clear();
        super.cancelTask();
    }
}

