/*
 * Decompiled with CFR 0.152.
 */
package aglobe.visio3D;

import aglobe.platform.thread.AglobeThreadPool;
import aglobe.visio3D.CarPosition2D;
import aglobe.visio3D.Configuration;
import aglobe.visio3D.ObjectIndexAllocator;
import aglobe.visio3D.PlanUpdate;
import aglobe.visio3D.Position2D;
import aglobe.visio3D.Position3D;
import aglobe.visio3D.VisioCallbackListener;
import aglobe.visio3D.ontology.Chart;
import aglobe.visio3D.ontology.ChartElement;
import aglobe.visio3D.ontology.ListBar;
import aglobe.visio3D.ontology.ListBarElement;
import aglobe.visio3D.ontology.SimpleBar;
import aglobe.visio3D.ontology.Visio;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisioConnection {
    public static final String VISIO_3D_CONF = "visio3DConf";
    private static final String REQUEST = "Are you there?";
    private static final int DEFAULT_PORT = 5555;
    private static final int WAIT_DELAY = 2000;
    private static final int SOCKET_TIMEOUT = 1000;
    private static final byte RESET = 1;
    private static final byte OBJECT_CREATE = 2;
    private static final byte OBJECT_DESTROY = 3;
    private static final byte OBJECT_SET_POS2D = 4;
    private static final byte OBJECT_SET_POS3D = 5;
    private static final byte OBJECT_SET_INFO = 6;
    private static final byte COMMUNICATION = 7;
    private static final byte SPECIAL = 8;
    private static final byte LINES = 9;
    private static final byte AGENT_INFO = 10;
    private static final byte REMOVE_AGENT = 11;
    private static final byte SHOW_ACTION = 13;
    private static final byte SET_RADIUS = 14;
    private static final byte SET_RADIUS2 = 15;
    private static final byte SET_CHART = 16;
    private static final byte REMOVE_CHART = 17;
    private static final byte OBJECT_SET_POS3D_EXT = 18;
    private static final byte PLAN_UPDATE = 21;
    private static final byte SCRSHOT3D_FREE = 24;
    private static final byte SCRSHOT3D_FOCUSED = 25;
    private static final byte SCRSHOT2D_FREE = 26;
    private static final byte SCRSHOT2D_FOCUSED = 27;
    private static final byte SET_WAYPOINTS = 28;
    private static final byte OBJECT_CRASHED = 29;
    private static final byte DISPLAY_TIME = 30;
    private static final byte RELATION_INFO_UPDATE = 31;
    private static final byte SET_ZONE_DIMENSIONS = 34;
    private static final byte SET_RADAR_RADIUS = 35;
    private static final byte SET_BATCH_INFO = 37;
    private static final byte SEND_REQUEST_IDS_START = 38;
    private static final byte SEND_REQUEST_IDS_END = 39;
    private static final byte SHOW_REQUEST_IDS = 40;
    private static final byte SET_VISIBILITY = 43;
    public static final byte DEFINE_ZONE_MESH = 44;
    private static final byte ASSIGN_ZONE_MESH = 45;
    private static final byte SEND_PLAN_START = 19;
    private static final byte SEND_PLAN_STOP = 20;
    private static final byte SET_SIMULATION_SPEED = 22;
    private static final byte SCRSHOT_DATA = 23;
    private static final byte SEND_RELINFO_START = 32;
    private static final byte SEND_RELINFO_END = 33;
    private static final byte SEND_REQUEST_IDS = 39;
    private static final byte SEND_BATCH_INFO_START = 41;
    private static final byte SEND_BATCH_INFO_END = 42;
    private static final byte AIRCRAFT_SELECTED = 46;
    private static final byte SHOW_LINE = 101;
    private static final byte HIDE_LINE = 102;
    public static final short SCROPT_DISPLAY_INFO_AIRCRAFT = 1;
    public static final short SCROPT_DISPLAY_INFO_FILTERED = 2;
    public static final short SCROPT_DISPLAY_ZONES = 3;
    public static final short SCROPT_DISPLAY_ZONES_RADIUS = 4;
    public static final short SCROPT_DISPLAY_FLIGHT_HISTORY = 5;
    public static final short SCROPT_DISPLAY_FLIGHT_PLAN = 6;
    public static final short SCROPT_DISPLAY_WAYPOINTS = 7;
    public static final short SCROPT_DISPLAY_LINKED_WAY = 7;
    public static final short SCRVAL_DISPLAY_INFO_AIRCRAFT_NO = 0;
    public static final short SCRVAL_DISPLAY_INFO_AIRCRAFT_FOCUSED_ONLY = 1;
    public static final short SCRVAL_DISPLAY_INFO_AIRCRAFT_ALL = 2;
    public static final short SCRVAL_FALSE = 0;
    public static final short SCRVAL_TRUE = 1;
    public static final short SCRVAL_DISPLAY_FLIGHT_PLAN_NO = 0;
    public static final short SCRVAL_DISPLAY_FLIGHT_PLAN_ALL = 1;
    public static final short SCRVAL_DISPLAY_FLIGHT_PLAN_FOCUSED_ONLY = 2;
    public static final short SCRVAL_DISPLAY_FLIGHT_PLAN_NON_FOCUSED_ONLY = 3;
    private static final byte DEFAULT_AGENT_INFO_COLOR = 2;
    private static final byte SPECIAL_CAR_WHEEL_ROTATING = 1;
    private static final byte SPECIAL_CAR_STEERING = 2;
    private static final byte SPECIAL_CAR_LOAD = 3;
    private static final byte SPECIAL_CAR_DOCK = 4;
    private static final byte STRING_END = 0;
    private static final double ANGLE_RATIO = 40.74366543152521;
    private static final double ANGLE_RATIO_EXT = 10430.219195527361;
    private static final double STEARING_RATIO = 81.48733086305042;
    private static final int MAX_UNSIGNED_SHORT_VLAUE = 65535;
    private Configuration conf;
    private List visualizators;
    private double angleMult;
    private double angleAdd;
    private double angleMult2;
    private double angleAdd2;
    private double angleMult3;
    private double angleAdd3;
    private int swapAxisXY;
    private double XMult;
    private double YMult;
    private double ZMult;
    private double XAdd;
    private double YAdd;
    private double ZAdd;
    public ObjectIndexAllocator objectIndexAllocator = null;
    private final Logger logger;
    private ByteArrayOutputStream dataBuf = new ByteArrayOutputStream(40000);
    private DataOutputStream dDataBuf = new DataOutputStream(this.dataBuf);
    private ByteArrayOutputStream headerBuf = new ByteArrayOutputStream(10);
    private DataOutputStream dHeaderBuf = new DataOutputStream(this.headerBuf);
    public double visioTrigger;
    private LinkedHashMap<String, Connection> connectionsByIdentificator = new LinkedHashMap();
    private HashMap<SocketChannel, Connection> connectionsByChannel = new HashMap();
    private Connection connectionToRenderer;
    private PoolingReceiver poolingReceiver;
    private LinkedHashSet<VisioCallbackListener> visioCallbackListeners = new LinkedHashSet();

    private void init() {
        this.visualizators = this.conf.getWorld().getVisio();
        this.visioTrigger = this.conf.getWorld().getVisioTrigger();
        this.angleMult = this.conf.getWorld().getAngleMult();
        this.angleAdd = this.conf.getWorld().getAngleAdd();
        this.angleMult2 = this.conf.getWorld().getAngleMult2();
        this.angleAdd2 = this.conf.getWorld().getAngleAdd2();
        this.angleMult3 = this.conf.getWorld().getAngleMult3();
        this.angleAdd3 = this.conf.getWorld().getAngleAdd3();
        this.swapAxisXY = this.conf.getWorld().getSwapAxisXY();
        this.XMult = this.conf.getWorld().getXMult() * this.conf.getWorld().getSizeX() / this.conf.getWorld().getMapSizeX();
        this.YMult = this.conf.getWorld().getYMult() * this.conf.getWorld().getSizeY() / this.conf.getWorld().getMapSizeY();
        this.ZMult = this.conf.getWorld().getZMult() * this.conf.getWorld().getSizeZ() / this.conf.getWorld().getMapSizeZ();
        this.XAdd = this.conf.getWorld().getXAdd();
        this.YAdd = this.conf.getWorld().getYAdd();
        this.ZAdd = this.conf.getWorld().getZAdd();
        this.objectIndexAllocator = new ObjectIndexAllocator(this.conf.getWorld().getMaxVisioID());
        for (Visio item : this.visualizators) {
            try {
                Connection c = new Connection(InetAddress.getByName(item.getIP()), item.getPort(), String.valueOf(item.getIP()) + ":" + item.getPort());
                this.connectionsByIdentificator.put(c.connectionDescription, c);
                this.connectionsByChannel.put(c.socketChannel, c);
                if (item.getIsRenderer() == 1) {
                    if (this.connectionToRenderer == null) {
                        this.connectionToRenderer = c;
                    } else {
                        this.logger.warning("Already has a renderer visio connection. Visio will not be used as rendere: " + item.getName());
                    }
                }
                this.logger.info("Connected to the visio '" + item.getName() + "' : " + item.getIP() + ":" + item.getPort());
            }
            catch (IOException ex1) {
                this.logger.warning("Cannot connect to visio Server '" + item.getName() + "'");
            }
        }
        if (this.connectionsByIdentificator.size() == 0) {
            this.findVisios(false);
        }
        if (!this.hasSomeRenderer()) {
            this.findVisios(true);
        }
        if (this.connectionsByIdentificator.size() == 0) {
            this.logger.info("No visio connected.");
        } else {
            try {
                this.poolingReceiver = new PoolingReceiver();
            }
            catch (IOException ex) {
                this.logger.severe("Visio Connection: Problem with creating receiving thread: " + ex.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallbackListener(VisioCallbackListener listener) {
        LinkedHashSet<VisioCallbackListener> linkedHashSet = this.visioCallbackListeners;
        synchronized (linkedHashSet) {
            this.visioCallbackListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterCallbackListener(VisioCallbackListener listener) {
        LinkedHashSet<VisioCallbackListener> linkedHashSet = this.visioCallbackListeners;
        synchronized (linkedHashSet) {
            this.visioCallbackListeners.remove(listener);
        }
    }

    public boolean isConnected() {
        return this.connectionsByIdentificator.size() > 0;
    }

    public boolean hasSomeRenderer() {
        return this.connectionToRenderer != null;
    }

    public VisioConnection(String confFileName) throws Exception {
        this.logger = Logger.getLogger("3Dvisio");
        try {
            this.conf = Configuration.getConfiguration(confFileName);
        }
        catch (Exception ex) {
            this.logger.warning(ex.toString());
            throw new Exception("Configuration file not found.");
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findVisios(boolean detectRendererVisio) {
        if (this.conf.getWorld().getAutoDetectVisio() == 0) {
            this.logger.info("Visio autolookup is disabled.");
            return;
        }
        if (!detectRendererVisio) {
            this.logger.info("Try find visio automatically.");
        }
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setBroadcast(true);
            socket.setSoTimeout(100);
            byte[] outBuf = (REQUEST + (!detectRendererVisio ? this.conf.getWorld().getScenarioName() : this.conf.getWorld().getRendererName())).getBytes();
            DatagramPacket dp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getLocalHost(), 5555);
            try {
                socket.send(dp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] rawLocalAddress = InetAddress.getLocalHost().getAddress();
            if (rawLocalAddress.length == 4) {
                int firstnumber = rawLocalAddress[0] < 0 ? 256 + rawLocalAddress[0] : rawLocalAddress[0];
                int subnet = 0;
                if (firstnumber <= 127) {
                    subnet = 3;
                } else if (firstnumber <= 191) {
                    subnet = 2;
                } else if (firstnumber <= 223) {
                    subnet = 1;
                }
                int i22 = 4 - subnet;
                while (i22 < 4) {
                    rawLocalAddress[i22] = -1;
                    ++i22;
                }
                dp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getByAddress(rawLocalAddress), 5555);
                try {
                    socket.send(dp);
                }
                catch (IOException i22) {
                    // empty catch block
                }
            }
            dp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getByName("255.255.255.255"), 5555);
            try {
                socket.send(dp);
            }
            catch (IOException firstnumber) {
                // empty catch block
            }
            VisioConnection firstnumber = this;
            synchronized (firstnumber) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException subnet) {
                    // empty catch block
                }
            }
            while (true) {
                try {
                    while (true) {
                        byte[] inBuf = new byte[1024];
                        DatagramPacket recdp = new DatagramPacket(inBuf, inBuf.length);
                        socket.receive(recdp);
                        String recstr = new String(recdp.getData(), 0, recdp.getLength() - 1);
                        InetAddress remoteAddress = ((InetSocketAddress)recdp.getSocketAddress()).getAddress();
                        int remotePort = Integer.parseInt(recstr);
                        String remoteVisio = String.valueOf(remoteAddress.getHostAddress()) + ":" + remotePort;
                        if (this.connectionsByIdentificator.containsKey(remoteVisio)) continue;
                        this.logger.info("Found visio : " + remoteAddress.getHostAddress() + ":" + remotePort);
                        try {
                            Connection c = new Connection(remoteAddress, remotePort, remoteVisio);
                            if (!detectRendererVisio) {
                                this.connectionsByIdentificator.put(c.connectionDescription, c);
                                this.connectionsByChannel.put(c.socketChannel, c);
                                continue;
                            }
                            if (this.connectionToRenderer == null) {
                                this.connectionsByIdentificator.put(c.connectionDescription, c);
                                this.connectionsByChannel.put(c.socketChannel, c);
                                if (!detectRendererVisio) continue;
                                this.connectionToRenderer = c;
                                continue;
                            }
                            if (!c.connectionDescription.equals(this.connectionToRenderer.connectionDescription)) continue;
                            this.logger.warning("Already has a renderer visio. Another detected will not be used: " + remoteVisio);
                        }
                        catch (IOException ex1) {
                            this.logger.warning("Cannot connect to this visio Server");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                break;
            }
        }
        catch (SocketTimeoutException socket) {
        }
        catch (UnknownHostException ex) {
            this.logger.severe("Cannot create broadcast packet: " + ex);
        }
        catch (SocketException ex) {
            Logger.getLogger("Container").severe("Socket creation error: " + ex);
        }
        catch (IOException ex) {
            Logger.getLogger("Container").severe("Socket send error: " + ex);
        }
    }

    private void sendBuffers() {
        ByteBuffer header = ByteBuffer.wrap(this.headerBuf.toByteArray());
        header.mark();
        ByteBuffer body = ByteBuffer.wrap(this.dataBuf.toByteArray());
        body.mark();
        int headerForSent = header.limit();
        int forSent = body.limit();
        Iterator<Map.Entry<String, Connection>> iter = this.connectionsByIdentificator.entrySet().iterator();
        while (iter.hasNext()) {
            Connection item = iter.next().getValue();
            boolean done = false;
            try {
                int sent;
                int totalSent = 0;
                while (totalSent + (sent = item.socketChannel.write(header)) < headerForSent) {
                    if (sent < 0) break;
                    totalSent += sent;
                    Thread.yield();
                }
                if (sent >= 0) {
                    totalSent = 0;
                    while (totalSent + (sent = item.socketChannel.write(body)) < forSent) {
                        if (sent < 0) break;
                        totalSent += sent;
                        Thread.yield();
                    }
                    if (sent >= 0) {
                        done = true;
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (done) continue;
            iter.remove();
            this.connectionsByChannel.remove(item.socketChannel);
        }
    }

    private void sendBuffersToRendererOnly() {
        if (this.connectionToRenderer == null) {
            return;
        }
        int headLen = this.headerBuf.size();
        int bodyLen = this.dataBuf.size();
        try {
            ByteBuffer bb = ByteBuffer.wrap(this.headerBuf.toByteArray());
            this.connectionToRenderer.socketChannel.write(bb);
            bb = ByteBuffer.wrap(this.dataBuf.toByteArray());
            this.connectionToRenderer.socketChannel.write(bb);
        }
        catch (IOException ex) {
            this.logger.severe(ex.toString());
            this.connectionToRenderer = null;
        }
    }

    public synchronized void sendReset() {
        this.objectIndexAllocator.clearObjectIndexBuffer();
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dHeaderBuf.writeByte(1);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, 0);
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized short sendCreateObject(String name, String typeName, String texture, double radius) {
        short objectIndex = this.objectIndexAllocator.allocateNextObjectIndex();
        if (!this.isConnected()) {
            return objectIndex;
        }
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dataBuf.write(name.getBytes());
            this.dDataBuf.writeByte(0);
            this.dataBuf.write(typeName.getBytes());
            this.dDataBuf.writeByte(0);
            this.dataBuf.write(texture.getBytes());
            this.dDataBuf.writeByte(0);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.min(Math.ceil(radius * Math.abs(this.XMult)), 65535.0));
            this.dHeaderBuf.writeByte(2);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return objectIndex;
    }

    public synchronized void sendDestroyObject(short objectIndex) {
        this.objectIndexAllocator.freeVisioID(objectIndex);
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dHeaderBuf.writeByte(3);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPostionUpdate(Position2D[] positions) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < positions.length) {
                if (positions[i].logged && positions[i].positionUpdated) {
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, positions[i].objectIndex);
                    if (this.swapAxisXY == 0) {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].X * this.XMult) + this.XAdd));
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].Y * this.YMult) + this.YAdd));
                    } else {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].Y * this.YMult) + this.YAdd));
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].X * this.XMult) + this.XAdd));
                    }
                    this.dDataBuf.writeByte((int)Math.ceil((positions[i].bearing * this.angleMult + this.angleAdd) * 40.74366543152521));
                    positions[i].positionUpdated = false;
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(4);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPostionUpdate(Position3D[] positions) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < positions.length) {
                if (positions[i].logged && positions[i].positionUpdated) {
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, positions[i].objectIndex);
                    if (this.swapAxisXY == 0) {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].X * this.XMult) + this.XAdd));
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].Y * this.YMult) + this.YAdd));
                    } else {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].Y * this.YMult) + this.YAdd));
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].X * this.XMult) + this.XAdd));
                    }
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(positions[i].Z * this.ZMult) + this.ZAdd));
                    this.dDataBuf.writeByte((int)Math.ceil((positions[i].angle1 * this.angleMult + this.angleAdd) * 40.74366543152521));
                    this.dDataBuf.writeByte((int)Math.ceil((positions[i].angle2 * this.angleMult2 + this.angleAdd2) * 40.74366543152521));
                    this.dDataBuf.writeByte((int)Math.ceil((positions[i].angle3 * this.angleMult3 + this.angleAdd3) * 40.74366543152521));
                    positions[i].positionUpdated = false;
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(5);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPostionUpdate(short[] objectIndexes, double[] x, double[] y, double[] z, double[] angle1, double[] angle2, double[] angle3) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < objectIndexes.length) {
                if (objectIndexes[i] >= 0) {
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndexes[i]);
                    if (this.swapAxisXY == 0) {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(x[i] * this.XMult) + this.XAdd));
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(y[i] * this.YMult) + this.YAdd));
                    } else {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(y[i] * this.YMult) + this.YAdd));
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(x[i] * this.XMult) + this.XAdd));
                    }
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(z[i] * this.ZMult) + this.ZAdd));
                    this.dDataBuf.writeByte((int)Math.ceil((angle1[i] * this.angleMult + this.angleAdd) * 40.74366543152521));
                    this.dDataBuf.writeByte((int)Math.ceil((angle2[i] * this.angleMult2 + this.angleAdd2) * 40.74366543152521));
                    this.dDataBuf.writeByte((int)Math.ceil((angle3[i] * this.angleMult3 + this.angleAdd3) * 40.74366543152521));
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(5);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPostionUpdateExt(Position3D[] positions) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < positions.length) {
                if (positions[i].logged && positions[i].positionUpdated) {
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, positions[i].objectIndex);
                    if (this.swapAxisXY == 0) {
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(positions[i].X * this.XMult) + this.XAdd));
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(positions[i].Y * this.YMult) + this.YAdd));
                    } else {
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(positions[i].Y * this.YMult) + this.YAdd));
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(positions[i].X * this.XMult) + this.XAdd));
                    }
                    VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(positions[i].Z * this.ZMult) + this.ZAdd));
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil((positions[i].angle1 * this.angleMult + this.angleAdd) * 10430.219195527361));
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil((positions[i].angle2 * this.angleMult2 + this.angleAdd2) * 10430.219195527361));
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil((positions[i].angle3 * this.angleMult3 + this.angleAdd3) * 10430.219195527361));
                    positions[i].positionUpdated = false;
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(18);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPostionUpdateExt(short[] objectIndexes, double[] x, double[] y, double[] z, double[] angle1, double[] angle2, double[] angle3) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < objectIndexes.length) {
                if (objectIndexes[i] >= 0) {
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndexes[i]);
                    if (this.swapAxisXY == 0) {
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(x[i] * this.XMult) + this.XAdd));
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(y[i] * this.YMult) + this.YAdd));
                    } else {
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(y[i] * this.YMult) + this.YAdd));
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(x[i] * this.XMult) + this.XAdd));
                    }
                    VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(z[i] * this.ZMult) + this.ZAdd));
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil((angle1[i] * this.angleMult + this.angleAdd) * 10430.219195527361));
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil((angle2[i] * this.angleMult2 + this.angleAdd2) * 10430.219195527361));
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil((angle3[i] * this.angleMult3 + this.angleAdd3) * 10430.219195527361));
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(18);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendObjectInfo(short objectIndex, String text) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.write(text.getBytes());
            this.dDataBuf.writeByte(0);
            this.dHeaderBuf.writeByte(6);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendCommunication(short from, short to, byte color) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.writeByte(color);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, from);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, to);
            this.dHeaderBuf.writeByte(7);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendLines(boolean[][] lineMatrix) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            short len = (short)lineMatrix.length;
            short i = 0;
            while (i < len) {
                short j = (short)(i + 1);
                while (j < len) {
                    if (lineMatrix[i][j]) {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, i);
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, j);
                    }
                    j = (short)(j + 1);
                }
                i = (short)(i + 1);
            }
            this.dHeaderBuf.writeByte(9);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendLinesFromBuf(ByteArrayOutputStream lineOutput) {
        this.headerBuf.reset();
        try {
            this.dHeaderBuf.writeByte(9);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, lineOutput.size());
            Iterator<Map.Entry<String, Connection>> iter = this.connectionsByIdentificator.entrySet().iterator();
            while (iter.hasNext()) {
                Connection item = iter.next().getValue();
                try {
                    item.socketChannel.write(ByteBuffer.wrap(this.headerBuf.toByteArray()));
                    item.socketChannel.write(ByteBuffer.wrap(lineOutput.toByteArray()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    iter.remove();
                    this.connectionsByChannel.remove(item.socketChannel);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendAgentInfo(String agentName, short baseObjectIndex) {
        this.sendAgentInfo(agentName, baseObjectIndex, new HashMap(), (byte)2);
    }

    public void sendAgentInfo(String agentName, short baseObjectIndex, Byte color) {
        this.sendAgentInfo(agentName, baseObjectIndex, new HashMap(), color);
    }

    public void sendAgentInfo(String agentName, short baseObjectIndex, Map params) {
        this.sendAgentInfo(agentName, baseObjectIndex, params, (byte)2);
    }

    public synchronized void sendAgentInfo(String agentName, short baseObjectIndex, Map params, Byte color) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.write(agentName.getBytes());
            this.dDataBuf.writeByte(0);
            this.dDataBuf.writeByte(color.byteValue());
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, baseObjectIndex);
            short len = (short)params.size();
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, len);
            for (String item : params.keySet()) {
                String value = (String)params.get(item);
                this.dDataBuf.write(item.getBytes());
                this.dDataBuf.writeByte(0);
                this.dDataBuf.write(value.getBytes());
                this.dDataBuf.writeByte(0);
            }
            this.dHeaderBuf.writeByte(10);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendRemoveAgent(String agentName) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.write(agentName.getBytes());
            this.dDataBuf.writeByte(0);
            this.dHeaderBuf.writeByte(11);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendShowAction(String agentName, short objectIndex, byte actionId) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.write(agentName.getBytes());
            this.dDataBuf.writeByte(0);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.writeByte(actionId);
            this.dHeaderBuf.writeByte(13);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSetRadius(short objectIndex, double newRadius) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.min(Math.ceil(newRadius * Math.abs(this.XMult)), 65535.0));
            this.dHeaderBuf.writeByte(14);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSetRadius2(short objectIndex, double newRadius) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.min(Math.ceil(newRadius * Math.abs(this.XMult)), 65535.0));
            this.dHeaderBuf.writeByte(15);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSetChart(short objectIndex, String chartName, Chart chartDefinition) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.write(chartName.getBytes());
            this.dDataBuf.writeByte(0);
            this.dDataBuf.writeByte(chartDefinition.getContent().size());
            for (ChartElement item : chartDefinition.getContent()) {
                if (item instanceof SimpleBar) {
                    SimpleBar sb = (SimpleBar)item;
                    this.dDataBuf.writeByte(1);
                    this.dDataBuf.write(sb.getName().getBytes());
                    this.dDataBuf.writeByte(0);
                    this.dDataBuf.writeByte(sb.getColor());
                    this.dDataBuf.writeByte(sb.getValue());
                    continue;
                }
                if (item instanceof ListBar) {
                    ListBar lb = (ListBar)item;
                    this.dDataBuf.writeByte(2);
                    this.dDataBuf.write(lb.getName().getBytes());
                    this.dDataBuf.writeByte(0);
                    this.dDataBuf.writeByte(lb.getListBarElement().size());
                    for (ListBarElement item1 : lb.getListBarElement()) {
                        this.dDataBuf.write(item1.getLabel().getBytes());
                        this.dDataBuf.writeByte(0);
                        this.dDataBuf.writeByte(item1.getColor());
                    }
                    continue;
                }
                throw new RuntimeException("VisioConnection: wrong object type in the chart content: " + item.getClass().toString());
            }
            this.dHeaderBuf.writeByte(16);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendRemoveChart(short objectIndex, String chartName) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.write(chartName.getBytes());
            this.dDataBuf.writeByte(0);
            this.dHeaderBuf.writeByte(17);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendPlanUpdate(PlanUpdate planUpdate, boolean virtual) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, planUpdate.objectIndex);
            this.dDataBuf.writeByte(virtual ? 1 : 0);
            this.dDataBuf.writeByte(planUpdate.deleteType);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, planUpdate.deleteSegmentID);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)planUpdate.segmentID.length);
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(planUpdate.blockWidth * this.XMult));
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(planUpdate.blockHeight * this.ZMult));
            int i = 0;
            while (i < planUpdate.segmentID.length) {
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, planUpdate.segmentID[i]);
                byte segmentType = planUpdate.segmentType[i];
                this.dDataBuf.writeByte(segmentType);
                switch (segmentType) {
                    case 1: {
                        if (this.swapAxisXY == 0) {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][0] * this.XMult) + this.XAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][1] * this.YMult) + this.YAdd));
                        } else {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][1] * this.YMult) + this.YAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][0] * this.XMult) + this.XAdd));
                        }
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][2] * this.ZMult) + this.ZAdd));
                        if (this.swapAxisXY == 0) {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][3] * this.XMult) + this.XAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][4] * this.YMult) + this.YAdd));
                        } else {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][4] * this.YMult) + this.YAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][3] * this.XMult) + this.XAdd));
                        }
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][5] * this.ZMult) + this.ZAdd));
                        break;
                    }
                    case 2: {
                        if (this.swapAxisXY == 0) {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][0] * this.XMult) + this.XAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][1] * this.YMult) + this.YAdd));
                        } else {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][1] * this.YMult) + this.YAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][0] * this.XMult) + this.XAdd));
                        }
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][2] * this.ZMult) + this.ZAdd));
                        if (this.swapAxisXY == 0) {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][3] * this.XMult) + this.XAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][4] * this.YMult) + this.YAdd));
                        } else {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][4] * this.YMult) + this.YAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][3] * this.XMult) + this.XAdd));
                        }
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][5] * this.ZMult) + this.ZAdd));
                        if (this.swapAxisXY == 0) {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][6] * this.XMult) + this.XAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][7] * this.YMult) + this.YAdd));
                        } else {
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][7] * this.YMult) + this.YAdd));
                            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][6] * this.XMult) + this.XAdd));
                        }
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(planUpdate.segmentDescription[i][8] * this.ZMult) + this.ZAdd));
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(planUpdate.segmentDescription[i][9] * 10430.219195527361 / 2.0 + 32768.0));
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(planUpdate.segmentDescription[i][10] * this.ZMult));
                        break;
                    }
                    default: {
                        this.logger.severe("Visio Connection: Unknown segment type: " + segmentType);
                    }
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(21);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendWaypoints(short objectIndex, boolean virtual, double[][] points, String[] timeInfos) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.writeByte(virtual ? 1 : 0);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)points.length);
            int i = 0;
            while (i < points.length) {
                if (this.swapAxisXY == 0) {
                    VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(points[i][0] * this.XMult) + this.XAdd));
                    VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(points[i][1] * this.YMult) + this.YAdd));
                } else {
                    VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(points[i][1] * this.YMult) + this.YAdd));
                    VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(points[i][0] * this.XMult) + this.XAdd));
                }
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(points[i][2] * this.ZMult) + this.ZAdd));
                this.dDataBuf.write(timeInfos[i].getBytes());
                this.dDataBuf.writeByte(0);
                ++i;
            }
            this.dHeaderBuf.writeByte(28);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendAssignZoneMesh(short objectIndex, short zoneID, double[] position, double[] rotation, double scale) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, zoneID);
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(position[0] * this.XMult));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(position[1] * this.YMult));
            } else {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(position[1] * this.YMult));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(position[0] * this.XMult));
            }
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(position[2] * this.ZMult));
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil(rotation[2] * 10430.219195527361));
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil(rotation[0] * 10430.219195527361));
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil(rotation[1] * 10430.219195527361));
            } else {
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil(rotation[1] * 10430.219195527361));
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)Math.ceil(rotation[0] * 10430.219195527361));
            }
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(scale * this.XMult));
            this.dHeaderBuf.writeByte(45);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void sendUserCommnad(byte command, byte[] content) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.write(content);
            this.dHeaderBuf.writeByte(command);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendObjectCrashed(short objectIndex) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dHeaderBuf.writeByte(29);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendDisplayTime(int time) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndianInt(this.dDataBuf, time);
            this.dHeaderBuf.writeByte(30);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendRelationInfoUpdate(short parentContainerID, String parentAgentName, String[] columnTitle, String[][] agentName, short[][] containerID, String[][] infoString, byte[][] infoColor) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, parentContainerID);
            this.dDataBuf.write(parentAgentName.getBytes());
            this.dDataBuf.writeByte(0);
            int columnCount = columnTitle.length;
            this.dDataBuf.writeByte(columnCount);
            int c = 0;
            while (c < columnCount) {
                this.dDataBuf.write(columnTitle[c].getBytes());
                this.dDataBuf.writeByte(0);
                int agentCount = agentName[c].length;
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)agentCount);
                int a = 0;
                while (a < agentCount) {
                    this.dDataBuf.write(agentName[c][a].getBytes());
                    this.dDataBuf.writeByte(0);
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, containerID[c][a]);
                    this.dDataBuf.write(infoString[c][a].getBytes());
                    this.dDataBuf.writeByte(0);
                    this.dDataBuf.writeByte(infoColor[c][a]);
                    ++a;
                }
                ++c;
            }
            this.dHeaderBuf.writeByte(31);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendAuxMakeLine(short lineID, double x1, double y1, double z1, double x2, double y2, double z2, byte r, byte g, byte b) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, lineID);
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(x1 * this.XMult) + this.XAdd));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(y1 * this.YMult) + this.YAdd));
            } else {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(y1 * this.YMult) + this.YAdd));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(x1 * this.XMult) + this.XAdd));
            }
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(z1 * this.ZMult) + this.ZAdd));
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(x2 * this.XMult) + this.XAdd));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(y2 * this.YMult) + this.YAdd));
            } else {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(y2 * this.YMult) + this.YAdd));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(x2 * this.XMult) + this.XAdd));
            }
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil(z2 * this.ZMult) + this.ZAdd));
            this.dDataBuf.writeByte(r);
            this.dDataBuf.writeByte(g);
            this.dDataBuf.writeByte(b);
            this.dHeaderBuf.writeByte(101);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendAuxHideLine(short lineID) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, lineID);
            this.dHeaderBuf.writeByte(102);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendNewSimulationSpeed(short speed) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, speed);
            this.dHeaderBuf.writeByte(22);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendScreenShot3DFree(short id, short width, short height, int[] cameraPositon, int[] cameraDirection, short[][] options) throws Exception {
        if (!this.hasSomeRenderer()) {
            throw new Exception("There isn't any connection to the renderer visio.");
        }
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, id);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, width);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, height);
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraPositon[0] * this.XMult));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraPositon[1] * this.YMult));
            } else {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraPositon[1] * this.YMult));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraPositon[0] * this.XMult));
            }
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraPositon[2] * this.ZMult));
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraDirection[0] * this.XMult));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraDirection[1] * this.YMult));
            } else {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraDirection[1] * this.YMult));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraDirection[0] * this.XMult));
            }
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraDirection[2] * this.ZMult));
            if (options == null) {
                this.dDataBuf.writeByte(0);
            } else {
                this.dDataBuf.writeByte(options.length);
                int i = 0;
                while (i < options.length) {
                    this.dDataBuf.writeByte((byte)options[i][0]);
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, options[i][1]);
                    ++i;
                }
            }
            this.dHeaderBuf.writeByte(24);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffersToRendererOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendScreenShot3DFocused(short id, short width, short height, short objectID, double[] cameraAngle, int cameraElevation, short cameraDistance, short[][] options) throws Exception {
        if (!this.hasSomeRenderer()) {
            throw new Exception("There isn't any connection to the renderer visio.");
        }
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, id);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, width);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, height);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectID);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(cameraAngle[0] * 10430.219195527361));
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(cameraAngle[1] * 10430.219195527361));
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraElevation * this.ZMult));
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil((double)cameraDistance * this.XMult));
            if (options == null) {
                this.dDataBuf.writeByte(0);
            } else {
                this.dDataBuf.writeByte(options.length);
                int i = 0;
                while (i < options.length) {
                    this.dDataBuf.writeByte((byte)options[i][0]);
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, options[i][1]);
                    ++i;
                }
            }
            this.dHeaderBuf.writeByte(25);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffersToRendererOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendScreenShot2DFree(short id, short width, short height, int[] cameraPositon, short cameraZoom, short[][] options) throws Exception {
        if (!this.hasSomeRenderer()) {
            throw new Exception("There isn't any connection to the renderer visio.");
        }
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, id);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, width);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, height);
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil((double)cameraPositon[0] * this.XMult) + this.XAdd));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil((double)cameraPositon[1] * this.YMult) + this.YAdd));
            } else {
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil((double)cameraPositon[1] * this.YMult) + this.YAdd));
                VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)(Math.ceil((double)cameraPositon[0] * this.XMult) + this.XAdd));
            }
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, cameraZoom);
            if (options == null) {
                this.dDataBuf.writeByte(0);
            } else {
                this.dDataBuf.writeByte(options.length);
                int i = 0;
                while (i < options.length) {
                    this.dDataBuf.writeByte((byte)options[i][0]);
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, options[i][1]);
                    ++i;
                }
            }
            this.dHeaderBuf.writeByte(26);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffersToRendererOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendScreenShot2DFocused(short id, short width, short height, short objectID, short cameraZoom, short[][] options) throws Exception {
        if (!this.hasSomeRenderer()) {
            throw new Exception("There isn't any connection to the renderer visio.");
        }
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, id);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, width);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, height);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectID);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, cameraZoom);
            if (options == null) {
                this.dDataBuf.writeByte(0);
            } else {
                this.dDataBuf.writeByte(options.length);
                int i = 0;
                while (i < options.length) {
                    this.dDataBuf.writeByte((byte)options[i][0]);
                    VisioConnection.writeLittleEndian16bit(this.dDataBuf, options[i][1]);
                    ++i;
                }
            }
            this.dHeaderBuf.writeByte(27);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffersToRendererOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSetZoneDimensions(short id, byte zoneIndex, double radius, double height) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, id);
            this.dDataBuf.writeByte(zoneIndex);
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(radius * this.XMult));
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(height * this.ZMult));
            this.dHeaderBuf.writeByte(34);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSetRadarRadius(short id, double radius) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, id);
            VisioConnection.writeLittleEndianInt(this.dDataBuf, (int)Math.ceil(radius * this.XMult));
            this.dHeaderBuf.writeByte(35);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendBatchInfo(short objectIndex, String text) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.writeByte(1);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.write(text.getBytes());
            this.dDataBuf.writeByte(0);
            this.dHeaderBuf.writeByte(37);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendBatchInfo(double x, double y, String text) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            this.dDataBuf.writeByte(2);
            if (this.swapAxisXY == 0) {
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(x * this.XMult) + this.XAdd));
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(y * this.YMult) + this.YAdd));
            } else {
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(y * this.YMult) + this.YAdd));
                VisioConnection.writeLittleEndian16bit(this.dDataBuf, (short)(Math.ceil(x * this.XMult) + this.XAdd));
            }
            this.dDataBuf.write(text.getBytes());
            this.dDataBuf.writeByte(0);
            this.dHeaderBuf.writeByte(37);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendShowRequestIDs(short objectIndex, LinkedList<String> reqIDs) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.writeByte(reqIDs.size());
            for (String reqID : reqIDs) {
                this.dDataBuf.write(reqID.getBytes());
                this.dDataBuf.writeByte(0);
            }
            this.dHeaderBuf.writeByte(40);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSetVisibility(short objectIndex, boolean visible) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            this.dDataBuf.writeByte(visible ? 1 : 0);
            this.dHeaderBuf.writeByte(43);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSpecialCarSteering(Position2D[] positions) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < positions.length) {
                if (positions[i] instanceof CarPosition2D) {
                    CarPosition2D carPosition = (CarPosition2D)positions[i];
                    if (carPosition.logged && carPosition.stearingUpdated) {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, carPosition.objectIndex);
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, 2);
                        this.dDataBuf.writeByte(2);
                        this.dDataBuf.writeByte((byte)Math.ceil(carPosition.stearing * 81.48733086305042));
                        carPosition.stearingUpdated = false;
                    }
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(8);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSpecialCarWheelRotation(Position2D[] positions) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            int i = 0;
            while (i < positions.length) {
                if (positions[i] instanceof CarPosition2D) {
                    CarPosition2D carPosition = (CarPosition2D)positions[i];
                    if (carPosition.logged && carPosition.wheelRotationUpdated) {
                        VisioConnection.writeLittleEndian16bit(this.dDataBuf, carPosition.objectIndex);
                        VisioConnection.writeLittleEndianInt(this.dDataBuf, 2);
                        this.dDataBuf.writeByte(1);
                        this.dDataBuf.writeByte(255 - carPosition.wheelRotation);
                        carPosition.wheelRotationUpdated = false;
                    }
                }
                ++i;
            }
            this.dHeaderBuf.writeByte(8);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSpecialCarLoad(short objectIndex, byte load) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, objectIndex);
            VisioConnection.writeLittleEndianInt(this.dDataBuf, 2);
            this.dDataBuf.writeByte(3);
            this.dDataBuf.writeByte(load);
            this.dHeaderBuf.writeByte(8);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendSpecialCarDock(short carObjectIndex, short destinationObjectIndex) {
        this.headerBuf.reset();
        this.dataBuf.reset();
        try {
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, carObjectIndex);
            VisioConnection.writeLittleEndianInt(this.dDataBuf, 3);
            this.dDataBuf.writeByte(4);
            VisioConnection.writeLittleEndian16bit(this.dDataBuf, destinationObjectIndex);
            this.dHeaderBuf.writeByte(8);
            VisioConnection.writeLittleEndianInt(this.dHeaderBuf, this.dataBuf.size());
            this.sendBuffers();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeAllConnections() {
        if (this.poolingReceiver != null) {
            this.poolingReceiver.shutdownReceiver();
        }
        Iterator<Map.Entry<String, Connection>> iter = this.connectionsByIdentificator.entrySet().iterator();
        while (iter.hasNext()) {
            Connection item = iter.next().getValue();
            try {
                item.socketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.connectionsByIdentificator.clear();
        this.connectionsByChannel.clear();
    }

    public static void writeLittleEndianInt(DataOutputStream dest, int num) {
        try {
            int i = 0;
            while (i < 4) {
                dest.writeByte(num & 0xFF);
                num >>= 8;
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeLittleEndian16bit(DataOutputStream dest, short num) {
        try {
            int i = 0;
            while (i < 2) {
                dest.writeByte(num & 0xFF);
                num = (short)(num >> 8);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Connection {
        private static final int HEADER_LENGTH = 5;
        private final SocketChannel socketChannel;
        private final Socket socket;
        private final String connectionDescription;
        private ByteBuffer inputBuffer;
        private boolean hasHeader = false;
        private byte msgType;
        private int msgSize;

        private Connection(InetAddress remoteAdress, int remotePort, String connectionDescription) throws SocketException, IOException {
            this.connectionDescription = connectionDescription;
            this.socketChannel = SocketChannel.open(new InetSocketAddress(remoteAdress, remotePort));
            this.socketChannel.configureBlocking(false);
            this.socket = this.socketChannel.socket();
            this.socket.setTcpNoDelay(true);
            this.socket.setTrafficClass(24);
            this.inputBuffer = ByteBuffer.allocate(1024);
        }

        private void testHeader() {
            if (this.hasHeader) {
                return;
            }
            if (this.inputBuffer.position() < 5) {
                return;
            }
            ByteBuffer in = this.inputBuffer.asReadOnlyBuffer();
            in.rewind();
            this.msgType = in.get();
            this.msgSize = this.readLittleEndianInt(in);
            this.hasHeader = true;
            if (this.msgSize + 5 > this.inputBuffer.capacity()) {
                ByteBuffer newBuffer = ByteBuffer.allocate(this.msgSize + 5);
                this.inputBuffer.flip();
                newBuffer.put(this.inputBuffer);
                this.inputBuffer = newBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse() {
            this.testHeader();
            if (!this.hasHeader) {
                return;
            }
            if (this.inputBuffer.position() >= 5 + this.msgSize) {
                ByteBuffer in = this.inputBuffer.asReadOnlyBuffer();
                in.position(5);
                switch (this.msgType) {
                    case 19: {
                        short objectID = this.readLittleEndian16bitShort(in);
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioPlanStart(objectID);
                            }
                            break;
                        }
                    }
                    case 20: {
                        short objectID = this.readLittleEndian16bitShort(in);
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioPlanStop(objectID);
                            }
                            break;
                        }
                    }
                    case 22: {
                        short speed = this.readLittleEndian16bitShort(in);
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioSetSimulationSpeed(speed);
                            }
                            break;
                        }
                    }
                    case 23: {
                        short scrShotID = this.readLittleEndian16bitShort(in);
                        int width = this.readLittleEndian16bitShort(in);
                        int height = this.readLittleEndian16bitShort(in);
                        BufferedImage im = new BufferedImage(width, height, 1);
                        int i = 0;
                        while (i < height) {
                            int j = 0;
                            while (j < width) {
                                int pixel = (in.get() & 0xFF) << 16 | (in.get() & 0xFF) << 8 | in.get() & 0xFF;
                                im.setRGB(j, i, pixel);
                                ++j;
                            }
                            ++i;
                        }
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioReceivedScreenShotData(scrShotID, im);
                            }
                            break;
                        }
                    }
                    case 32: {
                        String agentName = this.readString(in);
                        short containerID = this.readLittleEndian16bitShort(in);
                        LinkedHashSet height = VisioConnection.this.visioCallbackListeners;
                        synchronized (height) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioRelInfoStart(agentName, containerID);
                            }
                            break;
                        }
                    }
                    case 33: {
                        String agentName = this.readString(in);
                        short containerID = this.readLittleEndian16bitShort(in);
                        LinkedHashSet height = VisioConnection.this.visioCallbackListeners;
                        synchronized (height) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioRelInfoEnd(agentName, containerID);
                            }
                            break;
                        }
                    }
                    case 38: {
                        LinkedHashSet agentName = VisioConnection.this.visioCallbackListeners;
                        synchronized (agentName) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioSendRequestsIDsStart();
                            }
                            break;
                        }
                    }
                    case 39: {
                        LinkedHashSet agentName = VisioConnection.this.visioCallbackListeners;
                        synchronized (agentName) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioSendRequestsIDsEnd();
                            }
                            break;
                        }
                    }
                    case 41: {
                        String requestID = this.readString(in);
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioBatchInfoStart(requestID);
                            }
                            break;
                        }
                    }
                    case 42: {
                        String requestID = this.readString(in);
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            Iterator iter = VisioConnection.this.visioCallbackListeners.iterator();
                            while (iter.hasNext()) {
                                ((VisioCallbackListener)iter.next()).visioBatchInfoEnd(requestID);
                            }
                            break;
                        }
                    }
                    case 46: {
                        short containerID = this.readLittleEndian16bitShort(in);
                        LinkedHashSet linkedHashSet = VisioConnection.this.visioCallbackListeners;
                        synchronized (linkedHashSet) {
                            for (VisioCallbackListener elem : VisioConnection.this.visioCallbackListeners) {
                                elem.visioAircraftSelected(containerID);
                            }
                            break;
                        }
                    }
                    default: {
                        VisioConnection.this.logger.severe("Visio Connection: Received unknown command from visio: " + this.msgType);
                    }
                }
                this.inputBuffer.flip();
                this.inputBuffer.position(5 + this.msgSize);
                this.inputBuffer.compact();
                this.hasHeader = false;
                this.parse();
            }
        }

        private short readLittleEndian16bitShort(ByteBuffer src) {
            short retVal = 0;
            int i = 0;
            while (i < 2) {
                retVal = (short)(retVal | (src.get() & 0xFF) << i * 8);
                ++i;
            }
            return retVal;
        }

        private int readLittleEndianInt(ByteBuffer src) {
            int retVal = 0;
            int i = 0;
            while (i < 4) {
                retVal |= (src.get() & 0xFF) << i * 8;
                ++i;
            }
            return retVal;
        }

        private String readString(ByteBuffer src) {
            byte b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = src.get()) != 0) {
                baos.write(b);
            }
            return new String(baos.toByteArray());
        }
    }

    private class PoolingReceiver
    implements Runnable {
        private final Selector selector;
        private final Thread receivingThread;
        private boolean stop = false;
        private boolean finished = false;
        private Object stopLock = new Object();

        private PoolingReceiver() throws IOException {
            this.selector = Selector.open();
            Iterator iter = VisioConnection.this.connectionsByIdentificator.entrySet().iterator();
            while (iter.hasNext()) {
                Connection c = (Connection)iter.next().getValue();
                c.socketChannel.register(this.selector, 1);
            }
            this.receivingThread = AglobeThreadPool.getThread(this, "Visio Connection: Receiving Thread");
            this.receivingThread.setPriority(Math.min(5, 10));
            this.receivingThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void shutdownReceiver() {
            this.stop = true;
            this.selector.wakeup();
            Object object = this.stopLock;
            synchronized (object) {
                while (!this.finished) {
                    try {
                        this.stopLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                this.selector.close();
                return;
            }
            catch (IOException ex1) {
                VisioConnection.this.logger.severe("Visio Connection exception: " + ex1.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.stop) {
                    int numKeys = this.selector.select();
                    if (numKeys <= 0) continue;
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        Connection connection;
                        block10: {
                            SelectionKey rsk = iter.next();
                            int rskOps = rsk.readyOps();
                            if ((rskOps & 1) != 1) continue;
                            connection = (Connection)VisioConnection.this.connectionsByChannel.get(rsk.channel());
                            iter.remove();
                            if (connection == null) continue;
                            try {
                                if (connection.socketChannel.read(connection.inputBuffer) <= 0) {
                                    rsk.cancel();
                                    VisioConnection.this.connectionsByChannel.remove(connection.socketChannel);
                                    VisioConnection.this.connectionsByIdentificator.remove(connection.connectionDescription);
                                }
                                break block10;
                            }
                            catch (IOException ex1) {
                                rsk.cancel();
                                VisioConnection.this.connectionsByChannel.remove(connection.socketChannel);
                                VisioConnection.this.connectionsByIdentificator.remove(connection.connectionDescription);
                            }
                            continue;
                        }
                        connection.parse();
                    }
                }
            }
            catch (IOException ex) {
                VisioConnection.this.logger.severe("Visio connection exception: " + ex.toString());
            }
            Object object = this.stopLock;
            synchronized (object) {
                this.finished = true;
                this.stopLock.notify();
            }
        }
    }
}

