/*
 * Decompiled with CFR 0.152.
 */
package aglobe.visio3D;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PlanUpdate
implements Externalizable {
    public static final byte DELETE_TYPE_NO_ACTION = 0;
    public static final byte DELETE_TYPE_DELETE_BEFORE = 1;
    public static final byte DELETE_TYPE_DELETE_AFTER = 2;
    public static final byte DELETE_TYPE_DELETE_ALL = 3;
    public static final byte SEGMENT_TYPE_LINE = 1;
    public static final byte SEGMENT_TYPE_ARC = 2;
    public short objectIndex;
    public byte deleteType;
    public short deleteSegmentID;
    public double blockWidth;
    public double blockHeight;
    public short[] segmentID;
    public byte[] segmentType;
    public double[][] segmentDescription;

    public PlanUpdate() {
    }

    public PlanUpdate(short objectIndex, byte deleteType, short deleteSegmentID, double blockWidth, double blockHeight, short addSegments) {
        this.objectIndex = objectIndex;
        this.deleteType = deleteType;
        this.deleteSegmentID = deleteSegmentID;
        this.blockWidth = blockWidth;
        this.blockHeight = blockHeight;
        this.segmentID = new short[addSegments];
        this.segmentType = new byte[addSegments];
        this.segmentDescription = new double[addSegments][];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlanUpdate for object index: ");
        sb.append(this.objectIndex);
        sb.append("\n");
        if (this.deleteType != 0) {
            sb.append("First delete ");
            switch (this.deleteType) {
                case 3: {
                    sb.append("ALL OLD PLAN\n");
                    break;
                }
                case 1: {
                    sb.append("BEFORE segment ID: ");
                    sb.append(this.deleteSegmentID);
                    break;
                }
                case 2: {
                    sb.append("AFTER segment ID: ");
                    sb.append(this.deleteSegmentID);
                    break;
                }
                default: {
                    sb.append("UNKNOWN TYPE ");
                    sb.append(this.deleteType);
                }
            }
            sb.append("\n");
        }
        if (this.segmentID.length > 0) {
            sb.append("Block width: ").append(this.blockWidth).append("\nBlock height: ").append(this.blockHeight).append("\n");
            sb.append("Then add new plan with following plan segments:\n");
            int i = 0;
            while (i < this.segmentID.length) {
                sb.append("SegmentID ");
                sb.append(this.segmentID[i]);
                sb.append(": ");
                switch (this.segmentType[i]) {
                    case 1: {
                        sb.append("LINE from [");
                        sb.append(this.segmentDescription[i][0]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][1]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][2]);
                        sb.append("] to [");
                        sb.append(this.segmentDescription[i][3]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][4]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][5]);
                        sb.append("]");
                        break;
                    }
                    case 2: {
                        sb.append("ARC center [");
                        sb.append(this.segmentDescription[i][0]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][1]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][2]);
                        sb.append("] major radius end point [");
                        sb.append(this.segmentDescription[i][3]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][4]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][5]);
                        sb.append("] minor radius end point [");
                        sb.append(this.segmentDescription[i][6]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][7]);
                        sb.append(",");
                        sb.append(this.segmentDescription[i][8]);
                        sb.append("] with angle ");
                        sb.append(this.segmentDescription[i][9]);
                        sb.append(" rad (");
                        sb.append(this.segmentDescription[i][9] * 180.0 / Math.PI);
                        sb.append("\u00b0)");
                        sb.append(" elevation ");
                        sb.append(this.segmentDescription[i][10]);
                        break;
                    }
                    default: {
                        sb.append("UNKNOWN TYPE ");
                        sb.append(this.segmentType[i]);
                    }
                }
                sb.append("\n");
                ++i;
            }
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.objectIndex);
        out.writeByte(this.deleteType);
        out.writeShort(this.deleteSegmentID);
        out.writeDouble(this.blockWidth);
        out.writeDouble(this.blockHeight);
        int segmets = this.segmentID.length;
        out.writeInt(segmets);
        if (segmets > 0) {
            int i = 0;
            while (i < segmets) {
                out.writeShort(this.segmentID[i]);
                out.writeByte(this.segmentType[i]);
                int descriptions = this.segmentDescription[i].length;
                out.writeInt(descriptions);
                int j = 0;
                while (j < descriptions) {
                    out.writeDouble(this.segmentDescription[i][j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.objectIndex = in.readShort();
        this.deleteType = in.readByte();
        this.deleteSegmentID = in.readShort();
        this.blockWidth = in.readDouble();
        this.blockHeight = in.readDouble();
        int segments = in.readInt();
        this.segmentID = new short[segments];
        this.segmentType = new byte[segments];
        this.segmentDescription = new double[segments][];
        if (segments > 0) {
            int i = 0;
            while (i < segments) {
                this.segmentID[i] = in.readShort();
                this.segmentType[i] = in.readByte();
                int descriptions = in.readInt();
                this.segmentDescription[i] = new double[descriptions];
                int j = 0;
                while (j < descriptions) {
                    this.segmentDescription[i][j] = in.readDouble();
                    ++j;
                }
                ++i;
            }
        }
    }
}

