/*
 * Decompiled with CFR 0.152.
 */
package aglobe.visio3D;

public class ObjectIndexAllocator {
    private boolean[] usedVisioID;
    private short currentVisioID = 0;

    public ObjectIndexAllocator(short maxVisioID) {
        this.usedVisioID = new boolean[maxVisioID];
    }

    public synchronized void clearObjectIndexBuffer() {
        this.usedVisioID = new boolean[this.usedVisioID.length];
    }

    public synchronized short allocateNextObjectIndex() {
        while (this.usedVisioID[this.currentVisioID]) {
            this.currentVisioID = (short)((this.currentVisioID + 1) % this.usedVisioID.length);
        }
        this.usedVisioID[this.currentVisioID] = true;
        return this.currentVisioID;
    }

    public synchronized void freeVisioID(short objectIndex) {
        if (objectIndex >= 0) {
            this.usedVisioID[objectIndex] = false;
        }
    }
}

