/*
 * Decompiled with CFR 0.152.
 */
package aglobe.visio3D;

import aglobe.util.AglobeXMLtools;
import aglobe.visio3D.ontology.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.bind.UnmarshalException;

final class Configuration {
    private static Configuration instance;
    private World world;

    private Configuration(String fName) throws Exception {
        if (fName == null) {
            throw new Exception("Missing configuration filename !!!");
        }
        File file = new File(fName);
        if (!file.exists()) {
            throw new Exception("Configuration file not found !!! (" + fName + ")");
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            this.world = (World)AglobeXMLtools.unmarshallJAXBObject(World.class, fis);
            fis.close();
        }
        catch (FileNotFoundException ex) {
            throw new Exception("Configuration file not found !!! (" + fName + ")");
        }
        catch (UnmarshalException ex) {
            throw new Exception("Format of the configuration file is wrong !!!");
        }
    }

    static Configuration getConfiguration(String fName) throws Exception {
        if (instance == null) {
            instance = new Configuration(fName);
        }
        return instance;
    }

    public String toString() {
        return this.world.toString();
    }

    public World getWorld() {
        return this.world;
    }
}

