/*
 * Decompiled with CFR 0.152.
 */
package aglobe.visio3D;

import aglobe.visio3D.Position2D;

public final class CarPosition2D
extends Position2D {
    public static double MAX_STEARING = 0.7853981633974483;
    public static double MIN_STEARING = -0.7853981633974483;
    public boolean stearingUpdated = true;
    public double stearing;
    public boolean wheelRotationUpdated = true;
    public byte wheelRotation;

    public CarPosition2D(short objectIndex, double startBearing) {
        super(objectIndex, startBearing);
    }

    public void setNewPosition(double X, double Y) {
        if (this.X == X && this.Y == Y) {
            return;
        }
        double dX = X - this.X;
        double dY = Y - this.Y;
        byte newWheelRotation = (byte)((this.wheelRotation + (int)(Math.sqrt(dX * dX + dY * dY) * 256.0 / 20.0)) % 256);
        this.X = X;
        this.Y = Y;
        this.bearing = this.bearing;
        this.positionUpdated = true;
        if (newWheelRotation != this.wheelRotation) {
            this.wheelRotation = newWheelRotation;
            this.wheelRotationUpdated = true;
        }
    }

    public void computeStearing(double nextSegmentBearing) {
        if (nextSegmentBearing == Double.MAX_VALUE) {
            return;
        }
        double newStearing = (nextSegmentBearing - this.bearing) * 2.0;
        if (newStearing > MAX_STEARING) {
            newStearing = MAX_STEARING;
        }
        if (newStearing < MIN_STEARING) {
            newStearing = MIN_STEARING;
        }
        if (newStearing == this.stearing) {
            return;
        }
        this.stearing = newStearing;
        this.stearingUpdated = true;
    }
}

