/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SearchableTextArea
extends JPanel {
    private JTextArea textArea = new JTextArea();
    private JScrollPane jScrollPane = new JScrollPane();
    private JPanel findPanel = new JPanel(new FlowLayout(3));
    private JLabel label = new JLabel("Find:");
    private JTextField textField = new JTextField(30);
    private JButton findButton = new JButton("Find");
    private JRadioButton forward = new JRadioButton("  Forward", true);
    private JRadioButton backward = new JRadioButton("  Backward", false);
    private JButton clearButton = new JButton("Clear");
    private JCheckBox lineWrap = new JCheckBox("  LineWrap", false);
    private BufferedWriter log = null;

    public SearchableTextArea() {
        this(false, true, null);
    }

    public SearchableTextArea(String textFile) {
        this(false, true, textFile);
    }

    public SearchableTextArea(boolean isTop) {
        this(isTop, true, null);
    }

    public SearchableTextArea(boolean isTop, String textFile) {
        this(isTop, true, textFile);
    }

    public SearchableTextArea(boolean isTop, boolean lineWr) {
        this(isTop, lineWr, null);
    }

    public SearchableTextArea(boolean isTop, boolean lineWr, String textFile) {
        super(new BorderLayout());
        if (isTop) {
            this.add((Component)this.findPanel, "North");
        } else {
            this.add((Component)this.findPanel, "South");
        }
        this.add(this.jScrollPane);
        this.jScrollPane.setViewportView(this.textArea);
        this.textArea.setEditable(false);
        this.textArea.setText("");
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        if (!lineWr) {
            this.jScrollPane.setHorizontalScrollBarPolicy(32);
        }
        this.findPanel.add(this.label);
        this.findPanel.add(this.textField);
        this.findPanel.add(this.findButton);
        this.findPanel.add(this.forward);
        this.findPanel.add(this.backward);
        this.findPanel.add(this.clearButton);
        this.findPanel.add(this.lineWrap);
        ButtonGroup group = new ButtonGroup();
        group.add(this.forward);
        group.add(this.backward);
        this.lineWrap.setSelected(lineWr);
        this.textArea.setLineWrap(lineWr);
        this.textArea.getCaret().setDot(0);
        this.lineWrap.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchableTextArea.this.lineWrap.setSelected(true);
                    SearchableTextArea.this.textArea.setLineWrap(true);
                    SearchableTextArea.this.jScrollPane.setHorizontalScrollBarPolicy(31);
                } else {
                    SearchableTextArea.this.lineWrap.setSelected(false);
                    SearchableTextArea.this.textArea.setLineWrap(false);
                    SearchableTextArea.this.jScrollPane.setHorizontalScrollBarPolicy(32);
                }
            }
        });
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchableTextArea.this.findButtonEvent(e);
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SearchableTextArea.this.textArea.setText("");
            }
        });
        if (textFile != null && !textFile.equals("")) {
            try {
                this.log = new BufferedWriter(new FileWriter(textFile));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void append(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchableTextArea.this.textArea.append(text);
                JScrollBar vert = SearchableTextArea.this.jScrollPane.getVerticalScrollBar();
                vert.setValue(vert.getMaximum() - vert.getVisibleAmount());
            }
        });
        if (this.log != null) {
            try {
                this.log.write(text);
                this.log.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void appendLine(String text) {
        this.append(String.valueOf(text) + "\n");
    }

    private void findButtonEvent(ActionEvent e) {
        if (this.textField.getText().length() == 0) {
            return;
        }
        int idx = this.forward.isSelected() ? this.textArea.getText().indexOf(this.textField.getText(), this.textArea.getCaretPosition()) : this.textArea.getText().lastIndexOf(this.textField.getText(), this.textArea.getCaretPosition() - this.textField.getText().length() - 1);
        if (idx >= 0) {
            this.textArea.getCaret().setDot(idx);
            this.textArea.getCaret().moveDot(idx + this.textField.getText().length());
            this.textArea.getCaret().setSelectionVisible(true);
        }
    }
}

