/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util.gui;

import aglobe.container.Store;
import aglobe.container.StoreOwner;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public abstract class RememberPositionJFrame
extends JFrame {
    protected static final String GUI_X = "gui/x";
    protected static final String GUI_Y = "gui/y";
    protected static final String GUI_W = "gui/w";
    protected static final String GUI_H = "gui/h";
    protected static final String GUI_DIVIDER = "gui/divider";
    protected Store store;
    private boolean loadingWindowPosition;
    private boolean visible = false;

    public RememberPositionJFrame(StoreOwner storeOwner) {
        this.store = storeOwner.getStore();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                RememberPositionJFrame.this.this_componentMoved(e);
            }

            public void componentResized(ComponentEvent e) {
                RememberPositionJFrame.this.this_componentResized(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (RememberPositionJFrame.this.visible) {
                    RememberPositionJFrame.this.saveWindowPosition();
                }
            }
        });
    }

    protected void saveWindowSettings() {
    }

    protected void loadWindowSettings() {
    }

    private void loadWindowPosition() {
        this.loadingWindowPosition = true;
        Point p = this.getLocation();
        p.x = this.store.getInt(GUI_X, p.x);
        p.y = this.store.getInt(GUI_Y, p.y);
        this.setLocation(p);
        Dimension d = this.getSize();
        d.width = this.store.getInt(GUI_W, d.width);
        d.height = this.store.getInt(GUI_H, d.height);
        this.setSize(d.width, d.height);
        this.loadWindowSettings();
        this.loadingWindowPosition = false;
    }

    private void saveWindowPosition() {
        if (!this.loadingWindowPosition) {
            Point p = this.getLocation();
            this.store.putInt(GUI_X, p.x);
            this.store.putInt(GUI_Y, p.y);
            Dimension d = this.getSize();
            this.store.putInt(GUI_W, d.width);
            this.store.putInt(GUI_H, d.height);
            this.saveWindowSettings();
        }
    }

    public void setVisible(boolean b) {
        if (!b) {
            this.saveWindowPosition();
        } else {
            this.loadWindowPosition();
        }
        this.visible = b;
        super.setVisible(b);
    }

    private void this_componentMoved(ComponentEvent e) {
        this.saveWindowPosition();
    }

    private void this_componentResized(ComponentEvent e) {
        this.saveWindowPosition();
    }
}

