/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util.fileinputtextfield;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileInputTextField
extends JPanel {
    private JTextField fileNameTextField = new JTextField();
    private JButton fileChooserButton = new JButton();
    private JFileChooser fc = new JFileChooser();
    private FileFilter[] fileFilters;
    private String currentDirectory;
    private transient Vector<TextListener> textListeners;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private int columns;
    private transient PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);

    public FileInputTextField(FileFilter[] filters) {
        this();
        this.setFileFilters(filters);
    }

    public FileInputTextField(String dir, FileFilter[] filters) {
        this();
        this.setFileFilters(filters);
        this.setCurrentDirectory(dir);
    }

    public FileInputTextField(String dir) {
        this();
        this.setCurrentDirectory(dir);
    }

    public FileInputTextField() {
        try {
            this.jbInit();
            Dimension tp = this.fileNameTextField.getPreferredSize();
            Dimension tb = this.fileChooserButton.getPreferredSize();
            tb.height = tp.height;
            this.fileChooserButton.setPreferredSize(tb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.fileChooserButton.setText("...");
        this.fileChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInputTextField.this.fileChooserButton_actionPerformed(e);
            }
        });
        this.fileNameTextField.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                FileInputTextField.this.fileNameTextField_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent inputmethodevent) {
            }
        });
        this.add((Component)this.fileNameTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 1), 0, 0));
        this.add((Component)this.fileChooserButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setFileFilters(FileFilter[] fileFilters) {
        this.fileFilters = fileFilters;
        int i = 0;
        while (i < fileFilters.length) {
            this.fc.addChoosableFileFilter(fileFilters[i]);
            ++i;
        }
    }

    public FileFilter[] getFileFilters() {
        return this.fileFilters;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
        this.fc.setCurrentDirectory(new File(currentDirectory));
    }

    public String getCurrentDirectory() {
        return this.fc.getCurrentDirectory().getAbsolutePath();
    }

    public synchronized void removeTextListener(TextListener l) {
        if (this.textListeners != null && this.textListeners.contains(l)) {
            Vector<TextListener> v = new Vector<TextListener>(this.textListeners);
            v.removeElement(l);
            this.textListeners = v;
        }
    }

    public synchronized void addTextListener(TextListener l) {
        Vector<TextListener> v;
        Vector<TextListener> vector = v = this.textListeners != null ? new Vector<TextListener>(this.textListeners) : new Vector(2);
        if (!v.contains(l)) {
            v.addElement(l);
            this.textListeners = v;
        }
    }

    public String getText() {
        return this.fileNameTextField.getText();
    }

    public void setText(String newtext) {
        this.fileNameTextField.setText(newtext);
    }

    protected void fireTextValueChanged(TextEvent e) {
        if (this.textListeners != null) {
            Vector<TextListener> listeners = this.textListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                listeners.elementAt(i).textValueChanged(e);
                ++i;
            }
        }
    }

    void fileNameTextField_inputMethodTextChanged(InputMethodEvent e) {
        if (e.getID() == 1100) {
            this.fireTextValueChanged(new TextEvent(this, 900));
        }
    }

    void fileChooserButton_actionPerformed(ActionEvent e) {
        File file;
        int retVal = this.fc.showOpenDialog(this);
        if (retVal == 0 && (file = this.fc.getSelectedFile()) != null) {
            this.fileNameTextField.setText(file.getAbsolutePath());
        }
    }

    public void setColumns(int columns) {
        int oldColumns = this.columns;
        this.columns = columns;
        this.fileNameTextField.setColumns(columns);
        this.propertyChangeListeners.firePropertyChange("columns", new Integer(oldColumns), new Integer(columns));
    }

    public int getColumns() {
        return this.fileNameTextField.getColumns();
    }
}

