/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util.concurrent;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonblockingFixedArrayFIFO<E> {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final Unsafe unsafe;
    private static final long markOffset;
    private static final long arrayContentBase;
    private static final long arrayContentScale;
    private final Object[] array;
    private volatile long mark;
    private final int capacityPlus1;
    private final long lengthMask;

    static {
        try {
            unsafe = NonblockingFixedArrayFIFO.getUnsafe();
            markOffset = unsafe.objectFieldOffset(NonblockingFixedArrayFIFO.class.getDeclaredField("mark"));
            arrayContentBase = unsafe.arrayBaseOffset(Object[].class);
            arrayContentScale = unsafe.arrayIndexScale(Object[].class);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static Unsafe getUnsafe() throws IllegalAccessException, IllegalArgumentException {
        Unsafe retVal = null;
        Class<Unsafe> uc = Unsafe.class;
        Field[] fields = uc.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals("theUnsafe")) {
                fields[i].setAccessible(true);
                retVal = (Unsafe)fields[i].get(uc);
                break;
            }
            ++i;
        }
        if (retVal == null) {
            throw new Error("Cannot fetch Unsafe for atomic fast operations");
        }
        return retVal;
    }

    public NonblockingFixedArrayFIFO(int minCapacity) {
        if (minCapacity <= 0 || minCapacity >= 0x20000000) {
            throw new IndexOutOfBoundsException("0 < capacity < 2^30-1");
        }
        int c = 2;
        long mask = 1L;
        while (c < minCapacity) {
            c <<= 1;
            mask <<= 1;
            mask |= 1L;
        }
        this.capacityPlus1 = c;
        this.lengthMask = mask;
        this.array = new Object[this.capacityPlus1];
    }

    public int capacity() {
        return this.capacityPlus1 - 1;
    }

    public int size() {
        long m = this.mark;
        int curTail = (int)(m & this.lengthMask);
        int curHead = (int)(m >> 32 & this.lengthMask);
        if (curTail == curHead) {
            return 0;
        }
        return (curTail | this.capacityPlus1) - curHead & (int)this.lengthMask;
    }

    public boolean push(E object) {
        long arrayPos;
        long nextTailV;
        long curHeadV;
        long m;
        if (object == null) {
            throw new NullPointerException("FIFO cannot hold null object");
        }
        do {
            m = this.mark;
            long curTailV = m & 0xFFFFFFFFL;
            long curTailPos = curTailV & this.lengthMask;
            curHeadV = m >> 32 & 0xFFFFFFFFL;
            long curHeadPos = curHeadV & this.lengthMask;
            nextTailV = curTailV + 1L & 0xFFFFFFFFL;
            long nextTailPos = nextTailV & this.lengthMask;
            if (curHeadPos == nextTailPos) {
                return false;
            }
            arrayPos = arrayContentBase + arrayContentScale * curTailPos;
            Object tailObject = unsafe.getObjectVolatile(this.array, arrayPos);
            if (tailObject == null || m != this.mark) continue;
            return false;
        } while (!unsafe.compareAndSwapLong(this, markOffset, m, curHeadV << 32 | nextTailV));
        unsafe.putObjectVolatile(this.array, arrayPos, object);
        return true;
    }

    public E pop() {
        Object headObject;
        long arrayPos;
        long curTailV;
        long nextHeadV;
        long m;
        do {
            long curTailPos;
            long curHeadV;
            long curHeadPos;
            if ((curHeadPos = (curHeadV = (m = this.mark) >> 32 & 0xFFFFFFFFL) & this.lengthMask) == (curTailPos = (curTailV = m & 0xFFFFFFFFL) & this.lengthMask)) {
                return null;
            }
            nextHeadV = curHeadV + 1L & 0xFFFFFFFFL;
            arrayPos = arrayContentBase + arrayContentScale * curHeadPos;
            headObject = unsafe.getObjectVolatile(this.array, arrayPos);
            if (headObject != null) continue;
            return null;
        } while (!unsafe.compareAndSwapLong(this, markOffset, m, nextHeadV << 32 | curTailV));
        unsafe.putObjectVolatile(this.array, arrayPos, null);
        return (E)headObject;
    }
}

