/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util.concurrent;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonblockingArrayFIFO<E> {
    private static final long POS_MASK = 0x3FFFFFFFL;
    private static final long BANK_MASK = 15L;
    private static final int INIT_BACKEND_SIZE = 1024;
    private static final Unsafe unsafe;
    private static final long markOffset;
    private static final long nextBankOffset;
    private static final long arrayContentBase;
    private static final long arrayContentScale;
    private volatile int nextBank = 1;
    private volatile Object[] bank0 = new Object[1024];
    private volatile Object[] bank1;
    private volatile long mark = 0L;
    private final int maxCapacity;

    static {
        try {
            unsafe = NonblockingArrayFIFO.getUnsafe();
            markOffset = unsafe.objectFieldOffset(NonblockingArrayFIFO.class.getDeclaredField("mark"));
            nextBankOffset = unsafe.objectFieldOffset(NonblockingArrayFIFO.class.getDeclaredField("nextBank"));
            arrayContentBase = unsafe.arrayBaseOffset(Object[].class);
            arrayContentScale = unsafe.arrayIndexScale(Object[].class);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static Unsafe getUnsafe() throws IllegalAccessException, IllegalArgumentException {
        Unsafe retVal = null;
        Class<Unsafe> uc = Unsafe.class;
        Field[] fields = uc.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals("theUnsafe")) {
                fields[i].setAccessible(true);
                retVal = (Unsafe)fields[i].get(uc);
                break;
            }
            ++i;
        }
        if (retVal == null) {
            throw new Error("Cannot fetch Unsafe for atomic fast operations");
        }
        return retVal;
    }

    public NonblockingArrayFIFO(int maxCapacity) {
        int c = 1;
        while (c < maxCapacity) {
            c <<= 1;
        }
        if (c > 0x40000000) {
            throw new IndexOutOfBoundsException("Max capacity can be 2^30");
        }
        this.maxCapacity = c;
    }

    public int capacity() {
        long m;
        Object[] curBuf;
        while ((curBuf = ((m = this.mark) & 0xFL) == 0L ? this.bank0 : this.bank1) == null) {
        }
        return curBuf.length - 1;
    }

    public int size() {
        long m;
        Object[] curBuf;
        while ((curBuf = ((m = this.mark) & 0xFL) == 0L ? this.bank0 : this.bank1) == null) {
        }
        long lengthMask = curBuf.length - 1;
        int curTail = (int)(m >> 4 & lengthMask);
        int curHead = (int)(m >> 34 & lengthMask);
        if (curTail == curHead) {
            return 0;
        }
        return (curTail | curBuf.length) - curHead & (int)lengthMask;
    }

    public boolean push(E object) {
        long arrayPos;
        long bankId;
        Object[] curBuf;
        if (object == null) {
            throw new NullPointerException("FIFO cannot hold null object");
        }
        Object[] newBuf = null;
        while (true) {
            Object tailObject;
            long m;
            if ((curBuf = (bankId = (m = this.mark) & 0xFL) == 0L ? this.bank0 : this.bank1) == null) {
                continue;
            }
            long lengthMask = curBuf.length - 1;
            long curTailV = m >> 4 & 0x3FFFFFFFL;
            long curTailPos = curTailV & lengthMask;
            long curHeadV = m >> 34 & 0x3FFFFFFFL;
            long curHeadPos = curHeadV & lengthMask;
            long nextTailV = curTailV + 1L & 0x3FFFFFFFL;
            long nextTailPos = nextTailV & lengthMask;
            if (curHeadPos == nextTailPos) {
                long newBankHead;
                long lastLength = curBuf.length;
                long newLength = curBuf.length << 1;
                if (newLength > (long)this.maxCapacity) {
                    return false;
                }
                bankId = this.nextBank;
                if (bankId < 0L || !unsafe.compareAndSwapInt(this, nextBankOffset, (int)bankId, -1)) {
                    return false;
                }
                if (newBuf == null || (long)newBuf.length != newLength) {
                    newBuf = new Object[(int)newLength];
                }
                if (bankId == 0L) {
                    this.bank0 = newBuf;
                } else {
                    this.bank1 = newBuf;
                }
                boolean transpose = false;
                long newBankTail = curTailPos + 1L;
                if (curTailPos < curHeadPos) {
                    transpose = true;
                    newBankHead = curHeadPos + lastLength;
                } else {
                    newBankHead = curHeadPos;
                }
                if (unsafe.compareAndSwapLong(this, markOffset, m, newBankHead << 34 | newBankTail << 4 | bankId)) {
                    Object o;
                    unsafe.putObjectVolatile(newBuf, arrayContentBase + arrayContentScale * curTailPos, object);
                    if (!transpose) {
                        long arrayPos2 = arrayContentBase + arrayContentScale * curHeadPos;
                        m = curHeadPos;
                        while (m < curTailPos) {
                            Object o2 = unsafe.getObjectVolatile(curBuf, arrayPos2);
                            if (o2 != null) {
                                unsafe.putObjectVolatile(newBuf, arrayPos2, o2);
                            }
                            arrayPos2 += arrayContentScale;
                            ++m;
                        }
                        this.nextBank = (int)bankId ^ 1;
                        return true;
                    }
                    long oldPnt = arrayContentBase + arrayContentScale * curHeadPos;
                    long newPnt = arrayContentBase + arrayContentScale * newBankHead;
                    m = curHeadPos;
                    while (m < lastLength) {
                        o = unsafe.getObjectVolatile(curBuf, oldPnt);
                        if (o != null) {
                            unsafe.putObjectVolatile(newBuf, newPnt, o);
                        }
                        oldPnt += arrayContentScale;
                        newPnt += arrayContentScale;
                        ++m;
                    }
                    oldPnt = arrayContentBase;
                    m = 0L;
                    while (m < curTailPos) {
                        o = unsafe.getObjectVolatile(curBuf, oldPnt);
                        if (o != null) {
                            unsafe.putObjectVolatile(newBuf, oldPnt, o);
                        }
                        oldPnt += arrayContentScale;
                        ++m;
                    }
                    this.nextBank = (int)bankId ^ 1;
                    return true;
                }
                this.nextBank = (int)bankId;
            }
            if ((tailObject = unsafe.getObjectVolatile(curBuf, arrayPos = arrayContentBase + arrayContentScale * curTailPos)) != null && m == this.mark) {
                return false;
            }
            if (unsafe.compareAndSwapLong(this, markOffset, m, curHeadV << 34 | nextTailV << 4 | bankId)) break;
        }
        while (true) {
            if (curBuf != null) {
                unsafe.putObjectVolatile(curBuf, arrayPos, object);
                if (bankId == (this.mark & 0xFL)) {
                    return true;
                }
            }
            curBuf = (bankId = this.mark & 0xFL) == 0L ? this.bank0 : this.bank1;
        }
    }

    public E pop() {
        Object headObject;
        long arrayPos;
        Object[] curBuf;
        while (true) {
            long m;
            long bankId;
            if ((curBuf = (bankId = (m = this.mark) & 0xFL) == 0L ? this.bank0 : this.bank1) == null) {
                continue;
            }
            long curHeadV = m >> 34 & 0x3FFFFFFFL;
            long lengthMask = curBuf.length - 1;
            long curHeadPos = curHeadV & lengthMask;
            long curTailV = m >> 4 & 0x3FFFFFFFL;
            long curTailPos = curTailV & lengthMask;
            if (curHeadPos == curTailPos) {
                return null;
            }
            long nextHeadV = curHeadV + 1L & 0x3FFFFFFFL;
            arrayPos = arrayContentBase + arrayContentScale * curHeadPos;
            headObject = unsafe.getObjectVolatile(curBuf, arrayPos);
            if (headObject == null) {
                return null;
            }
            if (unsafe.compareAndSwapLong(this, markOffset, m, nextHeadV << 34 | curTailV << 4 | bankId)) break;
        }
        unsafe.putObjectVolatile(curBuf, arrayPos, null);
        return (E)headObject;
    }
}

