/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util;

import aglobe.container.AgentContainer;
import aglobe.container.agent.Agent;
import aglobe.container.service.Service;
import aglobe.platform.Platform;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Logger {
    private static Pattern agentThreadPattern = Pattern.compile("^([^:]+): ([^:]+): main agent thread$");
    private static Pattern serviceThreadPattern = Pattern.compile("^([^:]+): ([^:]+): main service thread$");

    private Logger() {
    }

    public static void logFinest(String message) {
        Logger.log(Level.FINEST, message);
    }

    public static void logFine(String message) {
        Logger.log(Level.FINE, message);
    }

    public static void logInfo(String message) {
        Logger.log(Level.INFO, message);
    }

    public static void logWarning(String message) {
        Logger.log(Level.WARNING, message);
    }

    public static void logSevere(String message) {
        Logger.log(Level.SEVERE, message);
    }

    private static void log(Level level, String message) {
        Matcher serviceMatcher;
        String currentThreadName;
        Matcher agentMatcher;
        StackTraceElement frame;
        String[] callPoint = new String[2];
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int ix = 0;
        while (ix < stack.length) {
            frame = stack[ix];
            String cname = frame.getClassName();
            if (cname.equals(Logger.class.getName())) break;
            ++ix;
        }
        if ((ix += 2) < stack.length) {
            frame = stack[ix];
            callPoint[0] = frame.getClassName();
            callPoint[1] = frame.getMethodName();
        }
        if ((agentMatcher = agentThreadPattern.matcher(currentThreadName = Thread.currentThread().getName())).find()) {
            Agent agent;
            AgentContainer ac;
            String containerName = agentMatcher.group(1);
            String agentName = agentMatcher.group(2);
            if (containerName != null && agentName != null && (ac = Platform.getContainer(containerName)) != null && (agent = ac.getAgentManager().getAgentInstance(agentName)) != null) {
                agent.log(level, callPoint, message);
                return;
            }
        }
        if ((serviceMatcher = serviceThreadPattern.matcher(currentThreadName)).find()) {
            Service service;
            AgentContainer ac;
            String containerName = agentMatcher.group(1);
            String serviceName = agentMatcher.group(2);
            if (containerName != null && serviceName != null && (ac = Platform.getContainer(containerName)) != null && (service = ac.getServiceManager().getServiceInstance(serviceName)) != null) {
                service.log(level, callPoint, message);
                return;
            }
        }
        java.util.logging.Logger.getAnonymousLogger().logp(level, callPoint[0], callPoint[1], message);
    }
}

