/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;

public class GUIUtils {
    public static final Horizontal hLEFT = new Horizontal();
    public static final Horizontal hCENTER = new Horizontal();
    public static final Horizontal hRIGHT = new Horizontal();
    public static final Horizontal hNONE = new Horizontal();
    public static final Vertical vTOP = new Vertical();
    public static final Vertical vCENTER = new Vertical();
    public static final Vertical vBOTTOM = new Vertical();
    public static final Vertical vNONE = new Vertical();
    public static final Position onTOP = new Position();
    public static final Position onLEFT = new Position();
    public static final Position onRIGHT = new Position();
    public static final Position onBOTTOM = new Position();

    private GUIUtils() {
    }

    public static void centerOnScreen(Component frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void positionOnScreen(Component frame, Horizontal hpos, Vertical vpos) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        int x = hpos == hLEFT ? 0 : (hpos == hCENTER ? (screenSize.width - frameSize.width) / 2 : (hpos == hRIGHT ? screenSize.width - frameSize.width : frame.getX()));
        int y = vpos == vTOP ? 0 : (vpos == vCENTER ? (screenSize.height - frameSize.height) / 2 : (vpos == vBOTTOM ? screenSize.height - frameSize.height : frame.getY()));
        frame.setLocation(x, y);
    }

    public static void dockTo(Component the_dock, Component dockable, Position pos) {
        if (pos == onTOP || pos == onLEFT) {
            Dimension dsize = dockable.getSize();
            Point loc = the_dock.getLocation();
            if (pos == onTOP) {
                dockable.setLocation(loc.x, loc.y - dsize.height);
            } else {
                dockable.setLocation(loc.x - dsize.width, loc.y);
            }
        } else {
            Dimension ssize = the_dock.getSize();
            Point sloc = the_dock.getLocation();
            if (pos == onBOTTOM) {
                dockable.setLocation(sloc.x, sloc.y + ssize.height);
            } else {
                dockable.setLocation(sloc.x + ssize.width, sloc.y);
            }
        }
    }

    public static final class Horizontal {
        private Horizontal() {
        }
    }

    public static final class Vertical {
        private Vertical() {
        }
    }

    public static final class Position {
        private Position() {
        }
    }
}

