/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class FileUtils {
    public static final String XML = "xml";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String JPEG = "jpeg";
    public static final String JAR = "jar";
    public static final String TXT = "txt";

    private FileUtils() {
    }

    public static String getExtension(File f) {
        return FileUtils.getExtension(f.getName());
    }

    public static String getExtension(String name) {
        String ext = "";
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            ext = name.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean hasExtension(File f, String ext) {
        return FileUtils.getExtension(f.getName()).equalsIgnoreCase(ext);
    }

    public static boolean hasExtension(String name, String ext) {
        return FileUtils.getExtension(name).equalsIgnoreCase(ext);
    }

    public static String removeExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            return name.substring(0, dot);
        }
        return name;
    }

    public static String ensureExtension(String name, String ext) {
        String e = ext.toLowerCase();
        if (name.toLowerCase().endsWith("." + e)) {
            return name;
        }
        return String.valueOf(name) + "." + e;
    }

    public static File ensureExtension(File f, String ext) {
        String e = ext.toLowerCase();
        String name = f.getPath().toLowerCase();
        if (name.endsWith("." + e)) {
            return new File(f.getPath());
        }
        return new File(String.valueOf(f.getPath()) + "." + e);
    }

    public static class FileFilter
    extends javax.swing.filechooser.FileFilter
    implements Serializable {
        private static final long serialVersionUID = -780314042272324565L;
        private final Set<String> extensions = new HashSet<String>();
        private final String desc;

        public FileFilter(String[] extensions, String description) {
            int i = 0;
            while (i < extensions.length) {
                this.extensions.add(extensions[i].toLowerCase());
                ++i;
            }
            this.desc = description;
        }

        public FileFilter(String extension, String description) {
            this.extensions.add(extension.toLowerCase());
            this.desc = description;
        }

        public FileFilter(String extension) {
            this.extensions.add(extension.toLowerCase());
            this.desc = "Files *." + extension;
        }

        public boolean accept(File f) {
            return f.isDirectory() || this.extensions.contains(FileUtils.getExtension(f));
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

