/*
 * Decompiled with CFR 0.152.
 */
package aglobe.util;

import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.platform.transport.CloneBuffer;
import aglobe.visio3D.VisioConstants;
import aglobe.visio3D.ontology.ListBar;
import aglobe.visio3D.ontology.ListBarElement;
import aglobe.visio3D.ontology.SimpleBar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class AglobeXMLtools {
    public static final String XMLEXT = ".xml";
    private static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");

    private AglobeXMLtools() {
    }

    public static JAXBContext getJAXBContext(Object object) throws JAXBException {
        if (object instanceof Class) {
            Class c = (Class)object;
            return JAXBContext.newInstance((String)c.getPackage().getName(), (ClassLoader)c.getClassLoader());
        }
        return JAXBContext.newInstance((String)object.getClass().getPackage().getName(), (ClassLoader)object.getClass().getClassLoader());
    }

    public static void marshallJAXBObject(Object object, OutputStream outputStream) throws JAXBException {
        Marshaller marshaller = AglobeXMLtools.getJAXBContext(object).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(object, outputStream);
    }

    public static Object unmarshallJAXBObject(Class defClass, InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = AglobeXMLtools.getJAXBContext(defClass).createUnmarshaller();
        return unmarshaller.unmarshal(inputStream);
    }

    public static String printObject(Object o) {
        if (o instanceof JAXBElement) {
            JAXBElement m = (JAXBElement)o;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                JAXBContext jc = AglobeXMLtools.getJAXBContext(m);
                Marshaller marshaller = jc.createMarshaller();
                marshaller.marshal((Object)m, (OutputStream)out);
                out.close();
                return out.toString();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            StringBuilder sb = new StringBuilder("byte[]{");
            boolean sc = false;
            int i = 0;
            while (i < b.length) {
                if (sc) {
                    sb.append(";");
                }
                sb.append(b[i]);
                sc = true;
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        return o.toString();
    }

    public static Object cloneMarshalable(Object e) {
        try {
            CloneBuffer buf = new CloneBuffer();
            JAXBContext jc = AglobeXMLtools.getJAXBContext(e);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.marshal(e, (OutputStream)buf.getOutputStream());
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            return unmarshaller.unmarshal((InputStream)buf.getInputStream());
        }
        catch (JAXBException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static Serializable cloneSerializable(Serializable s) {
        Serializable retVal = null;
        try {
            CloneBuffer buf = new CloneBuffer();
            buf.getOutputStream().writeObject(s);
            buf.getOutputStream().flush();
            retVal = (Serializable)buf.getInputStream().readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    public static AglobeParam makeAglobeParam(String name, String value) {
        AglobeParam p = new AglobeParam();
        p.setName(name);
        p.setValue(value);
        return p;
    }

    public static String getAglobeParamValue(AgentInfo ai, String paramName) {
        String retVal = null;
        for (AglobeParam item : ai.getAglobeParam()) {
            if (!item.getName().equals(paramName)) continue;
            retVal = item.getValue();
            break;
        }
        return retVal;
    }

    public static SimpleBar makeSimpleBar(String name, byte color, byte value) {
        SimpleBar sb = new SimpleBar();
        sb.setName(name);
        sb.setColor(color);
        sb.setValue(value);
        return sb;
    }

    public static ListBar makeListBar(String name) {
        ListBar lb = new ListBar();
        lb.setName(name);
        return lb;
    }

    public static ListBarElement makeListBarElement(String label, byte color) {
        ListBarElement lbe = new ListBarElement();
        lbe.setLabel(label);
        lbe.setColor(color);
        return lbe;
    }

    public static ListBarElement makeListBarElement(String label) {
        ListBarElement lbe = new ListBarElement();
        lbe.setLabel(label);
        lbe.setColor(VisioConstants.COM_COLORS[Math.abs(label.hashCode()) % VisioConstants.COM_COLORS.length]);
        return lbe;
    }
}

