/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.link;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.service.link.LinkConnector;
import aglobe.service.link.LinkConnectorListener;
import aglobe.service.link.LinkMessageCopyListener;
import aglobe.service.link.LinkNeighbourListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public class LinkService
extends Service {
    public static final String SERVICENAME = "container/link";
    private static final String SUBSCRIBE = "LINK_SUBSCRIBE";
    private static final String UNSUBSCRIBE = "LINK_UNSUBSCRIBE";
    protected AgentContainer.Shutdown containerShutdownListener;
    private String linkName;
    private boolean isRegistered = false;
    private LinkedHashSet<Address> currentVisibleContainers = new LinkedHashSet();
    private LinkedHashSet<LinkNeighbourListener> neighbourSubscribers = new LinkedHashSet();
    private LinkedHashSet<LinkMessageCopyListener> localMessageCopySubscribers = new LinkedHashSet();
    private LinkedHashSet<Address> remoteMessageCopySubscribers = new LinkedHashSet();
    private boolean hasSomeMessageCopySubscriber = false;
    LinkedList<Address> toRemove = new LinkedList();

    public LinkService(String linkName, AgentContainer.Shutdown containerShutdownListener) {
        this.containerShutdownListener = containerShutdownListener;
        this.linkName = linkName;
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    public void startService() {
        this.logFine("LinkService started");
    }

    public void stopService() {
        if (this.isRegistered) {
            try {
                LinkConnector.deregisterLinkService(this.linkName, this.getAddress().deriveContainerAddress());
            }
            catch (Exception ex) {
                this.logSevere("Problem during deregister: " + ex.toString());
            }
            this.isRegistered = false;
        }
        this.logFine("LinkService stopped");
    }

    public void afterContainerInit() {
        if (!this.isRegistered) {
            try {
                LinkConnector.registerLinkService(this.linkName, this.getAddress().deriveContainerAddress(), new LinkConnectorListener(){

                    public void register(Address containerAddress) {
                        LinkService.this.register(containerAddress);
                    }

                    public void deregister(Address containerAddress) {
                        LinkService.this.deregister(containerAddress);
                    }

                    public void addEvent(Runnable run) {
                        LinkService.this.addEvent(run);
                    }
                });
            }
            catch (Exception ex) {
                this.logSevere("Cannot register LinkService: " + ex.toString());
                this.containerShutdownListener.shutdownContainer();
                return;
            }
            this.isRegistered = true;
        }
    }

    private synchronized void register(final Address containerAddress) {
        if (this.currentVisibleContainers.contains(containerAddress)) {
            return;
        }
        this.currentVisibleContainers.add(containerAddress);
        for (final LinkNeighbourListener elem : this.neighbourSubscribers) {
            elem.addEvent(new Runnable(){

                public void run() {
                    elem.handleRegister(containerAddress);
                }
            });
        }
        if (this.localMessageCopySubscribers.size() > 0) {
            Message m = Message.newInstance(SUBSCRIBE, this.getAddress(), containerAddress.deriveServiceAddress(SERVICENAME));
            m.setProtocol("OUTGOING_MESSAGE_COPY");
            try {
                this.sendMessageAsReference(m);
            }
            catch (InvisibleContainerException ex) {
                this.deregister(containerAddress);
            }
            m.release();
        }
    }

    private synchronized void deregister(final Address containerAddress) {
        if (!this.currentVisibleContainers.contains(containerAddress)) {
            return;
        }
        this.currentVisibleContainers.remove(containerAddress);
        for (final LinkNeighbourListener elem : this.neighbourSubscribers) {
            elem.addEvent(new Runnable(){

                public void run() {
                    elem.handleDeregister(containerAddress);
                }
            });
        }
        this.remoteMessageCopySubscribers.remove(containerAddress);
        if (this.hasSomeMessageCopySubscriber && this.remoteMessageCopySubscribers.size() == 0 && this.localMessageCopySubscribers.size() == 0) {
            this.hasSomeMessageCopySubscriber = false;
        }
    }

    protected synchronized void handleIncomingMessage(Message m) {
        if ("OUTGOING_MESSAGE_COPY".equals(m.getProtocol())) {
            if ("INFORM".equals(m.getPerformative())) {
                final byte[] serializedMessage = (byte[])m.getContent();
                final String undeliverable = m.getReason();
                for (final LinkMessageCopyListener elem : this.localMessageCopySubscribers) {
                    elem.addEvent(new Runnable(){

                        public void run() {
                            elem.handleMessageCopy(serializedMessage, undeliverable);
                        }
                    });
                }
                m.release();
                return;
            }
            if (SUBSCRIBE.equals(m.getPerformative())) {
                this.remoteMessageCopySubscribers.add(m.getSender().deriveContainerAddress());
                if (!this.hasSomeMessageCopySubscriber) {
                    this.hasSomeMessageCopySubscriber = true;
                }
                m.release();
                return;
            }
            if (UNSUBSCRIBE.equals(m.getPerformative())) {
                this.remoteMessageCopySubscribers.remove(m.getSender().deriveContainerAddress());
                if (this.hasSomeMessageCopySubscriber && this.localMessageCopySubscribers.size() == 0 && this.remoteMessageCopySubscribers.size() == 0) {
                    this.hasSomeMessageCopySubscriber = false;
                }
                m.release();
                return;
            }
        }
        this.logWarning("Unexpected incoming message: " + m);
        m.release();
    }

    private synchronized void subscribeNeighbour(final LinkNeighbourListener listener) {
        if (this.neighbourSubscribers.contains(listener)) {
            return;
        }
        this.neighbourSubscribers.add(listener);
        for (final Address elem : this.currentVisibleContainers) {
            listener.addEvent(new Runnable(){

                public void run() {
                    listener.handleRegister(elem);
                }
            });
        }
    }

    private synchronized void unsubscribeNeighbour(LinkNeighbourListener listener) {
        this.neighbourSubscribers.remove(listener);
    }

    private synchronized void subsribeMessageCopy(LinkMessageCopyListener listener) {
        if (this.localMessageCopySubscribers.contains(listener)) {
            return;
        }
        boolean n = this.localMessageCopySubscribers.size() == 0;
        this.localMessageCopySubscribers.add(listener);
        if (n) {
            this.hasSomeMessageCopySubscriber = true;
            Message m = Message.newInstance(SUBSCRIBE, this.getAddress(), this.getAddress());
            m.setProtocol("OUTGOING_MESSAGE_COPY");
            for (Address elem : this.currentVisibleContainers) {
                m.setReceiver(elem.deriveServiceAddress(SERVICENAME));
                try {
                    this.sendMessageAsReference(m);
                }
                catch (InvisibleContainerException ex) {
                    this.toRemove.add(elem);
                }
            }
            m.release();
            if (this.toRemove.size() != 0) {
                for (Address elem : this.toRemove) {
                    this.deregister(elem);
                }
                this.toRemove.clear();
            }
        }
    }

    private synchronized void unsubsribeMessageCopy(LinkMessageCopyListener listener) {
        if (!this.localMessageCopySubscribers.contains(listener)) {
            return;
        }
        this.localMessageCopySubscribers.remove(listener);
        if (this.localMessageCopySubscribers.size() == 0) {
            Message m = Message.newInstance(UNSUBSCRIBE, this.getAddress(), this.getAddress());
            m.setProtocol("OUTGOING_MESSAGE_COPY");
            for (Address elem : this.currentVisibleContainers) {
                m.setReceiver(elem.deriveServiceAddress(SERVICENAME));
                try {
                    this.sendMessageAsReference(m);
                }
                catch (InvisibleContainerException ex) {
                    this.toRemove.add(elem);
                }
            }
            m.release();
            if (this.toRemove.size() != 0) {
                for (Address elem : this.toRemove) {
                    this.deregister(elem);
                }
                this.toRemove.clear();
            }
        }
    }

    private synchronized void distributeMessageCopy(final byte[] serializedMessage, final String undeliverable) {
        int i = 0;
        for (final LinkMessageCopyListener elem : this.localMessageCopySubscribers) {
            elem.addEvent(new Runnable(){

                public void run() {
                    elem.handleMessageCopy(serializedMessage, undeliverable);
                }
            });
            ++i;
        }
        Message m = Message.newInstance("INFORM", this.getAddress(), this.getAddress());
        m.setProtocol("OUTGOING_MESSAGE_COPY");
        m.setContent(serializedMessage);
        m.setReason(undeliverable);
        for (Address elem : this.remoteMessageCopySubscribers) {
            m.setReceiver(elem.deriveServiceAddress(SERVICENAME));
            try {
                this.sendMessageAsReference(m);
                ++i;
            }
            catch (InvisibleContainerException ex) {
                this.toRemove.add(elem);
            }
        }
        m.release();
        if (this.toRemove.size() != 0) {
            for (Address elem : this.toRemove) {
                this.deregister(elem);
            }
            this.toRemove.clear();
        }
        if (i == 0) {
            this.hasSomeMessageCopySubscriber = false;
        }
    }

    public static class Shell
    extends ServiceShell {
        private static final long serialVersionUID = -7803144135776937L;
        private transient LinkService theservice = null;
        private LinkedHashSet<LinkNeighbourListener> subscribersForNeighbours = new LinkedHashSet();
        private LinkedHashSet<LinkMessageCopyListener> subscribersForMessageCopy = new LinkedHashSet();

        public Shell() {
        }

        private Shell(ElementaryEntity shellOwner, LinkService _theservice) {
            super(shellOwner);
            this.theservice = _theservice;
        }

        public boolean isValid() {
            return this.theservice != null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new RuntimeException("LinkService doesn't support migration of shell owner !!!");
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new RuntimeException("LinkService doesn't support migration of shell owner !!!");
        }

        public void setContainer(AgentContainer container) throws Exception {
            throw new RuntimeException("LinkService doesn't support migration of shell owner !!!");
        }

        public void postInit() {
        }

        public void dispose() {
            this.unsubscribeAll();
            super.dispose();
        }

        public void subscribeNeighbour(LinkNeighbourListener listener) {
            if (this.subscribersForNeighbours.contains(listener)) {
                return;
            }
            this.subscribersForNeighbours.add(listener);
            this.theservice.subscribeNeighbour(listener);
        }

        public void subsribeMessageCopy(LinkMessageCopyListener listener) {
            if (this.subscribersForMessageCopy.contains(listener)) {
                return;
            }
            this.subscribersForMessageCopy.add(listener);
            this.theservice.subsribeMessageCopy(listener);
        }

        public void unsubscribeAll() {
            for (LinkNeighbourListener linkNeighbourListener : this.subscribersForNeighbours) {
                this.theservice.unsubscribeNeighbour(linkNeighbourListener);
            }
            for (LinkMessageCopyListener linkMessageCopyListener : this.subscribersForMessageCopy) {
                this.theservice.unsubsribeMessageCopy(linkMessageCopyListener);
            }
            this.subscribersForNeighbours.clear();
            this.subscribersForMessageCopy.clear();
        }

        public void distributeMessageCopy(byte[] serializedMessage, String undeliverable) {
            this.theservice.distributeMessageCopy(serializedMessage, undeliverable);
        }

        public boolean hasSomeMessageCopySubscriber() {
            return this.theservice.hasSomeMessageCopySubscriber;
        }
    }
}

