/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.link;

import aglobe.container.transport.Address;
import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.link.LinkConnectorListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

class LinkConnector {
    private static Exchanger exchanger = null;
    private static Object sync = new Object();
    private static LinkedHashMap<String, LinkedHashSet<Address>> knownLinkNames = new LinkedHashMap();
    private static LinkedHashMap<Address, LinkConnectorListener> localContainers = new LinkedHashMap();
    private static LinkedHashMap<InetSocketAddress, LinkedHashMap<String, LinkedHashSet<Address>>> remoteKB = new LinkedHashMap();

    LinkConnector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerLinkService(String linkName, Address containerAddress, final LinkConnectorListener linkListener) throws Exception {
        Object object = sync;
        synchronized (object) {
            if (linkName == null) {
                throw new Exception("Unspecified linkName");
            }
            LinkedHashSet<Address> known = knownLinkNames.get(linkName);
            if (known == null) {
                known = new LinkedHashSet();
                knownLinkNames.put(linkName, known);
            }
            if (known.contains(containerAddress) || localContainers.containsKey(containerAddress)) {
                throw new Exception("Already known container");
            }
            known.add(containerAddress);
            localContainers.put(containerAddress, linkListener);
            if (exchanger == null) {
                exchanger = new Exchanger();
            }
            LinkConnector.distributeRegisterToLocal(linkName, containerAddress);
            if (exchanger != null) {
                LinkConnector.exchanger.sendRegister(linkName, containerAddress);
            }
            for (final Address address : knownLinkNames.get(linkName)) {
                if (address.equals(containerAddress)) continue;
                linkListener.addEvent(new Runnable(){

                    public void run() {
                        linkListener.register(address);
                    }
                });
            }
            for (LinkedHashMap linkedHashMap : remoteKB.values()) {
                if (!linkedHashMap.containsKey(linkName)) continue;
                for (final Address elem1 : (LinkedHashSet)linkedHashMap.get(linkName)) {
                    linkListener.addEvent(new Runnable(){

                        public void run() {
                            linkListener.register(elem1);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregisterLinkService(String linkName, Address containerAddress) throws Exception {
        Object object = sync;
        synchronized (object) {
            if (linkName == null) {
                throw new Exception("Unspecified linkName");
            }
            LinkedHashSet<Address> known = knownLinkNames.get(linkName);
            if (known != null && known.contains(containerAddress)) {
                known.remove(containerAddress);
                if (known.size() == 0) {
                    knownLinkNames.remove(linkName);
                }
            }
            if (localContainers.containsKey(containerAddress)) {
                localContainers.remove(containerAddress);
                LinkConnector.distributeDeregisterToLocal(linkName, containerAddress);
                if (exchanger != null) {
                    LinkConnector.exchanger.sendDeregister(linkName, containerAddress);
                }
            }
            if (knownLinkNames.size() == 0 && exchanger != null) {
                LinkConnector.exchanger.kill();
                exchanger = null;
                remoteKB.clear();
            }
        }
    }

    private static void distributeRegisterToLocal(String linkName, final Address registered) {
        if (!knownLinkNames.containsKey(linkName)) {
            return;
        }
        for (Address elem : knownLinkNames.get(linkName)) {
            LinkConnectorListener ll;
            if (elem.equals(registered) || (ll = localContainers.get(elem)) == null) continue;
            ll.addEvent(new Runnable(){

                public void run() {
                    ll.register(registered);
                }
            });
        }
    }

    private static void distributeDeregisterToLocal(String linkName, final Address deregistered) {
        if (!knownLinkNames.containsKey(linkName)) {
            return;
        }
        for (Address elem : knownLinkNames.get(linkName)) {
            LinkConnectorListener ll;
            if (elem.equals(deregistered) || (ll = localContainers.get(elem)) == null) continue;
            ll.addEvent(new Runnable(){

                public void run() {
                    ll.deregister(deregistered);
                }
            });
        }
    }

    private static void remoteRegistered(InetSocketAddress remote, String linkName, Address containerAddress) {
        LinkedHashSet<Address> rsn;
        LinkedHashMap<String, LinkedHashSet<Address>> rn = remoteKB.get(remote);
        if (rn == null) {
            rn = new LinkedHashMap();
            remoteKB.put(remote, rn);
        }
        if ((rsn = rn.get(linkName)) == null) {
            rsn = new LinkedHashSet();
            rn.put(linkName, rsn);
        }
        if (!rsn.contains(containerAddress)) {
            rsn.add(containerAddress);
            LinkConnector.distributeRegisterToLocal(linkName, containerAddress);
        }
    }

    private static void remoteDeregistered(InetSocketAddress remote, String linkName, Address containerAddress) {
        LinkedHashMap<String, LinkedHashSet<Address>> rn = remoteKB.get(remote);
        if (rn == null) {
            return;
        }
        LinkedHashSet<Address> rsn = rn.get(linkName);
        if (rsn == null) {
            return;
        }
        if (rsn.contains(containerAddress)) {
            rsn.remove(containerAddress);
            LinkConnector.distributeDeregisterToLocal(linkName, containerAddress);
            if (rsn.size() == 0) {
                rn.remove(linkName);
            }
            if (rn.size() == 0) {
                remoteKB.remove(remote);
            }
        }
    }

    private static class Exchanger
    implements Runnable {
        public static final String REQUEST = "LinkConnectorAreYouThere?A-globe_ver4_1";
        public static final int AUTO_CONFIGURATOR_BASE_PORT = 4444;
        public static final int AUTO_CONFIGURATOR_PORT_RANGE = 5;
        private DatagramSocket socket = null;
        private final Logger logger = Logger.getLogger("LinkConnectorServer");
        private volatile boolean killing = false;
        private volatile boolean stopped = false;
        private Thread asThread = null;
        private InetSocketAddress localAddress = null;

        private Exchanger() throws Exception {
            int listeningPort = 4444;
            while (this.asThread == null && listeningPort < 4449) {
                try {
                    this.socket = new DatagramSocket(listeningPort);
                    this.socket.setBroadcast(true);
                    this.socket.setSoTimeout(1000);
                    this.localAddress = new InetSocketAddress(InetAddress.getLocalHost(), listeningPort);
                    this.asThread = AglobeThreadPool.getThread(Platform.getPlatformThreadGroup(), this, "LinkConnectorThread");
                    this.asThread.setPriority(Math.min(6, 10));
                    this.asThread.start();
                }
                catch (SocketException ex) {
                    ++listeningPort;
                }
            }
            if (this.asThread == null) {
                throw new Exception("LinkConnector server: Cannot open any listening autoconfigurator port in range: 4444 - 4448");
            }
            this.findOthers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                byte[] buf = new byte[1024];
                DatagramPacket dp = new DatagramPacket(buf, buf.length);
                try {
                    this.socket.receive(dp);
                    String s = new String(dp.getData(), 0, dp.getLength());
                    InetSocketAddress sender = (InetSocketAddress)dp.getSocketAddress();
                    Object object = sync;
                    synchronized (object) {
                        if (sender.equals(this.localAddress)) {
                            continue;
                        }
                        if (s.equals(REQUEST)) {
                            if (!remoteKB.containsKey(sender)) {
                                remoteKB.put(sender, new LinkedHashMap());
                                this.sendAllMyKB(sender);
                            }
                        } else {
                            StringTokenizer st = new StringTokenizer(s, ";");
                            String action = st.nextToken();
                            int ac = 0;
                            if (action.equals("R")) {
                                ac = 1;
                            } else if (action.equals("D")) {
                                ac = 2;
                            }
                            if (ac > 0) {
                                String linkName = null;
                                Address containerAddress = null;
                                if (st.hasMoreTokens()) {
                                    linkName = st.nextToken();
                                }
                                if (st.hasMoreTokens()) {
                                    try {
                                        containerAddress = Address.getAddress(st.nextToken());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (linkName != null && containerAddress != null && containerAddress.isContainerAddress()) {
                                    boolean known = remoteKB.containsKey(sender);
                                    if (ac == 1) {
                                        LinkConnector.remoteRegistered(sender, linkName, containerAddress);
                                    } else {
                                        LinkConnector.remoteDeregistered(sender, linkName, containerAddress);
                                    }
                                    if (!known) {
                                        this.sendAllMyKB(sender);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (SocketTimeoutException s) {
                }
                catch (IOException ex) {
                    this.logger.severe("Receiving exeption " + ex);
                }
                if (this.killing) break;
            }
            this.socket.close();
            Exchanger exchanger = this;
            synchronized (exchanger) {
                this.stopped = true;
                this.notify();
            }
        }

        private void findOthers() {
            DatagramPacket senddp;
            int portOffset;
            byte[] outBuf;
            block17: {
                outBuf = REQUEST.getBytes();
                portOffset = 0;
                while (portOffset < 5) {
                    try {
                        senddp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getLocalHost(), 4444 + portOffset);
                        this.socket.send(senddp);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++portOffset;
                }
                try {
                    byte[] rawLocalAddress = InetAddress.getLocalHost().getAddress();
                    if (rawLocalAddress.length != 4) break block17;
                    int firstnumber = rawLocalAddress[0] & 0xFF;
                    int subnet = 0;
                    if (firstnumber <= 127) {
                        subnet = 3;
                    } else if (firstnumber <= 191) {
                        subnet = 2;
                    } else if (firstnumber <= 223) {
                        subnet = 1;
                    }
                    int i = 4 - subnet;
                    while (i < 4) {
                        rawLocalAddress[i] = -1;
                        ++i;
                    }
                    portOffset = 0;
                    while (portOffset < 5) {
                        senddp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getByAddress(rawLocalAddress), 4444 + portOffset);
                        try {
                            this.socket.send(senddp);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++portOffset;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            portOffset = 0;
            while (portOffset < 5) {
                try {
                    senddp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getByName("255.255.255.255"), 4444 + portOffset);
                    this.socket.send(senddp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++portOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void kill() {
            this.killing = true;
            Exchanger exchanger = this;
            synchronized (exchanger) {
                while (true) {
                    if (this.stopped) {
                        return;
                    }
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void sendAllMyKB(InetSocketAddress to) {
            for (Map.Entry elem : knownLinkNames.entrySet()) {
                for (Address elem1 : (LinkedHashSet)elem.getValue()) {
                    try {
                        byte[] replyBuf = ("R;" + (String)elem.getKey() + ";" + elem1.toString()).getBytes();
                        DatagramPacket reply = new DatagramPacket(replyBuf, replyBuf.length, to);
                        this.socket.send(reply);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void sendRegister(String linkName, Address containerAddress) {
            this.sendStringToAll("R;" + linkName + ";" + containerAddress.toString());
        }

        private void sendDeregister(String linkName, Address containerAddress) {
            this.sendStringToAll("D;" + linkName + ";" + containerAddress.toString());
        }

        private void sendStringToAll(String str) {
            byte[] sendBuf = str.getBytes();
            for (InetSocketAddress elem : remoteKB.keySet()) {
                try {
                    DatagramPacket m = new DatagramPacket(sendBuf, sendBuf.length, elem);
                    this.socket.send(m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

