/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.server.bridge.server;

import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.CommunicationInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class GISServerBridgeServer
extends Service {
    public static final String SERVICENAME = "gis/bridgeserver";
    public static final String LOGIN = "LOGIN";
    public static final String LOGIN_SUCCESSFULL = "LOGIN_SUCCESSFULL";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String CLEAR_CACHE = "CLEAR_CACHE";
    public static final String BROADCAST_TOPIC = "BROADCAST_TOPIC";
    public static final String BROADCAST_TOPIC_TO_CLIENTS = "BROADCAST_TOPIC_TO_CLIENTS";
    public static final String SEND_TOPIC_TO_LOCAL = "SEND_TOPIC_TO_LOCAL";
    public static final String SEND_TOPIC = "SEND_TOPIC";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String UNSUBSCRIBE = "UNSUBSCRIBE";
    public static final String HANDLE_TOPIC = "HANDLE_TOPIC";
    public static final String NULL_REPLY_WITH = "NULL_REPLY_WITH";
    private LinkedHashMap<Address, Client> knownClients = new LinkedHashMap();

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        throw new RuntimeException("Operation not supported");
    }

    public void startService() {
        this.logFine("GISServerBridgeServer started");
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
    }

    public void stopService() {
        LinkedList<Client> cpy = new LinkedList<Client>(this.knownClients.values());
        Message m = Message.newInstance(SHUTDOWN);
        m.setSender(this.getAddress());
        for (Client elem : cpy) {
            m.setReceiver(elem.clientAddress);
            try {
                this.sendMessageAsReference(m);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            elem.disconnect();
        }
        m.release();
    }

    protected void handleIncomingMessage(Message m) {
        String performative = m.getPerformative();
        if (LOGIN.equals(performative)) {
            if (this.knownClients.containsKey(m.getSender())) {
                this.logWarning("GISServerBridgeClient is already known: " + m.getSender());
                m.release();
                return;
            }
            this.knownClients.put(m.getSender(), new Client(m.getSender()));
            m.release();
            return;
        }
        Client c = this.knownClients.get(m.getSender());
        if (c != null && c.parse(m)) {
            m.release();
            return;
        }
        this.logSevere("Unexpected incoming message: " + m.toString());
        m.release();
    }

    private class Client
    extends GISTopicServerListenerWithoutLogin {
        private final Address clientAddress;
        private final GISServerService.Shell localShell;
        private boolean active = true;

        private Client(Address clientAddress) {
            this.clientAddress = clientAddress;
            this.localShell = (GISServerService.Shell)GISServerBridgeServer.this.getContainer().getServiceManager().getService(GISServerBridgeServer.this, "gis/master");
            Message m = Message.newInstance(GISServerBridgeServer.LOGIN_SUCCESSFULL, GISServerBridgeServer.this.getAddress(), clientAddress);
            try {
                GISServerBridgeServer.this.sendMessageAsReference(m);
            }
            catch (InvisibleContainerException ex) {
                GISServerBridgeServer.this.logWarning("Unrechable client: " + ex.toString());
                this.disconnect();
            }
            m.release();
        }

        private void disconnect() {
            if (!this.active) {
                return;
            }
            this.localShell.dispose();
            GISServerBridgeServer.this.knownClients.remove(this.clientAddress);
            this.active = false;
        }

        private boolean parse(Message m) {
            String performative = m.getPerformative();
            if (GISServerBridgeServer.CLEAR_CACHE.equals(performative)) {
                this.localShell.clearHistoryCache();
                return true;
            }
            if (GISServerBridgeServer.BROADCAST_TOPIC.equals(performative)) {
                this.localShell.broadcastTopic(m.getInReplyTo(), m.getContent(), m.getReason());
                return true;
            }
            if (GISServerBridgeServer.BROADCAST_TOPIC_TO_CLIENTS.equals(performative)) {
                this.localShell.broadcastTopicToClients(m.getInReplyTo(), m.getContent(), m.getReason());
                return true;
            }
            if (GISServerBridgeServer.SEND_TOPIC_TO_LOCAL.equals(performative)) {
                this.localShell.sendTopicToLocal(m.getInReplyTo(), m.getContent(), m.getReason());
                return true;
            }
            if (GISServerBridgeServer.SEND_TOPIC.equals(performative)) {
                String tmp = m.getReplyWith();
                if (GISServerBridgeServer.NULL_REPLY_WITH.equals(tmp)) {
                    tmp = null;
                }
                this.localShell.sendTopic(tmp, m.getInReplyTo(), m.getContent(), m.getReason());
                return true;
            }
            if (GISServerBridgeServer.SUBSCRIBE.equals(performative)) {
                this.localShell.subscribeTopic(m.getReason(), this);
                return true;
            }
            if (GISServerBridgeServer.UNSUBSCRIBE.equals(performative)) {
                this.localShell.unsubscribeTopic(m.getReason(), this);
                return true;
            }
            return false;
        }

        public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
            CommunicationInfo ci;
            if (!this.active) {
                return;
            }
            if ("COMMUNICATION_INFO".equals(topic) && content instanceof CommunicationInfo && (ci = (CommunicationInfo)content).getTo().equals(this.clientAddress)) {
                return;
            }
            Message m = Message.newInstance(GISServerBridgeServer.HANDLE_TOPIC, GISServerBridgeServer.this.getAddress(), this.clientAddress);
            m.setInReplyTo(topic);
            if (content != null) {
                m.setContent(content);
            }
            if (reason != null) {
                m.setReason(reason);
            }
            if (remoteClientAddress != null) {
                m.setReplyWith(remoteClientAddress.toString());
            } else {
                m.setReplyWith(GISServerBridgeServer.NULL_REPLY_WITH);
            }
            try {
                GISServerBridgeServer.this.sendMessageAsReference(m);
            }
            catch (InvisibleContainerException ex) {
                GISServerBridgeServer.this.logWarning("Unrechable client: " + ex.toString());
                this.disconnect();
            }
            m.release();
        }

        public void addEvent(Runnable e) {
            GISServerBridgeServer.this.addEvent(e);
        }
    }
}

