/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.server.bridge.client;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class GISServerBridgeClient
extends Service {
    public static final String SERVICENAME = "gis/master";
    private static final long TIMEOUT = 5000L;
    protected Address GISServerBridgeServerService = null;
    protected AgentContainer.Shutdown containerShutdownListener;
    private volatile boolean initialized = false;
    private Object waitingInitialization = new Object();
    private LinkedHashMap<String, LinkedList<GISTopicServerListener>> localTopicListeners = new LinkedHashMap();
    private TimerTask initTask = null;

    public GISServerBridgeClient(Address serverAddress, AgentContainer.Shutdown containerShutdownListener) {
        this.containerShutdownListener = containerShutdownListener;
        this.GISServerBridgeServerService = serverAddress.deriveServiceAddress("gis/bridgeserver");
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startService() {
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
        this.loginToServer();
        Object object = this.waitingInitialization;
        synchronized (object) {
            this.initialized = true;
            this.waitingInitialization.notifyAll();
        }
    }

    public void stopService() {
    }

    protected synchronized void handleIncomingMessage(Message m) {
        String performative;
        if (this.initTask != null) {
            this.initTask.cancel();
        }
        if ("LOGIN_SUCCESSFULL".equals(performative = m.getPerformative())) {
            m.release();
            return;
        }
        if ("SHUTDOWN".equals(performative)) {
            this.logInfo("Shutdown by GISServerBridgeServer");
            this.containerShutdownListener.shutdownContainer();
            m.release();
            return;
        }
        if ("HANDLE_TOPIC".equals(performative)) {
            Address remoteClientAddress = null;
            String tmp = m.getReplyWith();
            if (tmp != null && !tmp.equals("NULL_REPLY_WITH")) {
                remoteClientAddress = Address.getAddress(tmp);
            }
            this.parseHandleTopic(m.getInReplyTo(), m.getContent(), m.getReason(), remoteClientAddress == null ? null : remoteClientAddress.getContainerName(), remoteClientAddress);
            m.release();
            return;
        }
        this.logSevere("Uexpected incoming message: " + m.toString());
        m.release();
    }

    private void parseHandleTopic(final String topic, final Object content, final String reason, final String remoteContainerName, final Address remoteClientAddress) {
        List list = this.localTopicListeners.get(topic);
        if (list != null) {
            for (final GISTopicServerListener elem : list) {
                elem.addEvent(new Runnable(){

                    public void run() {
                        elem.handleTopic(topic, content, reason, remoteContainerName, remoteClientAddress);
                    }
                });
            }
        }
    }

    private synchronized void loginToServer() {
        Message m = Message.newInstance("LOGIN", this.getAddress(), this.GISServerBridgeServerService);
        try {
            this.sendMessageAsReference(m);
            this.initTask = this.scheduleEvent(new Runnable(){

                public void run() {
                    GISServerBridgeClient.this.logSevere("Cannot communicate with GISServerBridgeServer");
                    GISServerBridgeClient.this.containerShutdownListener.shutdownContainer();
                }
            }, 5000L);
        }
        catch (InvisibleContainerException ex) {
            this.logSevere("Cannot communicate with GISServerBridgeServer");
            this.containerShutdownListener.shutdownContainer();
        }
        m.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForInitialization() {
        if (this.initialized) {
            return;
        }
        Object object = this.waitingInitialization;
        synchronized (object) {
            while (true) {
                if (this.initialized) {
                    return;
                }
                try {
                    this.waitingInitialization.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized void clearHistoryCache() {
        Message m = Message.newInstance("CLEAR_CACHE", this.getAddress(), this.GISServerBridgeServerService);
        try {
            this.sendMessageAsReference(m);
        }
        catch (InvisibleContainerException ex) {
            this.logSevere("Cannot communicate with GISServerBridgeServer");
            this.containerShutdownListener.shutdownContainer();
        }
        m.release();
    }

    private synchronized void sendToServer(String command, Object content, String reason, String inReplyTo, String replyWith) {
        Message m = Message.newInstance(command, this.getAddress(), this.GISServerBridgeServerService);
        if (content != null) {
            m.setContent(content);
        }
        if (reason != null) {
            m.setReason(reason);
        }
        if (inReplyTo != null) {
            m.setInReplyTo(inReplyTo);
        }
        if (replyWith != null) {
            m.setReplyWith(replyWith);
        } else {
            m.setReplyWith("NULL_REPLY_WITH");
        }
        try {
            this.sendMessageAsReference(m);
        }
        catch (InvisibleContainerException ex) {
            this.logSevere("Cannot communicate with GISServerBridgeServer");
            this.containerShutdownListener.shutdownContainer();
        }
        m.release();
    }

    private synchronized void subscribeTopic(String topic, GISTopicServerListener listener) {
        if (!this.localTopicListeners.containsKey(topic)) {
            this.localTopicListeners.put(topic, new LinkedList());
        }
        List list = this.localTopicListeners.get(topic);
        list.add(listener);
        if (list.size() == 1) {
            this.sendToServer("SUBSCRIBE", null, topic, null, null);
        }
    }

    private synchronized void unsubscribeTopic(String topic, GISTopicServerListener listener) {
        List list = this.localTopicListeners.get(topic);
        if (list != null) {
            list.remove(listener);
            if (list.size() == 0) {
                this.localTopicListeners.remove(topic);
                this.sendToServer("UNSUBSCRIBE", null, topic, null, null);
            }
        }
    }

    public static class Shell
    extends GISServerService.Shell {
        private static final long serialVersionUID = -78031168776943L;
        private transient LinkedHashMap<GISTopicServerListener, LinkedHashSet<String>> topicListeners = new LinkedHashMap();
        transient GISServerBridgeClient theservice = null;

        private Shell(ElementaryEntity shellOwner, GISServerBridgeClient _theservice) {
            super(shellOwner, null);
            this.theservice = _theservice;
        }

        public boolean isValid() {
            return this.theservice != null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new RuntimeException("Migration not supported");
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new RuntimeException("Migration not supported");
        }

        public void setContainer(AgentContainer container) throws Exception {
            throw new RuntimeException("Migration not supported");
        }

        public void subscribeTopic(String topic, GISTopicServerListener listener) {
            this.theservice.waitForInitialization();
            LinkedHashSet<String> subscribedTopics = this.topicListeners.get(listener);
            if (subscribedTopics == null) {
                subscribedTopics = new LinkedHashSet();
                this.topicListeners.put(listener, subscribedTopics);
            }
            if (subscribedTopics.contains(topic)) {
                return;
            }
            subscribedTopics.add(topic);
            this.theservice.subscribeTopic(topic, listener);
        }

        public void unsubscribeTopic(String topic) {
            this.theservice.waitForInitialization();
            for (Map.Entry<GISTopicServerListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                if (!item.getValue().contains(topic)) continue;
                this.theservice.unsubscribeTopic(topic, item.getKey());
                item.getValue().remove(topic);
            }
        }

        public void unsubscribeTopic(String topic, GISTopicServerListener listener) {
            this.theservice.waitForInitialization();
            LinkedHashSet<String> subscriptions = this.topicListeners.get(listener);
            if (subscriptions != null && subscriptions.contains(topic)) {
                this.theservice.unsubscribeTopic(topic, listener);
                subscriptions.remove(topic);
                if (subscriptions.size() == 0) {
                    this.topicListeners.remove(listener);
                }
            }
        }

        public void unsubscribeAllTopics() {
            this.theservice.waitForInitialization();
            for (Map.Entry<GISTopicServerListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                for (String item1 : item.getValue()) {
                    this.theservice.unsubscribeTopic(item1, item.getKey());
                }
            }
            this.topicListeners.clear();
        }

        public void broadcastTopic(String topic, Object content, String reason) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("BROADCAST_TOPIC", content, reason, topic, null);
        }

        public void broadcastTopic(String topic, Object content) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("BROADCAST_TOPIC", content, null, topic, null);
        }

        public void broadcastTopicToClients(String topic, Object content, String reason) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("BROADCAST_TOPIC_TO_CLIENTS", content, reason, topic, null);
        }

        public void broadcastTopicToClients(String topic, Object content) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("BROADCAST_TOPIC_TO_CLIENTS", content, null, topic, null);
        }

        public void sendTopicToLocal(String topic, Object content, String reason) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("SEND_TOPIC_TO_LOCAL", content, reason, topic, null);
        }

        public void sendTopicToLocal(String topic, Object content) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("SEND_TOPIC_TO_LOCAL", content, null, topic, null);
        }

        public boolean sendTopic(String destinationContainer, String topic, Object content, String reason) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("SEND_TOPIC", content, reason, topic, destinationContainer);
            return true;
        }

        public boolean sendTopic(String destinationContainer, String topic, Object content) {
            this.theservice.waitForInitialization();
            this.theservice.sendToServer("SEND_TOPIC", content, null, topic, destinationContainer);
            return true;
        }

        public String getSystemName() {
            throw new RuntimeException("Not supported");
        }

        public GISServerService getServiceInstance() {
            throw new RuntimeException("Not supported");
        }

        public void dispose() {
            this.unsubscribeAllTopics();
            super.dispose();
        }

        public boolean hasSomeCommunicationInfoSubscriber() {
            return false;
        }

        public boolean hasSomeOutgoingMessageCopySubscriber() {
            return false;
        }

        public boolean hasSomeIncomingMessageCopySubscriber() {
            return false;
        }

        public boolean hasSomeSubscriber(String topic) {
            return true;
        }

        public void clearHistoryCache() {
            this.theservice.waitForInitialization();
            this.theservice.clearHistoryCache();
        }
    }
}

