/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.server;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.platform.Platform;
import aglobe.service.gis.server.AutoConfiguratorServer;
import aglobe.service.gis.server.GISTopicServerListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class GISServerService
extends Service
implements GISTopicServerListener {
    public static final String SERVICENAME = "gis/master";
    public static final String TOPIC_GIS_INTERNAL = "GIS_INTERNAL";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String UNSUBSCRIBE = "UNSUBSCRIBE";
    public static final String KEEP_ALIVE = "KEEP_ALIVE";
    private AutoConfiguratorServer as = null;
    private LinkedHashMap<String, LinkedList<GISTopicServerListener>> localTopicListeners = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashMap<String, Address>> remoteTopicListeners = new LinkedHashMap();
    private LinkedHashMap<String, Address> registredContainers = new LinkedHashMap();
    private final String systemName;
    private boolean topicCommunicationInfoSubscribed = false;
    private boolean topicOutgoingMessageCopySubscribed = false;
    private boolean topicIncomingMessageCopySubscribed = false;
    private HashMap<String, LinkedList<HistoryQueue>> topicHistoryToServer = new HashMap();
    private static final int MAX_TOPIC_QUEUE_LENGTH = 20;
    private LinkedList<HistoryQueue> historyQueuePool = new LinkedList();
    private LinkedHashSet<Address> platformsToRemove = new LinkedHashSet();

    public GISServerService(String systemName) {
        this.systemName = systemName;
        this.subscribeTopic(TOPIC_GIS_INTERNAL, this);
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    private synchronized void clearHistoryCache() {
        this.topicHistoryToServer.clear();
    }

    public void startService() {
        this.logFine("GISServerService started");
        this.as = new AutoConfiguratorServer(this, this.systemName);
        this.setThreadPersistency(true);
        Thread.currentThread().setPriority(Math.min(6, 10));
    }

    public void stopService() {
        this.as.kill();
    }

    private synchronized void broadcastTopicToClients(String topic, Object content, String reason) {
        if (this.remoteTopicListeners.containsKey(topic)) {
            Map listeners = this.remoteTopicListeners.get(topic);
            Message m = null;
            for (Map.Entry entry : listeners.entrySet()) {
                Address item = (Address)entry.getValue();
                if (m == null) {
                    m = Message.newInstance("INFORM", this.getAddress(), item);
                    m.setProtocol(topic);
                    if (reason != null) {
                        m.setReason(reason);
                    }
                    m.setContent(content);
                    continue;
                }
                m.addReceiver(item);
            }
            if (m != null) {
                block7: {
                    try {
                        this.sendMessageAsReference(m);
                    }
                    catch (InvisibleContainerException e) {
                        if (!Platform.SHOW_UNDELIVERED_MESSAGES) break block7;
                        this.logWarning("Topic info not sent - container not visible from MASTER: topic" + topic + ":" + e.toString());
                    }
                }
                m.release();
            }
        }
    }

    private synchronized void broadcastTopic(String topic, Object content, String reason) {
        this.broadcastTopicToClients(topic, content, reason);
        this.sendTopicToLocal(topic, content, reason, null, null);
    }

    private void removeInvisibleContainers() {
        if (this.platformsToRemove.size() > 0) {
            for (Address elem : this.platformsToRemove) {
                this.removeInvisibleContainer(elem);
            }
            this.platformsToRemove.clear();
        }
    }

    private synchronized void sendTopicToLocal(final String topic, final Object content, final String reason, final String remoteContainerName, final Address remoteClientAddress) {
        LinkedList<HistoryQueue> topicHistory;
        if (this.localTopicListeners.containsKey(topic)) {
            List listeners = this.localTopicListeners.get(topic);
            for (final GISTopicServerListener item : listeners) {
                if (topic.equals(TOPIC_GIS_INTERNAL)) {
                    item.handleTopic(topic, content, reason, remoteContainerName, remoteClientAddress);
                    continue;
                }
                item.addEvent(new Runnable(){

                    public void run() {
                        item.handleTopic(topic, content, reason, remoteContainerName, remoteClientAddress);
                    }
                });
            }
        }
        if ((topicHistory = this.topicHistoryToServer.get(topic)) == null) {
            topicHistory = new LinkedList();
            this.topicHistoryToServer.put(topic, topicHistory);
        }
        topicHistory.addLast(this.getHistoryQueue(content, reason));
        if (topicHistory.size() > 20) {
            this.freeHistoryQueue(topicHistory.removeFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HistoryQueue getHistoryQueue(Object content, String reason) {
        HistoryQueue hq;
        LinkedList<HistoryQueue> linkedList = this.historyQueuePool;
        synchronized (linkedList) {
            if (this.historyQueuePool.size() > 0) {
                hq = this.historyQueuePool.removeFirst();
                hq.update(content, reason);
            } else {
                hq = new HistoryQueue(content, reason);
            }
        }
        return hq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeHistoryQueue(HistoryQueue historyQueue) {
        HistoryQueue historyQueue2 = historyQueue;
        synchronized (historyQueue2) {
            if (historyQueue.used > 0) {
                historyQueue.markedForRemoval = true;
            } else {
                historyQueue.clear();
                LinkedList<HistoryQueue> linkedList = this.historyQueuePool;
                synchronized (linkedList) {
                    this.historyQueuePool.addFirst(historyQueue);
                }
            }
        }
    }

    private synchronized boolean sendTopic(String destinationContainer, String topic, Object content, String reason) {
        boolean retVal = this.sendTopicInternal(destinationContainer, topic, content, reason);
        this.removeInvisibleContainers();
        return retVal;
    }

    private boolean sendTopicInternal(String destinationContainer, String topic, Object content, String reason) {
        Map listeners;
        if (this.remoteTopicListeners.containsKey(topic) && (listeners = (Map)this.remoteTopicListeners.get(topic)).containsKey(destinationContainer)) {
            Message m;
            block5: {
                Address dest = (Address)listeners.get(destinationContainer);
                m = Message.newInstance("INFORM", this.getAddress(), dest);
                m.setProtocol(topic);
                if (reason != null) {
                    m.setReason(reason);
                }
                m.setContent(content);
                try {
                    this.sendMessageAsReference(m);
                }
                catch (InvisibleContainerException e) {
                    if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                        this.logWarning("Topic info not sent - container not visible from MASTER: topic: " + topic + " client: " + dest);
                    }
                    if (!e.invisibleTargetPlatform) break block5;
                    this.platformsToRemove.add(m.getReceiver().derivePlatformAddress());
                }
            }
            m.release();
            return true;
        }
        return false;
    }

    private void removeInvisibleContainer(Address destinationPlatform) {
        Iterator<Map.Entry<String, Address>> iter2 = this.registredContainers.entrySet().iterator();
        while (iter2.hasNext()) {
            final Map.Entry<String, Address> item2 = iter2.next();
            if (!item2.getValue().isSamePlatform(destinationPlatform)) continue;
            this.logWarning("Due to invisible target platform client container is removed : " + item2.getKey());
            Iterator<Map.Entry<String, LinkedHashMap<String, Address>>> iter = this.remoteTopicListeners.entrySet().iterator();
            while (iter.hasNext()) {
                List localListeners;
                final Map.Entry<String, LinkedHashMap<String, Address>> item = iter.next();
                LinkedHashMap<String, Address> subscribers = item.getValue();
                if (subscribers.containsKey(item2.getKey())) {
                    subscribers.remove(item2.getKey());
                    if (subscribers.size() == 0) {
                        iter.remove();
                    }
                }
                if ((localListeners = (List)this.localTopicListeners.get(item.getKey())) == null) continue;
                for (final GISTopicServerListener elem : localListeners) {
                    elem.addEvent(new Runnable(){

                        public void run() {
                            elem.handleLogoutTopic((String)item.getKey(), (String)item2.getKey());
                        }
                    });
                }
            }
            iter2.remove();
        }
        this.logSevere("registredContainers after removal: " + this.registredContainers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void subscribeTopic(final String topic, final GISTopicServerListener listener) {
        LinkedList<HistoryQueue> historyQueue;
        LinkedList<GISTopicServerListener> localSubscribers;
        Map remotes;
        if (!this.localTopicListeners.containsKey(topic)) {
            if (topic.equals("COMMUNICATION_INFO")) {
                this.topicCommunicationInfoSubscribed = true;
            } else if (topic.equals("OUTGOING_MESSAGE_COPY")) {
                this.topicOutgoingMessageCopySubscribed = true;
            } else if (topic.equals("INCOMING_MESSAGE_COPY")) {
                this.topicIncomingMessageCopySubscribed = true;
            }
            this.localTopicListeners.put(topic, new LinkedList());
        }
        List list = this.localTopicListeners.get(topic);
        list.add(listener);
        if (list.size() == 1 && this.remoteTopicListeners.containsKey(TOPIC_GIS_INTERNAL)) {
            remotes = this.remoteTopicListeners.get(TOPIC_GIS_INTERNAL);
            for (String string : remotes.keySet()) {
                this.sendTopicInternal(string, TOPIC_GIS_INTERNAL, topic, SUBSCRIBE);
            }
        }
        if (this.remoteTopicListeners.containsKey(topic)) {
            remotes = this.remoteTopicListeners.get(topic);
            for (final String string : remotes.keySet()) {
                final Address rAddr = (Address)remotes.get(string);
                listener.addEvent(new Runnable(){

                    public void run() {
                        listener.handleLoginTopic(topic, string, rAddr.deriveContainerAddress());
                    }
                });
            }
        }
        if ((localSubscribers = this.localTopicListeners.get(topic)) != null) {
            for (final GISTopicServerListener gISTopicServerListener : localSubscribers) {
                if (gISTopicServerListener == listener) continue;
                gISTopicServerListener.addEvent(new Runnable(){

                    public void run() {
                        gISTopicServerListener.handleLoginTopic(topic, null, null);
                    }
                });
            }
        }
        if ((historyQueue = this.topicHistoryToServer.get(topic)) != null) {
            Iterator iterator = historyQueue.iterator();
            while (iterator.hasNext()) {
                HistoryQueue item;
                HistoryQueue historyQueue2 = item = (HistoryQueue)iterator.next();
                synchronized (historyQueue2) {
                    HistoryQueue historyQueue3 = item;
                    historyQueue3.used = historyQueue3.used + 1;
                }
                listener.addEvent(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        listener.handleTopic(topic, item.content, item.reason, null, null);
                        HistoryQueue historyQueue = item;
                        synchronized (historyQueue) {
                            HistoryQueue historyQueue2 = item;
                            historyQueue2.used = historyQueue2.used - 1;
                            if (item.markedForRemoval) {
                                GISServerService.this.freeHistoryQueue(item);
                            }
                        }
                    }
                });
            }
        }
        this.removeInvisibleContainers();
    }

    private synchronized void unsubscribeTopic(final String topic, final GISTopicServerListener listener) {
        LinkedList<GISTopicServerListener> localSubscribers;
        Map remotes;
        List list = this.localTopicListeners.get(topic);
        if (list != null) {
            list.remove(listener);
            if (list.size() == 0) {
                if (topic.equals("COMMUNICATION_INFO")) {
                    this.topicCommunicationInfoSubscribed = false;
                } else if (topic.equals("OUTGOING_MESSAGE_COPY")) {
                    this.topicOutgoingMessageCopySubscribed = false;
                } else if (topic.equals("INCOMING_MESSAGE_COPY")) {
                    this.topicIncomingMessageCopySubscribed = false;
                }
                this.localTopicListeners.remove(topic);
                if (this.remoteTopicListeners.containsKey(TOPIC_GIS_INTERNAL)) {
                    remotes = this.remoteTopicListeners.get(TOPIC_GIS_INTERNAL);
                    for (String string : remotes.keySet()) {
                        this.sendTopicInternal(string, TOPIC_GIS_INTERNAL, topic, UNSUBSCRIBE);
                    }
                }
            }
        }
        if (this.remoteTopicListeners.containsKey(topic)) {
            remotes = this.remoteTopicListeners.get(topic);
            for (final String string : remotes.keySet()) {
                listener.addEvent(new Runnable(){

                    public void run() {
                        listener.handleLogoutTopic(topic, string);
                    }
                });
            }
        }
        if ((localSubscribers = this.localTopicListeners.get(topic)) != null) {
            for (final GISTopicServerListener gISTopicServerListener : localSubscribers) {
                if (gISTopicServerListener == listener) continue;
                gISTopicServerListener.addEvent(new Runnable(){

                    public void run() {
                        gISTopicServerListener.handleLogoutTopic(topic, null);
                    }
                });
            }
        }
        this.removeInvisibleContainers();
    }

    public void handleIncomingMessage(Message m) {
        String topic;
        if (m.getPerformative().equals("INFORM") && (topic = m.getProtocol()) != null) {
            Address sender = m.getSender();
            this.sendTopicToLocal(topic, m.getContent(), m.getReason(), sender.getContainerName(), sender.deriveContainerAddress());
            m.release();
            return;
        }
        this.logWarning("Unexpected incoming message: " + m);
        m.release();
    }

    public synchronized void handleTopic(String topic, final Object content, String reason, final String remoteContainerName, final Address remoteContainerAddress) {
        if (topic.equals(TOPIC_GIS_INTERNAL) && content instanceof String) {
            if (reason.equals(SUBSCRIBE)) {
                Address knownAddress = this.registredContainers.get(remoteContainerName);
                if (knownAddress == null) {
                    this.registredContainers.put(remoteContainerName, remoteContainerAddress);
                } else if (!knownAddress.equals(remoteContainerAddress)) {
                    if (content.equals(TOPIC_GIS_INTERNAL)) {
                        this.sendTopic(remoteContainerName, TOPIC_GIS_INTERNAL, "", KEEP_ALIVE);
                        if (this.registredContainers.containsKey(remoteContainerName)) {
                            Message m = Message.newInstance("FAILURE", this.getAddress(), remoteContainerAddress.deriveServiceAddress("gis/client"));
                            m.setContent("Client container with name '" + remoteContainerName + "' is already connected");
                            try {
                                this.sendMessageAsReference(m);
                            }
                            catch (InvisibleContainerException ex) {
                                this.logSevere("Cannot send failure message:\n" + m);
                            }
                            m.release();
                            return;
                        }
                        this.registredContainers.put(remoteContainerName, remoteContainerAddress);
                    } else {
                        return;
                    }
                }
                if (!this.remoteTopicListeners.containsKey(content)) {
                    this.remoteTopicListeners.put((String)content, new LinkedHashMap());
                }
                Map remotes = this.remoteTopicListeners.get(content);
                Address remoteClientServiceAddress = remoteContainerAddress.deriveServiceAddress("gis/client");
                remotes.put(remoteContainerName, remoteClientServiceAddress);
                if (this.localTopicListeners.containsKey(content)) {
                    List listeners = this.localTopicListeners.get(content);
                    for (final GISTopicServerListener item : listeners) {
                        item.addEvent(new Runnable(){

                            public void run() {
                                item.handleLoginTopic((String)content, remoteContainerName, remoteContainerAddress);
                            }
                        });
                    }
                }
                return;
            }
            if (reason.equals(UNSUBSCRIBE)) {
                if (content.equals(TOPIC_GIS_INTERNAL) && remoteContainerAddress.equals(this.registredContainers.get(remoteContainerName))) {
                    this.registredContainers.remove(remoteContainerName);
                }
                if (this.remoteTopicListeners.containsKey(content)) {
                    Map remotes = this.remoteTopicListeners.get(content);
                    Address previousRemoteAddress = (Address)remotes.get(remoteContainerName);
                    if (!remoteContainerAddress.isSameContainer(previousRemoteAddress)) {
                        return;
                    }
                    remotes.remove(remoteContainerName);
                }
                if (this.localTopicListeners.containsKey(content)) {
                    List listeners = this.localTopicListeners.get(content);
                    for (final GISTopicServerListener item : listeners) {
                        item.addEvent(new Runnable(){

                            public void run() {
                                item.handleLogoutTopic((String)content, remoteContainerName);
                            }
                        });
                    }
                }
                return;
            }
        }
        this.logWarning("Unexpected \ntopic: " + topic + "\ncontent: " + content + "\nreason:" + reason);
    }

    public synchronized void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
        for (String item : this.localTopicListeners.keySet()) {
            this.sendTopicInternal(remoteContainerName, TOPIC_GIS_INTERNAL, item, SUBSCRIBE);
        }
        this.removeInvisibleContainers();
    }

    public synchronized void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    public synchronized boolean hasSomeSubscriber(String topic) {
        return this.localTopicListeners.containsKey(topic) || this.remoteTopicListeners.containsKey(topic);
    }

    private class HistoryQueue {
        private Object content;
        private String reason;
        private boolean markedForRemoval;
        private int used;

        HistoryQueue(Object content, String reason) {
            this.update(content, reason);
        }

        void update(Object content, String reason) {
            this.content = content;
            this.reason = reason;
            this.markedForRemoval = false;
            this.used = 0;
        }

        void clear() {
            this.content = null;
            this.reason = null;
        }
    }

    public static class Shell
    extends ServiceShell {
        private static final long serialVersionUID = -78031146776937L;
        transient GISServerService theservice = null;
        private transient LinkedHashMap<GISTopicServerListener, LinkedHashSet<String>> topicListeners = new LinkedHashMap();

        public Shell() {
        }

        protected Shell(ElementaryEntity shellOwner, GISServerService _theservice) {
            super(shellOwner);
            this.theservice = _theservice;
        }

        public boolean isValid() {
            return this.theservice != null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
        }

        public void setContainer(AgentContainer container) throws Exception {
            ServiceShell ss = container.getServiceManager().getService(null, GISServerService.SERVICENAME);
            if (ss == null || !(ss instanceof Shell)) {
                throw new Exception(String.valueOf(container.getContainerName()) + ": Cannot reconect to the GIS Server Service");
            }
            this.theservice = ((Shell)ss).theservice;
        }

        public void postInit() {
        }

        public void subscribeTopic(String topic, GISTopicServerListener listener) {
            LinkedHashSet<String> subscribedTopics = this.topicListeners.get(listener);
            if (subscribedTopics == null) {
                subscribedTopics = new LinkedHashSet();
                this.topicListeners.put(listener, subscribedTopics);
            }
            if (subscribedTopics.contains(topic)) {
                return;
            }
            subscribedTopics.add(topic);
            this.theservice.subscribeTopic(topic, listener);
        }

        public void subscribeAgentTopic(String agentName, String topic, GISTopicServerListener listener) {
            this.subscribeTopic(String.valueOf(topic) + "_" + agentName, listener);
        }

        public void unsubscribeTopic(String topic) {
            for (Map.Entry<GISTopicServerListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                if (!item.getValue().contains(topic)) continue;
                this.theservice.unsubscribeTopic(topic, item.getKey());
                item.getValue().remove(topic);
            }
        }

        public void unsubscribeTopic(String topic, GISTopicServerListener listener) {
            LinkedHashSet<String> subscriptions = this.topicListeners.get(listener);
            if (subscriptions != null && subscriptions.contains(topic)) {
                this.theservice.unsubscribeTopic(topic, listener);
                subscriptions.remove(topic);
                if (subscriptions.size() == 0) {
                    this.topicListeners.remove(listener);
                }
            }
        }

        public void unsubscribeAgentTopic(String agentName, String topic) {
            this.unsubscribeTopic(String.valueOf(topic) + "_" + agentName);
        }

        public void unsubscribeAllTopics() {
            for (Map.Entry<GISTopicServerListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                for (String item1 : item.getValue()) {
                    this.theservice.unsubscribeTopic(item1, item.getKey());
                }
            }
            this.topicListeners.clear();
        }

        public void broadcastTopic(String topic, Object content, String reason) {
            this.theservice.broadcastTopic(topic, content, reason);
        }

        public void broadcastTopic(String topic, Object content) {
            this.theservice.broadcastTopic(topic, content, null);
        }

        public void broadcastTopicToClients(String topic, Object content, String reason) {
            this.theservice.broadcastTopicToClients(topic, content, reason);
        }

        public void broadcastTopicToClients(String topic, Object content) {
            this.theservice.broadcastTopicToClients(topic, content, null);
        }

        public void sendTopicToLocal(String topic, Object content, String reason) {
            this.theservice.sendTopicToLocal(topic, content, reason, null, null);
        }

        public void sendTopicToLocal(String topic, Object content) {
            this.theservice.sendTopicToLocal(topic, content, null, null, null);
        }

        public boolean sendTopic(String destinationContainer, String topic, Object content, String reason) {
            return this.theservice.sendTopic(destinationContainer, topic, content, reason);
        }

        public void sendAgentTopic(String agentName, String topic, Object content, String reason) {
            this.broadcastTopic(String.valueOf(topic) + "_" + agentName, content, reason);
        }

        public boolean sendTopic(String destinationContainer, String topic, Object content) {
            return this.theservice.sendTopic(destinationContainer, topic, content, null);
        }

        public void sendAgentTopic(String agentName, String topic, Object content) {
            this.sendAgentTopic(agentName, topic, content, null);
        }

        public String getSystemName() {
            return this.theservice.systemName;
        }

        public GISServerService getServiceInstance() {
            return this.theservice;
        }

        public void dispose() {
            this.unsubscribeAllTopics();
            super.dispose();
        }

        public boolean hasSomeCommunicationInfoSubscriber() {
            return this.theservice.topicCommunicationInfoSubscribed;
        }

        public boolean hasSomeOutgoingMessageCopySubscriber() {
            return this.theservice.topicOutgoingMessageCopySubscribed;
        }

        public boolean hasSomeIncomingMessageCopySubscriber() {
            return this.theservice.topicIncomingMessageCopySubscribed;
        }

        public boolean hasSomeSubscriber(String topic) {
            return this.theservice.hasSomeSubscriber(topic);
        }

        public void clearHistoryCache() {
            this.theservice.clearHistoryCache();
        }
    }
}

