/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.server;

import aglobe.container.service.Service;
import aglobe.platform.thread.AglobeThreadPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Logger;

public final class AutoConfiguratorServer
implements Runnable {
    public static final String REQUEST = "ServerAreYouThere?A-globe_ver4_1.System_name:";
    public static final int AUTO_CONFIGURATOR_BASE_PORT = 4444;
    public static final int AUTO_CONFIGURATOR_PORT_RANGE = 5;
    private DatagramSocket socket = null;
    private final Logger logger;
    private final Service owner;
    private final String requestString;
    private volatile boolean killing = false;
    private volatile boolean stopped = false;
    private Thread asThread = null;

    public static String getRequest(String systemName) {
        return REQUEST + systemName;
    }

    public AutoConfiguratorServer(Service owner, String systemName) {
        this.owner = owner;
        this.requestString = AutoConfiguratorServer.getRequest(systemName);
        this.logger = Logger.getLogger("AutoConfiguratorServer");
        int listeningPort = 4444;
        while (this.asThread == null && listeningPort < 4449) {
            try {
                this.socket = new DatagramSocket(listeningPort);
                this.socket.setBroadcast(true);
                this.socket.setSoTimeout(1000);
                this.asThread = AglobeThreadPool.getThread(owner.getContainer().getContainerThreadGroup(), this, String.valueOf(owner.getContainer().getContainerName()) + ": " + owner.getName() + ": AutoConfiguratorServerThread");
                this.asThread.setPriority(Math.min(7, 10));
                this.asThread.start();
            }
            catch (SocketException ex) {
                ++listeningPort;
            }
        }
        if (this.asThread == null) {
            this.logger.severe(String.valueOf(owner.getContainer().getContainerName()) + ": Autoconfigurator server: Cannot open any listening autoconfigurator port in range: " + 4444 + " - " + 4448);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            byte[] buf = new byte[1024];
            DatagramPacket dp = new DatagramPacket(buf, buf.length);
            try {
                this.socket.receive(dp);
                String s = new String(dp.getData(), 0, dp.getLength());
                if (!s.equals(this.requestString)) continue;
                byte[] replyBuf = this.owner.getAddress().toString().getBytes();
                DatagramPacket reply = new DatagramPacket(replyBuf, replyBuf.length, dp.getAddress(), dp.getPort());
                this.socket.send(reply);
            }
            catch (SocketTimeoutException s) {
            }
            catch (IOException ex) {
                this.logger.severe("Receiving exeption " + ex);
            }
        } while (!this.killing);
        this.socket.close();
        this.stopped = true;
        AutoConfiguratorServer autoConfiguratorServer = this;
        synchronized (autoConfiguratorServer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        this.killing = true;
        while (!this.stopped) {
            AutoConfiguratorServer autoConfiguratorServer = this;
            synchronized (autoConfiguratorServer) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

