/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.hwclient;

import aglobe.container.AgentContainer;
import aglobe.container.transport.Address;
import aglobe.ontology.VisibilityUpdate;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.hwclient.HWGISClientGUI;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HWGISClientService
extends GISClientService {
    public static final String REQUEST = "HWContainerAreYouThere?A-globe_ver4_1.System_name:";
    private static final int HW_REPLY_PORT = 4455;
    private static final int SCAN_CYCLE_LOOP_PERIOD = 1000;
    public HWGISClientGUI gui;
    private final String requestString;
    private long networkBase;
    private long netmask;
    private long addressRange;
    private HashSet<Long> localAddresses = new HashSet();
    private byte[] conversionBuffer = new byte[4];
    private ReplyServer replyServer;
    private Scanner scanner;
    private Address myContainerAddress;

    public HWGISClientService(String hwNetwork, String systemName, AgentContainer.Shutdown containerShutdownListener) throws Exception {
        super(containerShutdownListener);
        try {
            StringTokenizer st = new StringTokenizer(hwNetwork, "/");
            if (st.countTokens() != 2) {
                throw new Exception();
            }
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), ".");
            if (st2.countTokens() != 4) {
                throw new Exception();
            }
            this.networkBase = 0L;
            int i = 0;
            while (i < 4) {
                this.networkBase <<= 8;
                int part = Integer.parseInt(st2.nextToken());
                if (part < 0 || part > 255) {
                    throw new Exception();
                }
                this.networkBase |= (long)(part & 0xFF);
                ++i;
            }
            int m = Integer.parseInt(st.nextToken());
            if (m < 0 || m > 32) {
                throw new Exception();
            }
            this.netmask = -1 << 32 - m;
            this.addressRange = (long)Math.pow(2.0, 32 - m);
        }
        catch (Exception ex) {
            throw new Exception("Wrong hardwareVisibility attribute parameter that doesn't match template {network base IP/range}: " + hwNetwork);
        }
        this.requestString = REQUEST + systemName;
    }

    private InetAddress getInetAddress(long fromRaw) throws UnknownHostException {
        int i = 0;
        while (i < 4) {
            this.conversionBuffer[3 - i] = (byte)(fromRaw & 0xFFL);
            fromRaw >>= 8;
            ++i;
        }
        return InetAddress.getByAddress(this.conversionBuffer);
    }

    @Override
    public void startService() {
        this.GISServer = this.getAddress();
        this.myContainerAddress = this.getAddress().deriveContainerAddress();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    HWGISClientService.this.gui = new HWGISClientGUI(HWGISClientService.this);
                }
            });
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        try {
            this.replyServer = new ReplyServer();
        }
        catch (Exception ex) {
            this.logSevere(ex.toString());
            this.containerShutdownListener.shutdownContainer();
            return;
        }
        this.scanner = new Scanner();
    }

    @Override
    public void stopService() {
        if (this.replyServer != null) {
            this.replyServer.kill();
        }
        if (this.scanner != null) {
            this.scanner.kill();
        }
        if (this.gui != null) {
            this.gui.dispose();
        }
    }

    @Override
    protected void submitTopicToServer(String topic, Object content, String reason) {
    }

    private void parseVisibilityUpdate(LinkedHashSet<Address> visibleContainers) {
        VisibilityUpdate nfo = new VisibilityUpdate();
        nfo.setVisibilityID(1L);
        nfo.getVisibleContainerAddress().addAll(visibleContainers);
        this.submitTopicToLocal("VISIBILITY_UPDATES", nfo, null);
        if (this.gui != null) {
            this.gui.updateVisibleList(visibleContainers);
        }
    }

    private class ReplyServer
    implements Runnable {
        private DatagramSocket socket = null;
        private volatile boolean killing = false;
        private volatile boolean stopped = false;
        private Thread replyThread = null;

        private ReplyServer() throws Exception {
            try {
                this.socket = new DatagramSocket(4455);
                this.socket.setBroadcast(true);
                this.socket.setSoTimeout(1000);
                this.replyThread = AglobeThreadPool.getThread(HWGISClientService.this.getContainer().getContainerThreadGroup(), this, String.valueOf(HWGISClientService.this.getContainer().getContainerName()) + ": " + HWGISClientService.this.getName() + ": ReplyServerThread");
                this.replyThread.setPriority(Math.min(6, 10));
                this.replyThread.start();
            }
            catch (SocketException ex) {
                throw new Exception("Cannot create ReplyServer due to: " + ex.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] replyBuf = HWGISClientService.this.getAddress().deriveContainerAddress().toString().getBytes();
            DatagramPacket reply = new DatagramPacket(replyBuf, replyBuf.length);
            do {
                byte[] buf = new byte[1024];
                DatagramPacket dp = new DatagramPacket(buf, buf.length);
                try {
                    this.socket.receive(dp);
                    String s = new String(dp.getData(), 0, dp.getLength());
                    if (!s.equals(HWGISClientService.this.requestString)) continue;
                    reply.setPort(dp.getPort());
                    reply.setAddress(dp.getAddress());
                    this.socket.send(reply);
                }
                catch (SocketTimeoutException s) {
                }
                catch (IOException ex) {
                    HWGISClientService.this.logger.severe("Receiving exeption " + ex);
                }
            } while (!this.killing);
            this.socket.close();
            this.stopped = true;
            ReplyServer replyServer = this;
            synchronized (replyServer) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this.killing = true;
            while (!this.stopped) {
                ReplyServer replyServer = this;
                synchronized (replyServer) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class Scanner
    implements Runnable {
        private volatile boolean killing = false;
        private volatile boolean stopped = false;
        private Thread scannerThread = null;

        private Scanner() {
            this.scannerThread = AglobeThreadPool.getThread(HWGISClientService.this.getContainer().getContainerThreadGroup(), this, String.valueOf(HWGISClientService.this.getContainer().getContainerName()) + ": " + HWGISClientService.this.getName() + ": ScannersThread");
            this.scannerThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DatagramSocket socket;
            boolean someChange = false;
            LinkedHashSet lastVisibleContainers = new LinkedHashSet();
            LinkedHashSet<Address> visibleContainers = new LinkedHashSet<Address>();
            try {
                socket = new DatagramSocket();
            }
            catch (SocketException ex) {
                HWGISClientService.this.logSevere("Exception in the Scanner: " + ex.toString());
                return;
            }
            byte[] outBuf = HWGISClientService.this.requestString.getBytes();
            DatagramPacket senddp = new DatagramPacket(outBuf, outBuf.length);
            senddp.setPort(4455);
            byte[] inBuf = new byte[1024];
            DatagramPacket recdp = new DatagramPacket(inBuf, inBuf.length);
            boolean first = true;
            do {
                long i = 0L;
                while (i < HWGISClientService.this.addressRange) {
                    long curAddress = HWGISClientService.this.networkBase & HWGISClientService.this.netmask | i;
                    if (!HWGISClientService.this.localAddresses.contains(curAddress)) {
                        try {
                            InetAddress curIAddress = HWGISClientService.this.getInetAddress(curAddress);
                            if (first && curIAddress.isLoopbackAddress()) {
                                HWGISClientService.this.localAddresses.add(curAddress);
                            } else {
                                senddp.setAddress(curIAddress);
                                try {
                                    socket.send(senddp);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                int waits = 1000;
                try {
                    long stamp;
                    do {
                        try {
                            socket.setSoTimeout(waits);
                        }
                        catch (SocketException ex2) {
                            ex2.printStackTrace();
                        }
                        stamp = System.currentTimeMillis();
                        try {
                            socket.receive(recdp);
                            String recstr = new String(recdp.getData(), 0, recdp.getLength());
                            Address recaddr = Address.getAddress(recstr);
                            if (HWGISClientService.this.myContainerAddress == recaddr || !visibleContainers.add(recaddr) || someChange || lastVisibleContainers.remove(recaddr)) continue;
                            someChange = true;
                        }
                        catch (IOException ex4) {
                            if (!(ex4 instanceof SocketTimeoutException)) continue;
                            throw (SocketTimeoutException)ex4;
                        }
                    } while ((waits = (int)((long)waits - (System.currentTimeMillis() - stamp))) > 0);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                if (!someChange && lastVisibleContainers.size() > 0) {
                    someChange = true;
                }
                if (someChange) {
                    HWGISClientService.this.parseVisibilityUpdate(visibleContainers);
                }
                LinkedHashSet swapBuff = lastVisibleContainers;
                lastVisibleContainers = visibleContainers;
                visibleContainers = swapBuff;
                visibleContainers.clear();
                someChange = false;
                first = false;
            } while (!this.killing);
            this.stopped = true;
            Scanner scanner = this;
            synchronized (scanner) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this.killing = true;
            while (!this.stopped) {
                Scanner scanner = this;
                synchronized (scanner) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

