/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.hwclient;

import aglobe.container.transport.Address;
import aglobe.service.gis.hwclient.HWGISClientService;
import aglobe.util.gui.RememberPositionJFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HWGISClientGUI
extends RememberPositionJFrame {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable visibleContainers = new JTable();
    private AbstractTableModel visibleContainersTableModel;
    private TreeSet<Address> currentVisible = new TreeSet<Address>(new Comparator<Address>(){

        @Override
        public int compare(Address o1, Address o2) {
            return o1.toString().compareTo(o2.toString());
        }

        public boolean equals(Address obj) {
            return false;
        }
    });
    private Address[] visible = new Address[0];

    public HWGISClientGUI(HWGISClientService owner) {
        super(owner);
        try {
            this.jbInit();
            this.visibleContainersTableModel = new VisibleContainersTableModel();
            this.visibleContainers.setModel(this.visibleContainersTableModel);
            this.setSize(350, 300);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setTitle("HWGISClient");
        this.jLabel1.setText("Current visible containers:");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setMinimumSize(new Dimension(240, 150));
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add(this.visibleContainers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateVisibleList(LinkedHashSet<Address> visibleContainers) {
        this.currentVisible.clear();
        this.currentVisible.addAll(visibleContainers);
        Address[] addressArray = this.visible;
        synchronized (this.visible) {
            this.visible = this.currentVisible.toArray(new Address[this.currentVisible.size()]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.visibleContainersTableModel.fireTableDataChanged();
            return;
        }
    }

    private class VisibleContainersTableModel
    extends AbstractTableModel {
        private static final int COL_CONTAINER = 0;
        private final String[] COLUMNS = new String[]{"Visible container"};

        private VisibleContainersTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Address[] addressArray = HWGISClientGUI.this.visible;
            synchronized (addressArray) {
                return HWGISClientGUI.this.visible.length;
            }
        }

        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                Address[] addressArray = HWGISClientGUI.this.visible;
                synchronized (addressArray) {
                    switch (columnIndex) {
                        case 0: {
                            return HWGISClientGUI.this.visible[rowIndex].toString();
                        }
                    }
                }
            }
            catch (Exception ex) {
                return "";
            }
            return null;
        }

        public String getColumnName(int columnIndex) {
            return this.COLUMNS[columnIndex];
        }
    }
}

