/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.client;

import aglobe.container.AgentContainer;
import aglobe.container.ElementaryEntity;
import aglobe.container.service.Service;
import aglobe.container.service.ServiceShell;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISTopicListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class GISClientService
extends Service
implements GISTopicListener {
    public static final String SERVICENAME = "gis/client";
    private static final int MAX_TOPIC_QUEUE_LENGTH = 50;
    private static final long SERVER_REPLY_TIMEOUT = 15000L;
    private HashSet<String> serverTopics = new HashSet();
    private LinkedHashMap<String, LinkedList<GISTopicListener>> topicListeners = new LinkedHashMap();
    private HashMap<String, Object> lastTopicContentToLocal = new HashMap();
    private HashMap<String, String> lastTopicReasonToLocal = new HashMap();
    private HashMap<String, LinkedList<HistoryQueue>> topicHistoryToServer = new HashMap();
    protected Address GISServer = null;
    private boolean gisServerPresenceChecked = false;
    private boolean isThereGISServer = true;
    private boolean topicCommunicationInfoSubscribed = false;
    private boolean topicOutgoingMessageCopySubscribed = false;
    private boolean topicIncomingMessageCopySubscribed = false;
    private DirectoryService.Shell directoryShell;
    protected AgentContainer.Shutdown containerShutdownListener;
    private boolean initialized = false;
    private LinkedList<WaitingSubscription> waitingSubscriptionForInitialization = new LinkedList();

    protected GISClientService(AgentContainer.Shutdown containerShutdownListener) {
        this.containerShutdownListener = containerShutdownListener;
    }

    public GISClientService(Address serverAddress, AgentContainer.Shutdown containerShutdownListener) {
        this.containerShutdownListener = containerShutdownListener;
        this.GISServer = serverAddress;
        this.serverTopics.add("GIS_INTERNAL");
    }

    public ServiceShell getServiceShell(ElementaryEntity shellOwner) {
        return new Shell(shellOwner, this);
    }

    public void startService() {
        this.logFine("GISClientService started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterContainerInit() {
        LinkedList<WaitingSubscription> linkedList = this.waitingSubscriptionForInitialization;
        synchronized (linkedList) {
            this.initialized = true;
            this.subscribeTopic("GIS_INTERNAL", this);
            for (WaitingSubscription elem : this.waitingSubscriptionForInitialization) {
                this.subscribeTopic(elem.topic, elem.listener);
            }
            this.waitingSubscriptionForInitialization.clear();
            this.directoryShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(null, "container/directory");
            if (this.directoryShell != null) {
                try {
                    this.directoryShell.register((ElementaryEntity)this, (Collection<String>)Arrays.asList(SERVICENAME));
                }
                catch (DirectoryException ex) {
                    this.logSevere("Cannot register gis client service to the directory service: " + ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        if (this.directoryShell != null) {
            this.directoryShell.dispose();
        }
        LinkedHashMap<String, LinkedList<GISTopicListener>> linkedHashMap = this.topicListeners;
        synchronized (linkedHashMap) {
            Iterator<String> iter = this.topicListeners.keySet().iterator();
            while (iter.hasNext()) {
                String item = iter.next();
                if (item.equals("GIS_INTERNAL")) continue;
                this.submitTopicToServer("GIS_INTERNAL", item, "UNSUBSCRIBE");
                iter.remove();
            }
            this.submitTopicToServer("GIS_INTERNAL", "GIS_INTERNAL", "UNSUBSCRIBE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeTopic(final String topic, final GISTopicListener listener) {
        Cloneable cloneable = this.waitingSubscriptionForInitialization;
        synchronized (cloneable) {
            if (!this.initialized) {
                this.waitingSubscriptionForInitialization.add(new WaitingSubscription(topic, listener));
                return;
            }
        }
        cloneable = this.topicListeners;
        synchronized (cloneable) {
            if (!this.topicListeners.containsKey(topic)) {
                if (topic.equals("COMMUNICATION_INFO")) {
                    this.topicCommunicationInfoSubscribed = true;
                }
                if (topic.equals("OUTGOING_MESSAGE_COPY")) {
                    this.topicOutgoingMessageCopySubscribed = true;
                }
                if (topic.equals("INCOMING_MESSAGE_COPY")) {
                    this.topicIncomingMessageCopySubscribed = true;
                }
                this.topicListeners.put(topic, new LinkedList());
                this.submitTopicToServer("GIS_INTERNAL", topic, "SUBSCRIBE");
            }
            LinkedList<GISTopicListener> list = this.topicListeners.get(topic);
            list.addLast(listener);
            final Object lastContent = this.lastTopicContentToLocal.get(topic);
            final String lastReason = this.lastTopicReasonToLocal.get(topic);
            if (lastContent != null || lastReason != null) {
                listener.addEvent(new Runnable(){

                    public void run() {
                        listener.handleTopic(topic, lastContent, (String)lastReason);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeTopic(String topic, GISTopicListener listener) {
        LinkedHashMap<String, LinkedList<GISTopicListener>> linkedHashMap = this.topicListeners;
        synchronized (linkedHashMap) {
            List list = this.topicListeners.get(topic);
            if (list != null) {
                list.remove(listener);
                if (list.size() == 0) {
                    HashSet<String> hashSet;
                    this.topicListeners.remove(topic);
                    this.submitTopicToServer("GIS_INTERNAL", topic, "UNSUBSCRIBE");
                    if (topic.equals("COMMUNICATION_INFO")) {
                        hashSet = this.serverTopics;
                        synchronized (hashSet) {
                            if (!this.serverTopics.contains("COMMUNICATION_INFO")) {
                                this.topicCommunicationInfoSubscribed = false;
                            }
                        }
                    }
                    if (topic.equals("OUTGOING_MESSAGE_COPY")) {
                        hashSet = this.serverTopics;
                        synchronized (hashSet) {
                            if (!this.serverTopics.contains("OUTGOING_MESSAGE_COPY")) {
                                this.topicOutgoingMessageCopySubscribed = false;
                            }
                        }
                    }
                    if (topic.equals("INCOMING_MESSAGE_COPY")) {
                        hashSet = this.serverTopics;
                        synchronized (hashSet) {
                            if (!this.serverTopics.contains("INCOMING_MESSAGE_COPY")) {
                                this.topicIncomingMessageCopySubscribed = false;
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitTopicToServer(String topic, Object content, String reason) {
        if (this.gisServerPresenceChecked && !this.isThereGISServer) {
            return;
        }
        HashSet<String> hashSet = this.serverTopics;
        synchronized (hashSet) {
            if (!this.serverTopics.contains(topic)) {
                LinkedList<HistoryQueue> contentQueue = this.topicHistoryToServer.get(topic);
                if (contentQueue == null) {
                    contentQueue = new LinkedList();
                    this.topicHistoryToServer.put(topic, contentQueue);
                }
                contentQueue.addLast(new HistoryQueue(content, reason));
                if (contentQueue.size() > 50) {
                    contentQueue.removeFirst();
                }
                return;
            }
        }
        Message m = Message.newInstance("INFORM", this.getAddress(), this.GISServer);
        m.setProtocol(topic);
        if (reason != null) {
            m.setReason(reason);
        }
        m.setContent(content);
        try {
            this.sendMessageAsReference(m);
            if (!this.gisServerPresenceChecked) {
                this.getContainer().TIMER.schedule(new TimerTask(){

                    public void run() {
                        if (!GISClientService.this.gisServerPresenceChecked) {
                            GISClientService.this.logSevere("No reply from server container GIS. Shutdown A-globe container.");
                            GISClientService.this.gisServerPresenceChecked = true;
                            GISClientService.this.containerShutdownListener.shutdownContainer();
                        }
                    }
                }, 15000L);
            }
        }
        catch (InvisibleContainerException ex) {
            if (!this.gisServerPresenceChecked) {
                this.isThereGISServer = false;
                this.gisServerPresenceChecked = true;
            } else {
                this.isThereGISServer = false;
            }
            this.logSevere("Cannot communicate with server container GIS. Shutdown A-globe container.");
            this.containerShutdownListener.shutdownContainer();
        }
        m.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitTopicToLocal(final String topic, final Object content, final String reason) {
        LinkedHashMap<String, LinkedList<GISTopicListener>> linkedHashMap = this.topicListeners;
        synchronized (linkedHashMap) {
            this.lastTopicContentToLocal.put(topic, content);
            this.lastTopicReasonToLocal.put(topic, reason);
            if (this.topicListeners.containsKey(topic)) {
                List listeners = this.topicListeners.get(topic);
                for (final GISTopicListener item : listeners) {
                    item.addEvent(new Runnable(){

                        public void run() {
                            item.handleTopic(topic, content, reason);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equals("GIS_INTERNAL") && content instanceof String) {
            if (reason.equals("SUBSCRIBE")) {
                List topicHistory;
                HashSet<String> hashSet = this.serverTopics;
                synchronized (hashSet) {
                    if (content.equals("COMMUNICATION_INFO")) {
                        this.topicCommunicationInfoSubscribed = true;
                    } else if (content.equals("OUTGOING_MESSAGE_COPY")) {
                        this.topicOutgoingMessageCopySubscribed = true;
                    } else if (content.equals("INCOMING_MESSAGE_COPY")) {
                        this.topicIncomingMessageCopySubscribed = true;
                    }
                    this.serverTopics.add((String)content);
                    topicHistory = this.topicHistoryToServer.remove(content);
                }
                if (topicHistory != null) {
                    for (HistoryQueue item : topicHistory) {
                        this.submitTopicToServer((String)content, item.content, item.reason);
                    }
                }
                return;
            }
            if (reason.equals("UNSUBSCRIBE")) {
                HashSet<String> hashSet = this.serverTopics;
                synchronized (hashSet) {
                    LinkedHashMap<String, LinkedList<GISTopicListener>> linkedHashMap;
                    if (content.equals("COMMUNICATION_INFO")) {
                        linkedHashMap = this.topicListeners;
                        synchronized (linkedHashMap) {
                            if (!this.topicListeners.containsKey("COMMUNICATION_INFO")) {
                                this.topicCommunicationInfoSubscribed = false;
                            }
                        }
                    }
                    if (content.equals("OUTGOING_MESSAGE_COPY")) {
                        linkedHashMap = this.topicListeners;
                        synchronized (linkedHashMap) {
                            if (!this.topicListeners.containsKey("OUTGOING_MESSAGE_COPY")) {
                                this.topicOutgoingMessageCopySubscribed = false;
                            }
                        }
                    }
                    if (content.equals("INCOMING_MESSAGE_COPY")) {
                        linkedHashMap = this.topicListeners;
                        synchronized (linkedHashMap) {
                            if (!this.topicListeners.containsKey("INCOMING_MESSAGE_COPY")) {
                                this.topicIncomingMessageCopySubscribed = false;
                            }
                        }
                    }
                    this.serverTopics.remove(content);
                }
                return;
            }
            if (reason.equals("KEEP_ALIVE")) {
                return;
            }
        }
        this.logWarning("Unexpected handleTopic\ntopic: " + topic + "\ncontent: " + content + "\nreason:" + reason);
    }

    protected void handleIncomingMessage(Message m) {
        if (m.getPerformative().equals("INFORM")) {
            String topic = m.getProtocol();
            if (topic != null) {
                if (!this.gisServerPresenceChecked) {
                    this.isThereGISServer = true;
                    this.gisServerPresenceChecked = true;
                }
                this.submitTopicToLocal(topic, m.getContent(), m.getReason());
                m.release();
                return;
            }
        } else if (m.getPerformative().equals("FAILURE")) {
            String errorMsg = (String)m.getContent();
            this.logSevere("Server container refuse connection due to the error:\n" + errorMsg + "\nShutdown A-globe container.");
            this.containerShutdownListener.shutdownContainer();
            m.release();
            return;
        }
        this.logWarning("Unexpected incoming message: " + m);
        m.release();
    }

    private class HistoryQueue {
        public final Object content;
        public final String reason;

        HistoryQueue(Object content, String reason) {
            this.content = content;
            this.reason = reason;
        }
    }

    private class WaitingSubscription {
        private final String topic;
        private final GISTopicListener listener;

        WaitingSubscription(String topic, GISTopicListener listener) {
            this.topic = topic;
            this.listener = listener;
        }
    }

    public static class Shell
    extends ServiceShell {
        private static final long serialVersionUID = -780314042263776937L;
        private transient GISClientService theservice = null;
        private LinkedHashMap<GISTopicListener, LinkedHashSet<String>> topicListeners = new LinkedHashMap();
        private transient boolean postInit = false;
        private transient LinkedHashMap<GISTopicListener, LinkedHashSet<String>> memTopicListeners = new LinkedHashMap();

        public Shell() {
        }

        private Shell(ElementaryEntity shellOwner, GISClientService _theservice) {
            super(shellOwner);
            this.theservice = _theservice;
        }

        public boolean isValid() {
            return this.theservice != null;
        }

        public Address getServerAddress() {
            return this.theservice.GISServer;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeInt(this.topicListeners.size());
            for (Map.Entry<GISTopicListener, LinkedHashSet<String>> elem : this.topicListeners.entrySet()) {
                out.writeObject(elem.getKey());
                LinkedHashSet<String> val = elem.getValue();
                out.writeInt(val.size());
                for (String elem2 : val) {
                    Message.writeString(out, elem2);
                }
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            int cnt = in.readInt();
            this.topicListeners = new LinkedHashMap();
            int i = 0;
            while (i < cnt) {
                LinkedHashSet<String> val = new LinkedHashSet<String>();
                this.topicListeners.put((GISTopicListener)in.readObject(), val);
                int cnt2 = in.readInt();
                int i2 = 0;
                while (i2 < cnt2) {
                    val.add(Message.readString(in));
                    ++i2;
                }
                ++i;
            }
        }

        public void setContainer(AgentContainer container) throws Exception {
            ServiceShell ss = container.getServiceManager().getService(null, GISClientService.SERVICENAME);
            if (ss == null || !(ss instanceof Shell)) {
                throw new Exception(String.valueOf(container.getContainerName()) + ": Cannot reconect to the GIS Client Service");
            }
            this.theservice = ((Shell)ss).theservice;
            this.postInit = true;
            this.memTopicListeners = new LinkedHashMap<GISTopicListener, LinkedHashSet<String>>(this.topicListeners);
        }

        public void postInit() {
            if (!this.postInit) {
                return;
            }
            for (Map.Entry<GISTopicListener, LinkedHashSet<String>> item : this.memTopicListeners.entrySet()) {
                for (String item1 : item.getValue()) {
                    this.theservice.subscribeTopic(item1, item.getKey());
                }
            }
        }

        public void subscribeTopic(String topic, GISTopicListener listener) {
            LinkedHashSet<String> subscribedTopics = this.topicListeners.get(listener);
            if (subscribedTopics == null) {
                subscribedTopics = new LinkedHashSet();
                this.topicListeners.put(listener, subscribedTopics);
            }
            if (subscribedTopics.contains(topic)) {
                return;
            }
            subscribedTopics.add(topic);
            this.theservice.subscribeTopic(topic, listener);
        }

        public void subscribeAgentTopic(String topic, GISTopicListener listener) {
            this.subscribeTopic(String.valueOf(topic) + "_" + this.shellOwner.getAddress().getName(), listener);
        }

        public void unsubscribeTopic(String topic) {
            for (Map.Entry<GISTopicListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                if (!item.getValue().contains(topic)) continue;
                this.theservice.unsubscribeTopic(topic, item.getKey());
                item.getValue().remove(topic);
            }
        }

        public void unsubscribeTopic(String topic, GISTopicListener listener) {
            LinkedHashSet<String> subscriptions = this.topicListeners.get(listener);
            if (subscriptions != null && subscriptions.contains(topic)) {
                this.theservice.unsubscribeTopic(topic, listener);
                subscriptions.remove(topic);
                if (subscriptions.size() == 0) {
                    this.topicListeners.remove(listener);
                }
            }
        }

        public void unsubscribeAgentTopic(String topic) {
            this.unsubscribeTopic(String.valueOf(topic) + "_" + this.shellOwner.getAddress().getName());
        }

        private void unsubscribeAllTopics() {
            for (Map.Entry<GISTopicListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                for (String item1 : item.getValue()) {
                    this.theservice.unsubscribeTopic(item1, item.getKey());
                }
            }
            this.topicListeners.clear();
        }

        public void submitTopicToServer(String topic, Object content, String reason) {
            this.theservice.submitTopicToServer(topic, content, reason);
        }

        public void submitTopicToServer(String topic, Object content) {
            this.theservice.submitTopicToServer(topic, content, null);
        }

        public void submitTopicToLocal(String topic, Object content, String reason) {
            this.theservice.submitTopicToLocal(topic, content, reason);
        }

        public void submitTopicToLocal(String topic, Object content) {
            this.theservice.submitTopicToLocal(topic, content, null);
        }

        public void submitTopic(String topic, Object content, String reason) {
            this.theservice.submitTopicToLocal(topic, content, reason);
            this.theservice.submitTopicToServer(topic, content, reason);
        }

        public void submitAgentTopic(String topic, Object content, String reason) {
            this.submitTopic(String.valueOf(topic) + "_" + this.shellOwner.getAddress().getName(), content, reason);
        }

        public void submitTopic(String topic, Object content) {
            this.submitTopic(topic, content, null);
        }

        public void submitAgentTopic(String topic, Object content) {
            this.submitAgentTopic(topic, content, null);
        }

        public GISClientService getServiceInstance() {
            return this.theservice;
        }

        public void dispose() {
            for (Map.Entry<GISTopicListener, LinkedHashSet<String>> item : this.topicListeners.entrySet()) {
                for (String item1 : item.getValue()) {
                    this.theservice.unsubscribeTopic(item1, item.getKey());
                }
            }
            super.dispose();
        }

        public boolean hasSomeCommunicationInfoSubscriber() {
            return this.theservice.topicCommunicationInfoSubscribed;
        }

        public boolean hasSomeOutgoingMessageCopySubscriber() {
            return this.theservice.topicOutgoingMessageCopySubscribed;
        }

        public boolean hasSomeIncomingMessageCopySubscriber() {
            return this.theservice.topicIncomingMessageCopySubscribed;
        }
    }
}

