/*
 * Decompiled with CFR 0.152.
 */
package aglobe.service.gis.client;

import aglobe.container.transport.Address;
import aglobe.service.gis.server.AutoConfiguratorServer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public final class AutoConfiguratorClient {
    private AutoConfiguratorClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Address getServerAddress(String systemName) {
        Address gisAddress = null;
        try {
            DatagramPacket senddp;
            int portOffset;
            DatagramPacket recdp;
            byte[] outBuf;
            DatagramSocket socket;
            block28: {
                int i;
                byte[] rawLocalAddress;
                socket = new DatagramSocket();
                socket.setBroadcast(true);
                socket.setSoTimeout(100);
                outBuf = AutoConfiguratorServer.getRequest(systemName).getBytes();
                byte[] inBuf = new byte[1024];
                recdp = new DatagramPacket(inBuf, inBuf.length);
                portOffset = 0;
                while (true) {
                    if (portOffset >= 5) {
                        try {
                            socket.receive(recdp);
                            String recstr = new String(recdp.getData(), 0, recdp.getLength());
                            return Address.getAddress(recstr);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            socket.setSoTimeout(1000);
                            rawLocalAddress = InetAddress.getLocalHost().getAddress();
                            if (rawLocalAddress.length == 4) {
                                int firstnumber = rawLocalAddress[0] & 0xFF;
                                int subnet = 0;
                                if (firstnumber <= 127) {
                                    subnet = 3;
                                } else if (firstnumber <= 191) {
                                    subnet = 2;
                                } else if (firstnumber <= 223) {
                                    subnet = 1;
                                }
                                i = 4 - subnet;
                                break;
                            }
                            break block28;
                        }
                    }
                    senddp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getLocalHost(), 4444 + portOffset);
                    try {
                        socket.send(senddp);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++portOffset;
                }
                while (true) {
                    if (i >= 4) {
                        portOffset = 0;
                        break;
                    }
                    rawLocalAddress[i] = -1;
                    ++i;
                }
                while (portOffset < 5) {
                    senddp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getByAddress(rawLocalAddress), 4444 + portOffset);
                    try {
                        socket.send(senddp);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++portOffset;
                }
            }
            try {
                socket.receive(recdp);
                String recstr = new String(recdp.getData(), 0, recdp.getLength());
                return Address.getAddress(recstr);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                portOffset = 0;
            }
            while (true) {
                if (portOffset >= 5) {
                    socket.receive(recdp);
                    String recstr = new String(recdp.getData(), 0, recdp.getLength());
                    return Address.getAddress(recstr);
                }
                senddp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getByName("255.255.255.255"), 4444 + portOffset);
                try {
                    socket.send(senddp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++portOffset;
            }
        }
        catch (SocketTimeoutException socket) {
            return gisAddress;
        }
        catch (UnknownHostException ex) {
            Logger.getLogger("Container").severe("Cannot create broadcast packet " + ex);
            return gisAddress;
        }
        catch (SocketException ex) {
            Logger.getLogger("Container").severe("Socket creation error" + ex);
            return gisAddress;
        }
        catch (IOException ex) {
            Logger.getLogger("Container").severe("Socket send error" + ex);
        }
        return gisAddress;
    }
}

