/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.transport;

import aglobe.container.MessageReceiver;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.platform.transport.ByteBufferInputStream;
import aglobe.platform.transport.ByteBufferOutputStream;
import aglobe.platform.transport.MessageTransport;
import aglobe.platform.transport.MessageTransportLayerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.HashMap;

class UdpMessageTransportLayerImpl
implements MessageTransportLayerImpl,
Runnable {
    private static final int MESSAGE_FRAGMENT_HEADER_LENGTH = 8;
    private static final long WAIT_FOR_MSG_MILLIS = 3000L;
    private static final long HOLD_IGNORE_INFO_FOR_MILLIS = 30000L;
    private final int udpSocketBufferSize;
    private final int mtu;
    private final int usefullMsgPartContentSize;
    private final int port;
    private boolean stop;
    private Object stopLock = new Object();
    private boolean finished;
    private DatagramChannel socketChannel;
    private DatagramSocket socket;
    private final Thread receivingThread;
    private ByteBuffer outputBuffer;
    private ByteBufferOutputStream outputStream;
    private final HashMap<Address, InetSocketAddress> socketAddress = new HashMap();
    private int outgoingMessageID = 0;
    private HashMap<String, MsgToIgnore> msgToIgnore = new HashMap();
    private MsgToIgnore msgToIgnoreHead = null;
    private HashMap<String, IncompleteMsg> incompleteMsg = new HashMap();
    private IncompleteMsg incompleteMsgHead = null;

    UdpMessageTransportLayerImpl(int _port, int mtu) throws IOException {
        this.port = _port;
        this.mtu = mtu;
        this.usefullMsgPartContentSize = mtu - 20 - 8 - 8;
        this.udpSocketBufferSize = mtu * 20;
        this.stop = false;
        this.finished = false;
        this.socketChannel = DatagramChannel.open();
        this.socketChannel.configureBlocking(true);
        this.socket = this.socketChannel.socket();
        this.socket.setBroadcast(false);
        this.socket.setTrafficClass(24);
        this.socket.setReuseAddress(false);
        this.socket.setSendBufferSize(this.udpSocketBufferSize);
        this.socket.setReceiveBufferSize(524288);
        this.socket.bind(new InetSocketAddress(this.port));
        this.allocateOutputBuffer(65536);
        this.msgToIgnoreHead = new MsgToIgnore(null);
        this.msgToIgnoreHead.next = this.msgToIgnoreHead;
        this.msgToIgnoreHead.prev = this.msgToIgnoreHead;
        this.incompleteMsgHead = new IncompleteMsg(null, 0, 0, 0);
        this.incompleteMsgHead.next = this.incompleteMsgHead;
        this.incompleteMsgHead.prev = this.incompleteMsgHead;
        this.receivingThread = AglobeThreadPool.getThread(Platform.getPlatformThreadGroup(), this, "UDP Message transport: Receiving Thread");
        this.receivingThread.setPriority(Math.min(7, 10));
        this.receivingThread.start();
    }

    private void allocateOutputBuffer(int capacity) throws IOException {
        this.outputBuffer = ByteBuffer.allocateDirect(capacity);
        this.outputStream = new ByteBufferOutputStream(this.outputBuffer);
    }

    public InetSocketAddress getLocalAddress() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getLocalHost(), this.socket.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMessageTransport() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stop = true;
            try {
                this.socketChannel.close();
            }
            catch (IOException iOException) {}
            while (!this.finished) {
                try {
                    this.stopLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static void writeShort(int v, ByteBuffer outputBuffer) {
        outputBuffer.put((byte)(v >>> 8));
        outputBuffer.put((byte)v);
    }

    static void writeInt(int v, ByteBuffer outputBuffer) {
        outputBuffer.put((byte)(v >>> 24));
        outputBuffer.put((byte)(v >>> 16));
        outputBuffer.put((byte)(v >>> 8));
        outputBuffer.put((byte)v);
    }

    static int readShort(ByteBuffer inputBuffer) {
        int retVal = 0;
        retVal |= (inputBuffer.get() & 0xFF) << 8;
        return retVal |= inputBuffer.get() & 0xFF;
    }

    static int readInt(ByteBuffer inputBuffer) {
        int retVal = 0;
        retVal |= (inputBuffer.get() & 0xFF) << 24;
        retVal |= (inputBuffer.get() & 0xFF) << 16;
        retVal |= (inputBuffer.get() & 0xFF) << 8;
        return retVal |= inputBuffer.get() & 0xFF;
    }

    public synchronized Object[] transmitMessage(Message m, boolean needMessageCopy) throws IOException {
        byte[] binaryMsg = null;
        int msgSize = 0;
        byte[] receiver = m.getReceiver().toString().getBytes();
        int msgHeaderLength = 2 + receiver.length + 4;
        int initMsgPosition = 8 + msgHeaderLength;
        int msgLength = 0;
        boolean ok = false;
        this.outputBuffer.clear();
        while (!ok) {
            try {
                this.outputBuffer.position(initMsgPosition);
                m.serialize(this.outputStream);
                msgLength = this.outputBuffer.position() - initMsgPosition;
                if (needMessageCopy) {
                    binaryMsg = new byte[msgLength];
                    this.outputBuffer.position(initMsgPosition);
                    this.outputBuffer.get(binaryMsg);
                }
                ok = true;
            }
            catch (BufferOverflowException ex) {
                this.allocateOutputBuffer(this.outputBuffer.capacity() * 2);
            }
            catch (IOException ex) {
                MessageTransport.logger.severe("Message encoding error " + ex);
                throw ex;
            }
        }
        this.outputBuffer.position(8);
        UdpMessageTransportLayerImpl.writeShort(receiver.length, this.outputBuffer);
        this.outputBuffer.put(receiver);
        UdpMessageTransportLayerImpl.writeInt(msgLength, this.outputBuffer);
        int toTransmit = msgLength + msgHeaderLength;
        int numberOfFragments = (int)Math.ceil((double)toTransmit / (double)this.usefullMsgPartContentSize);
        msgSize = toTransmit + numberOfFragments * 8;
        Address targetPlatformAddress = m.getReceiver().derivePlatformAddress();
        InetSocketAddress targetSocketAddress = this.socketAddress.get(targetPlatformAddress);
        if (targetSocketAddress == null) {
            targetSocketAddress = new InetSocketAddress(targetPlatformAddress.getHost(), targetPlatformAddress.getPort());
            this.socketAddress.put(targetPlatformAddress, targetSocketAddress);
        }
        int i = 0;
        while (i < numberOfFragments) {
            int fragmentStart = i * this.usefullMsgPartContentSize;
            int dataToSent = i != numberOfFragments - 1 ? 8 + this.usefullMsgPartContentSize : 8 + (toTransmit - (numberOfFragments - 1) * this.usefullMsgPartContentSize);
            this.outputBuffer.position(fragmentStart);
            UdpMessageTransportLayerImpl.writeShort(this.outgoingMessageID, this.outputBuffer);
            UdpMessageTransportLayerImpl.writeShort(this.usefullMsgPartContentSize, this.outputBuffer);
            UdpMessageTransportLayerImpl.writeShort(i, this.outputBuffer);
            UdpMessageTransportLayerImpl.writeShort(numberOfFragments, this.outputBuffer);
            this.outputBuffer.position(fragmentStart);
            this.outputBuffer.limit(fragmentStart + dataToSent);
            this.socketChannel.send(this.outputBuffer, targetSocketAddress);
            while (this.outputBuffer.remaining() > 0) {
                Thread.yield();
                this.socketChannel.send(this.outputBuffer, targetSocketAddress);
            }
            ++i;
        }
        ++this.outgoingMessageID;
        return new Object[]{binaryMsg, msgSize};
    }

    private boolean testIfIgnore(String msgId) {
        MsgToIgnore mti = this.msgToIgnore.get(msgId);
        if (mti != null) {
            mti.timestamp = System.currentTimeMillis();
            mti.prev.next = mti.next;
            mti.next.prev = mti.prev;
            this.msgToIgnoreHead.prev.next = mti;
            mti.prev = this.msgToIgnoreHead.prev;
            mti.next = this.msgToIgnoreHead;
            this.msgToIgnoreHead.prev = mti;
            return true;
        }
        return false;
    }

    private void addToIgnore(String msgId) {
        MsgToIgnore mti = new MsgToIgnore(msgId);
        this.msgToIgnore.put(msgId, mti);
        mti.timestamp = System.currentTimeMillis();
        this.msgToIgnoreHead.prev.next = mti;
        mti.prev = this.msgToIgnoreHead.prev;
        mti.next = this.msgToIgnoreHead;
        this.msgToIgnoreHead.prev = mti;
    }

    private IncompleteMsg testIfKnown(String msgId) {
        IncompleteMsg im = this.incompleteMsg.get(msgId);
        if (im != null) {
            im.timestamp = System.currentTimeMillis();
            im.prev.next = im.next;
            im.next.prev = im.prev;
            this.incompleteMsgHead.prev.next = im;
            im.prev = this.incompleteMsgHead.prev;
            im.next = this.incompleteMsgHead;
            this.incompleteMsgHead.prev = im;
            return im;
        }
        return null;
    }

    private void addToIncomplete(IncompleteMsg im) {
        this.incompleteMsg.put(im.msgId, im);
        im.timestamp = System.currentTimeMillis();
        this.incompleteMsgHead.prev.next = im;
        im.prev = this.incompleteMsgHead.prev;
        im.next = this.incompleteMsgHead;
        this.incompleteMsgHead.prev = im;
    }

    private void removeFromIncomplete(IncompleteMsg im) {
        im.prev.next = im.next;
        im.next.prev = im.prev;
        this.incompleteMsg.remove(im.msgId);
    }

    private void clearQueues() {
        MsgToIgnore mti;
        IncompleteMsg im;
        long curTime = System.currentTimeMillis();
        long msgFrom = curTime - 3000L;
        while ((im = this.incompleteMsgHead.next) != this.incompleteMsgHead && im.timestamp < msgFrom) {
            this.removeFromIncomplete(im);
            this.addToIgnore(im.msgId);
        }
        long ignoreFrom = curTime - 30000L;
        while ((mti = this.msgToIgnoreHead.next) != this.msgToIgnoreHead && mti.timestamp < ignoreFrom) {
            mti.prev.next = mti.next;
            mti.next.prev = mti.prev;
            this.msgToIgnore.remove(mti.msgId);
        }
    }

    private void parseMsg(aglobe.container.transport.MessageTransport destinationMt, MessageReceiver receiver, ByteBuffer inputBuffer, InputStream inputStream) {
        try {
            int msgLength = UdpMessageTransportLayerImpl.readInt(inputBuffer);
            inputBuffer.limit(inputBuffer.position() + msgLength);
            boolean needIncomingMessageCopy = destinationMt.requestIncomingMessageCopy();
            Message m = null;
            byte[] binaryMsg = null;
            int startp = inputBuffer.position();
            m = Message.deserialize(inputStream, (ClassLoaderOwner)((Object)receiver));
            if (needIncomingMessageCopy && !m.getDoNotSniff()) {
                if (inputBuffer.hasArray()) {
                    binaryMsg = new byte[msgLength];
                    System.arraycopy(inputBuffer.array(), startp, binaryMsg, 0, msgLength);
                } else {
                    inputBuffer.position(startp);
                    binaryMsg = new byte[msgLength];
                    inputBuffer.get(binaryMsg);
                }
            }
            receiver.incomingMessage(m);
            if (binaryMsg != null || needIncomingMessageCopy && !m.getDoNotSniff()) {
                destinationMt.sendIncomingMessageCopy(m, binaryMsg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageTransport.logger.severe("Error parsing received message: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ByteBuffer inputBuffer = ByteBuffer.allocateDirect(65536);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBuffer);
        while (!this.stop) {
            try {
                HashMap<String, aglobe.container.transport.MessageTransport> hashMap;
                Address receiverAddress;
                byte[] recBytes;
                int recipientLength;
                aglobe.container.transport.MessageTransport destinationMt;
                MessageReceiver receiver;
                int fragmentPosition;
                this.clearQueues();
                inputBuffer.clear();
                InetSocketAddress sender = (InetSocketAddress)this.socketChannel.receive(inputBuffer);
                inputBuffer.flip();
                int fragmentMsgId = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                String msgId = String.valueOf(sender.getAddress().getHostAddress()) + ":" + sender.getPort() + ":" + fragmentMsgId;
                if (this.testIfIgnore(msgId)) continue;
                IncompleteMsg im = this.testIfKnown(msgId);
                if (im != null) {
                    inputBuffer.position(4);
                    fragmentPosition = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                    inputBuffer.position(8);
                    inputBuffer.get(im.msgBufferArray, fragmentPosition * im.fragmentSize, inputBuffer.remaining());
                    IncompleteMsg incompleteMsg = im;
                    incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                    if (im.parsedFragments != im.totalFragments) continue;
                    receiver = im.receiver;
                    destinationMt = im.destinationMt;
                    if (receiver == null) {
                        recipientLength = im.recipientLength;
                        if (recipientLength < 0) {
                            recipientLength = UdpMessageTransportLayerImpl.readInt(im.msgBuffer);
                        } else {
                            im.msgBuffer.position(2);
                        }
                        recBytes = new byte[recipientLength];
                        inputBuffer.get(recBytes);
                        receiverAddress = Address.getAddress(new String(recBytes));
                        hashMap = MessageTransport.containerMT;
                        synchronized (hashMap) {
                            destinationMt = MessageTransport.containerMT.get(receiverAddress.getContainerName());
                        }
                        if (destinationMt != null) {
                            receiver = destinationMt.getMessageReceiver(receiverAddress);
                            if (receiver == null && Platform.SHOW_UNDELIVERED_MESSAGES) {
                                MessageTransport.logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found: " + receiverAddress);
                            }
                        } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                            MessageTransport.logger.warning("Target local container not found: " + receiverAddress);
                        }
                    } else {
                        im.msgBuffer.position(2 + im.recipientLength);
                    }
                    if (receiver != null) {
                        ByteBufferInputStream adhocInputStream = new ByteBufferInputStream(im.msgBuffer);
                        this.parseMsg(destinationMt, receiver, im.msgBuffer, adhocInputStream);
                    }
                    this.removeFromIncomplete(im);
                    continue;
                }
                int fragmentSize = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                fragmentPosition = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                int totalFragments = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                if (fragmentPosition == 0) {
                    recipientLength = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                    if (recipientLength + 2 <= fragmentSize) {
                        recBytes = new byte[recipientLength];
                        inputBuffer.get(recBytes);
                        receiverAddress = Address.getAddress(new String(recBytes));
                        hashMap = MessageTransport.containerMT;
                        synchronized (hashMap) {
                            destinationMt = MessageTransport.containerMT.get(receiverAddress.getContainerName());
                        }
                        if (destinationMt != null) {
                            receiver = destinationMt.getMessageReceiver(receiverAddress);
                            if (receiver != null) {
                                if (totalFragments == 1) {
                                    this.parseMsg(destinationMt, receiver, inputBuffer, inputStream);
                                    continue;
                                }
                                inputBuffer.position(8);
                                im = new IncompleteMsg(msgId, fragmentSize, totalFragments, recipientLength);
                                im.receiver = receiver;
                                im.destinationMt = destinationMt;
                                inputBuffer.get(im.msgBufferArray, fragmentPosition * fragmentSize, inputBuffer.remaining());
                                IncompleteMsg incompleteMsg = im;
                                incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                                this.addToIncomplete(im);
                                continue;
                            }
                            if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                MessageTransport.logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found: " + receiverAddress);
                            }
                            this.addToIgnore(msgId);
                            continue;
                        }
                        if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                            MessageTransport.logger.warning("Target local container not found: " + receiverAddress);
                        }
                        this.addToIgnore(msgId);
                        continue;
                    }
                    inputBuffer.position(8);
                    im = new IncompleteMsg(msgId, fragmentSize, totalFragments, recipientLength);
                    inputBuffer.get(im.msgBufferArray, fragmentPosition * fragmentSize, inputBuffer.remaining());
                    IncompleteMsg incompleteMsg = im;
                    incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                    this.addToIncomplete(im);
                    continue;
                }
                im = new IncompleteMsg(msgId, fragmentSize, totalFragments, -1);
                inputBuffer.get(im.msgBufferArray, fragmentPosition * fragmentSize, inputBuffer.remaining());
                IncompleteMsg incompleteMsg = im;
                incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                this.addToIncomplete(im);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this.stopLock;
        synchronized (object) {
            this.finished = true;
            this.stopLock.notify();
        }
    }

    private static class MsgToIgnore {
        private final String msgId;
        private long timestamp;
        private MsgToIgnore prev;
        private MsgToIgnore next;

        private MsgToIgnore(String msgId) {
            this.msgId = msgId;
        }
    }

    private static class IncompleteMsg {
        private final String msgId;
        private long timestamp;
        private IncompleteMsg prev;
        private IncompleteMsg next;
        private final int fragmentSize;
        private final int totalFragments;
        private int parsedFragments;
        private final int recipientLength;
        private MessageReceiver receiver;
        private aglobe.container.transport.MessageTransport destinationMt;
        private final ByteBuffer msgBuffer;
        private final byte[] msgBufferArray;

        private IncompleteMsg(String msgId, int fragmentSize, int totalFragments, int recipientLength) {
            this.msgId = msgId;
            this.parsedFragments = 0;
            this.fragmentSize = fragmentSize;
            this.totalFragments = totalFragments;
            int bufSize = fragmentSize * totalFragments + 1;
            this.msgBuffer = ByteBuffer.allocate(bufSize);
            this.msgBuffer.flip();
            this.msgBuffer.limit(bufSize);
            this.msgBufferArray = this.msgBuffer.array();
            this.recipientLength = recipientLength;
            this.receiver = null;
        }
    }
}

