/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.transport;

import aglobe.container.MessageReceiver;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.platform.transport.ByteBufferInputStream;
import aglobe.platform.transport.ByteBufferOutputStream;
import aglobe.platform.transport.MessageTransport;
import aglobe.platform.transport.MessageTransportLayerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;

class TcpMessageTransportLayerImpl
implements MessageTransportLayerImpl,
Runnable {
    private static final int CONNECTION_OPEN_TIMEOUT = 500;
    private static final int TCP_SOCKET_BUFFER_SIZE = 204800;
    private static final int HEADER_LENGTH = 4;
    private final int port;
    private final Thread receivingThread;
    private Thread acceptThread;
    private ServerSocketChannel ssc;
    private final Selector selector;
    private volatile boolean wake = false;
    private Selector acceptSelector;
    private Object stopLock = new Object();
    private boolean stop;
    private boolean finished;
    private boolean finishedAccept;
    private boolean hwMode;
    private final Object lock = new Object();
    private final Object registerNewLock = new Object();
    private final HashMap<String, Connection> connectionByDestination = new HashMap();
    private final HashMap<SocketChannel, Connection> connectionByChannel = new HashMap();

    TcpMessageTransportLayerImpl(int _port, boolean hwMode) throws IOException, Exception {
        this.port = _port;
        this.stop = false;
        this.finished = false;
        this.finishedAccept = false;
        this.hwMode = hwMode;
        this.selector = Selector.open();
        this.receivingThread = AglobeThreadPool.getThread(Platform.getPlatformThreadGroup(), this, "TCP Message transport: Receiving Thread");
        this.receivingThread.setPriority(Math.min(7, 10));
        this.receivingThread.start();
        new AcceptLayer();
    }

    public InetSocketAddress getLocalAddress() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getLocalHost(), this.ssc.socket().getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopMessageTransport() {
        Object object = this.registerNewLock;
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.wake = true;
                this.selector.wakeup();
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.wake = false;
                this.stop = true;
                this.lock.notify();
            }
        }
        this.acceptSelector.wakeup();
        object = this.stopLock;
        synchronized (object) {
            while (!this.finished || !this.finishedAccept) {
                try {
                    this.stopLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.selector.close();
            this.ssc.close();
            this.closeAllConnection();
            return;
        }
        catch (IOException ex1) {
            MessageTransport.logger.severe("Can't close listening socket.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block12: while (true) {
                Object it2;
                if (this.stop) {
                    it2 = this.stopLock;
                    synchronized (it2) {
                        this.finished = true;
                        this.stopLock.notify();
                        return;
                    }
                }
                int numKeys = !this.wake ? this.selector.select() : 0;
                if (numKeys > 0) {
                    it2 = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!it2.hasNext()) continue block12;
                        SelectionKey rsk = (SelectionKey)it2.next();
                        int rskOps = rsk.readyOps();
                        if ((rskOps & 1) != 1) continue;
                        Connection connection = this.getConnection((SocketChannel)rsk.channel());
                        it2.remove();
                        try {
                            if (connection.socketChannel.read(connection.inputBuffer) < 0) {
                                rsk.cancel();
                                this.closeConnection(connection);
                                this.removeConnection(connection);
                                continue;
                            }
                            connection.parse();
                        }
                        catch (IOException ex2) {
                            rsk.cancel();
                            this.closeConnection(connection);
                            this.removeConnection(connection);
                        }
                    }
                }
                if (!this.wake) continue;
                try {
                    it2 = this.lock;
                    synchronized (it2) {
                        this.lock.notify();
                        this.lock.wait();
                        continue;
                    }
                }
                catch (InterruptedException it2) {
                    // empty catch block
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            MessageTransport.logger.severe("Polling Message Transport Layer Error " + ex);
        }
    }

    private void closeConnection(Connection con) {
        try {
            con.socket.shutdownInput();
            con.socket.shutdownOutput();
            con.socket.close();
            con.socketChannel.close();
        }
        catch (IOException ex) {
            MessageTransport.logger.severe("Cannot close socket " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnection() {
        HashMap<String, Connection> hashMap = this.connectionByDestination;
        synchronized (hashMap) {
            for (Connection item : this.connectionByChannel.values()) {
                this.closeConnection(item);
            }
            this.connectionByDestination.clear();
            this.connectionByChannel.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(SocketChannel _socketChannel) throws SocketException, IOException {
        Connection con;
        Object object = this.connectionByDestination;
        synchronized (object) {
            if (this.connectionByChannel.containsKey(_socketChannel)) {
                return this.connectionByChannel.get(_socketChannel);
            }
            _socketChannel.configureBlocking(false);
            Socket socket = _socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.setReuseAddress(true);
            socket.setTrafficClass(24);
            socket.setSendBufferSize(204800);
            socket.setReceiveBufferSize(204800);
            String destination = String.valueOf(socket.getInetAddress().getHostAddress()) + ":" + socket.getPort();
            con = new Connection(socket, _socketChannel, destination, false);
            if (!this.hwMode) {
                this.connectionByDestination.put(destination, con);
            }
            this.connectionByChannel.put(_socketChannel, con);
        }
        object = this.registerNewLock;
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.wake = true;
                this.selector.wakeup();
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.wake = false;
                _socketChannel.register(this.selector, 1);
                this.lock.notify();
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(Address destinationAddress) throws IOException {
        Connection con;
        SocketChannel sch;
        String destination = String.valueOf(destinationAddress.getHost()) + ":" + destinationAddress.getPort();
        Object object = this.connectionByDestination;
        synchronized (object) {
            if (!this.hwMode && this.connectionByDestination.containsKey(destination)) {
                return this.connectionByDestination.get(destination);
            }
            sch = SocketChannel.open();
            Socket socket = sch.socket();
            socket.setReuseAddress(true);
            socket.connect(new InetSocketAddress(destinationAddress.getHost(), destinationAddress.getPort()), 500);
            if (!this.hwMode) {
                sch.configureBlocking(false);
            }
            socket.setTcpNoDelay(true);
            socket.setTrafficClass(24);
            socket.setSendBufferSize(204800);
            socket.setReceiveBufferSize(204800);
            con = new Connection(socket, sch, destination, true);
            if (!this.hwMode) {
                this.connectionByDestination.put(destination, con);
            }
            this.connectionByChannel.put(sch, con);
        }
        if (!this.hwMode) {
            object = this.registerNewLock;
            synchronized (object) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.wake = true;
                    this.selector.wakeup();
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wake = false;
                    sch.register(this.selector, 1);
                    this.lock.notify();
                }
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connection connection) {
        HashMap<String, Connection> hashMap = this.connectionByDestination;
        synchronized (hashMap) {
            if (!this.hwMode) {
                this.connectionByDestination.remove(connection.destination);
            }
            this.connectionByChannel.remove(connection.socketChannel);
            if (connection.writeSelector != null) {
                try {
                    connection.writeSelector.close();
                }
                catch (IOException ex) {
                    MessageTransport.logger.warning("Problem with closing write selector: " + ex.toString());
                }
                connection.writeSelector = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeConnectionDestination(Connection con, String newdest) {
        if (!this.hwMode) {
            HashMap<String, Connection> hashMap = this.connectionByDestination;
            synchronized (hashMap) {
                this.connectionByDestination.remove(con.destination);
                con.destination = newdest;
                this.connectionByDestination.put(newdest, con);
            }
        }
    }

    private void writeShort(int v, ByteBuffer outputBuffer) {
        outputBuffer.put((byte)(v >>> 8));
        outputBuffer.put((byte)v);
    }

    private void writeInt(int v, ByteBuffer outputBuffer) {
        outputBuffer.put((byte)(v >>> 24));
        outputBuffer.put((byte)(v >>> 16));
        outputBuffer.put((byte)(v >>> 8));
        outputBuffer.put((byte)v);
    }

    private int readShort(ByteBuffer inputBuffer) {
        int retVal = 0;
        retVal |= (inputBuffer.get() & 0xFF) << 8;
        return retVal |= inputBuffer.get() & 0xFF;
    }

    private int readInt(ByteBuffer inputBuffer) {
        int retVal = 0;
        retVal |= (inputBuffer.get() & 0xFF) << 24;
        retVal |= (inputBuffer.get() & 0xFF) << 16;
        retVal |= (inputBuffer.get() & 0xFF) << 8;
        return retVal |= inputBuffer.get() & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] transmitMessage(Message m, boolean needMessageCopy) throws IOException {
        byte[] binaryMsg = null;
        int msgSize = 0;
        try {
            Connection con = this.getConnection(m.getReceiver());
            byte[] receiver = m.getReceiver().toString().getBytes();
            int msgHeaderLength = 6 + receiver.length;
            boolean ok = false;
            int msgLength = 0;
            Object object = con.lockOutput;
            synchronized (object) {
                con.outputBuffer.clear();
                while (!ok) {
                    try {
                        con.outputBuffer.position(msgHeaderLength);
                        m.serialize(con.outputStream);
                        msgLength = con.outputBuffer.position() - msgHeaderLength;
                        if (needMessageCopy) {
                            binaryMsg = new byte[msgLength];
                            con.outputBuffer.position(msgHeaderLength);
                            con.outputBuffer.get(binaryMsg);
                        }
                        ok = true;
                    }
                    catch (BufferOverflowException ex) {
                        con.outputBuffer = ByteBuffer.allocateDirect(con.outputBuffer.capacity() * 2);
                        con.outputStream = new ByteBufferOutputStream(con.outputBuffer);
                    }
                    catch (IOException ex) {
                        MessageTransport.logger.severe("Message encoding error " + ex);
                        throw ex;
                    }
                }
                con.outputBuffer.position(0);
                this.writeInt(msgLength + 2 + receiver.length, con.outputBuffer);
                this.writeShort(receiver.length, con.outputBuffer);
                con.outputBuffer.put(receiver);
                msgSize = msgHeaderLength + msgLength;
                con.outputBuffer.position(msgSize);
                con.outputBuffer.flip();
                try {
                    con.socketChannel.write(con.outputBuffer);
                    while (con.outputBuffer.remaining() > 0) {
                        if (con.writeSelector != null) {
                            con.writeSelector.select();
                            con.writeSelector.selectedKeys().clear();
                        }
                        con.socketChannel.write(con.outputBuffer);
                    }
                }
                catch (IOException ex1) {
                    msgSize = 0;
                    if (this.hwMode) {
                        this.closeConnection(con);
                        this.removeConnection(con);
                    }
                    throw new IOException("Connection to the destination host was forcibly closed");
                }
            }
            if (this.hwMode) {
                this.closeConnection(con);
                this.removeConnection(con);
            }
        }
        catch (NullPointerException ex2) {
            throw new IOException("Closed by foreign host");
        }
        return new Object[]{binaryMsg, msgSize};
    }

    private class AcceptLayer
    implements Runnable {
        private AcceptLayer() throws Exception {
            try {
                TcpMessageTransportLayerImpl.this.ssc = ServerSocketChannel.open();
                TcpMessageTransportLayerImpl.this.ssc.configureBlocking(false);
                ServerSocket ss = TcpMessageTransportLayerImpl.this.ssc.socket();
                TcpMessageTransportLayerImpl.this.acceptSelector = Selector.open();
                ss.setReuseAddress(true);
                ss.bind(new InetSocketAddress(TcpMessageTransportLayerImpl.this.port), 1000);
                TcpMessageTransportLayerImpl.this.ssc.register(TcpMessageTransportLayerImpl.this.acceptSelector, 16);
                TcpMessageTransportLayerImpl.this.acceptThread = AglobeThreadPool.getThread(Platform.getPlatformThreadGroup(), this, "TCP Message transport: Accept Thread");
                TcpMessageTransportLayerImpl.this.acceptThread.setPriority(Math.min(8, 10));
                TcpMessageTransportLayerImpl.this.acceptThread.start();
            }
            catch (IOException ex) {
                throw new Exception("Accept thread exception: " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean i = true;
            while (!TcpMessageTransportLayerImpl.this.stop) {
                try {
                    if (TcpMessageTransportLayerImpl.this.acceptSelector.select() <= 0) continue;
                    Iterator<SelectionKey> it = TcpMessageTransportLayerImpl.this.acceptSelector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        SelectionKey sk = it.next();
                        int skOps = sk.readyOps();
                        if ((skOps & 0x10) != 16) continue;
                        SocketChannel remote = TcpMessageTransportLayerImpl.this.ssc.accept();
                        TcpMessageTransportLayerImpl.this.getConnection(remote);
                        it.remove();
                    }
                }
                catch (IOException ex1) {
                    MessageTransport.logger.severe("Accept thread exception: " + ex1);
                }
            }
            Object object = TcpMessageTransportLayerImpl.this.stopLock;
            synchronized (object) {
                TcpMessageTransportLayerImpl.this.finishedAccept = true;
                TcpMessageTransportLayerImpl.this.stopLock.notify();
            }
        }
    }

    private class Connection {
        private final Socket socket;
        private final SocketChannel socketChannel;
        private Selector writeSelector;
        private String destination;
        private ByteBuffer inputBuffer;
        private ByteBufferInputStream inputStream;
        private ByteBuffer outputBuffer;
        private ByteBufferOutputStream outputStream;
        private Object lockOutput = new Object();
        private boolean hasHeader;
        private int msgLength;
        private boolean receivedFirst;
        private final boolean isOutgoingInitialized;

        private Connection(Socket _socket, SocketChannel _socketChannel, String _destination, boolean isOutgoingInitialized) {
            this.socket = _socket;
            this.socketChannel = _socketChannel;
            this.isOutgoingInitialized = isOutgoingInitialized;
            if (!TcpMessageTransportLayerImpl.this.hwMode) {
                try {
                    this.writeSelector = Selector.open();
                    this.socketChannel.register(this.writeSelector, 4);
                }
                catch (IOException ex) {
                    this.writeSelector = null;
                }
            }
            this.destination = _destination;
            this.inputBuffer = ByteBuffer.allocateDirect(65536);
            this.inputStream = new ByteBufferInputStream(this.inputBuffer);
            this.outputBuffer = ByteBuffer.allocateDirect(65536);
            this.outputStream = new ByteBufferOutputStream(this.outputBuffer);
            this.hasHeader = false;
            this.receivedFirst = false;
        }

        private void testHeader() {
            if (this.hasHeader) {
                return;
            }
            if (this.inputBuffer.position() < 4) {
                return;
            }
            int p = this.inputBuffer.position();
            this.inputBuffer.position(0);
            this.msgLength = TcpMessageTransportLayerImpl.this.readInt(this.inputBuffer);
            this.inputBuffer.position(p);
            this.hasHeader = true;
            if (this.msgLength + 4 > this.inputBuffer.capacity()) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.msgLength + 4 + 1);
                this.inputBuffer.flip();
                newBuffer.put(this.inputBuffer);
                this.inputBuffer = newBuffer;
                this.inputStream = new ByteBufferInputStream(this.inputBuffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse() {
            this.testHeader();
            if (!this.hasHeader) {
                return;
            }
            if (this.inputBuffer.position() >= 4 + this.msgLength) {
                int oldEnd = this.inputBuffer.position();
                int oldLimit = this.inputBuffer.limit();
                this.inputBuffer.position(4);
                this.inputBuffer.limit(4 + this.msgLength);
                try {
                    aglobe.container.transport.MessageTransport destinationMt;
                    Message m = null;
                    byte[] binaryMsg = null;
                    int recLen = TcpMessageTransportLayerImpl.this.readShort(this.inputBuffer);
                    byte[] recBytes = new byte[recLen];
                    this.inputBuffer.get(recBytes);
                    Address receiverAddress = Address.getAddress(new String(recBytes));
                    HashMap<String, aglobe.container.transport.MessageTransport> hashMap = MessageTransport.containerMT;
                    synchronized (hashMap) {
                        destinationMt = MessageTransport.containerMT.get(receiverAddress.getContainerName());
                    }
                    if (destinationMt != null) {
                        MessageReceiver receiver = destinationMt.getMessageReceiver(receiverAddress);
                        if (receiver != null) {
                            boolean needIncomingMessageCopy = destinationMt.requestIncomingMessageCopy();
                            m = Message.deserialize(this.inputStream, (ClassLoaderOwner)((Object)receiver));
                            if (needIncomingMessageCopy && !m.getDoNotSniff()) {
                                int preheaderLen = 2 + recLen;
                                this.inputBuffer.position(4 + preheaderLen);
                                binaryMsg = new byte[this.msgLength - preheaderLen];
                                this.inputBuffer.get(binaryMsg);
                            }
                            receiver.incomingMessage(m);
                            if (!this.receivedFirst) {
                                TcpMessageTransportLayerImpl.this.changeConnectionDestination(this, String.valueOf(m.getSender().getHost()) + ":" + m.getSender().getPort());
                                this.receivedFirst = true;
                            }
                            if (binaryMsg != null || needIncomingMessageCopy && !m.getDoNotSniff()) {
                                destinationMt.sendIncomingMessageCopy(m, binaryMsg);
                            }
                        } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                            MessageTransport.logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found: " + receiverAddress);
                        }
                    } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                        MessageTransport.logger.warning("Target local container not found: " + receiverAddress);
                    }
                }
                catch (IOException ex) {
                    MessageTransport.logger.severe("Error unmarshalling from socket (remote side: " + this.socket.getInetAddress().getCanonicalHostName() + ")" + ex);
                }
                catch (ClassNotFoundException ex) {
                    MessageTransport.logger.severe("Error unmarshalling from socket (remote side: " + this.socket.getInetAddress().getCanonicalHostName() + ")" + ex);
                }
                this.inputBuffer.limit(oldLimit);
                this.inputBuffer.position(oldEnd);
                this.inputBuffer.flip();
                this.inputBuffer.position(4 + this.msgLength);
                this.inputBuffer.compact();
                this.hasHeader = false;
                this.msgLength = -1;
                this.parse();
            }
        }
    }
}

