/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.transport;

import aglobe.container.MessageReceiver;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.platform.transport.ByteBufferInputStream;
import aglobe.platform.transport.ByteBufferOutputStream;
import aglobe.platform.transport.MessageTransport;
import aglobe.platform.transport.UdpMessageTransportLayerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MulticastTransportLayerImpl
implements Runnable {
    private static final int MESSAGE_FRAGMENT_HEADER_LENGTH = 8;
    private static final long WAIT_FOR_MSG_MILLIS = 3000L;
    private static final long HOLD_IGNORE_INFO_FOR_MILLIS = 30000L;
    private final InetAddress outgoingInetAddress;
    private final int outgoingPort;
    private ByteBuffer outputBuffer;
    private ByteBufferOutputStream outputStream;
    private final Thread receivingThread;
    private final int mtu;
    private final int usefullMsgPartContentSize;
    private final int multicastSocketBufferSize;
    private boolean stop;
    private Object stopLock = new Object();
    private boolean finished;
    private final InetAddress multicastGroup;
    private final int multicastPort;
    private MulticastSocket socket;
    private DatagramChannel outgoingChannel;
    private int outgoingMessageID = 0;
    private HashMap<String, MsgToIgnore> msgToIgnore = new HashMap();
    private MsgToIgnore msgToIgnoreHead = null;
    private HashMap<String, IncompleteMsg> incompleteMsg = new HashMap();
    private IncompleteMsg incompleteMsgHead = null;

    MulticastTransportLayerImpl(InetAddress multicastGroup, int multicastPort, int mtu) throws IOException {
        this.mtu = mtu;
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
        this.usefullMsgPartContentSize = mtu - 20 - 8 - 8;
        this.multicastSocketBufferSize = mtu * 20;
        this.stop = false;
        this.finished = false;
        this.socket = new MulticastSocket(multicastPort);
        this.socket.setLoopbackMode(false);
        this.socket.setTimeToLive(255);
        this.socket.setTrafficClass(24);
        this.socket.setSendBufferSize(1024);
        this.socket.setReceiveBufferSize(524288);
        this.socket.joinGroup(multicastGroup);
        this.outgoingChannel = DatagramChannel.open();
        DatagramSocket os = this.outgoingChannel.socket();
        os.setBroadcast(false);
        os.setTrafficClass(24);
        os.setReuseAddress(false);
        os.setSendBufferSize(this.multicastSocketBufferSize);
        os.setReceiveBufferSize(1024);
        os.bind(null);
        this.outgoingChannel.connect(new InetSocketAddress(multicastGroup, multicastPort));
        this.outgoingInetAddress = InetAddress.getLocalHost();
        this.outgoingPort = os.getLocalPort();
        this.allocateOutputBuffer(65536);
        this.msgToIgnoreHead = new MsgToIgnore(null);
        this.msgToIgnoreHead.next = this.msgToIgnoreHead;
        this.msgToIgnoreHead.prev = this.msgToIgnoreHead;
        this.incompleteMsgHead = new IncompleteMsg(null, 0, 0, 0, 0);
        this.incompleteMsgHead.next = this.incompleteMsgHead;
        this.incompleteMsgHead.prev = this.incompleteMsgHead;
        this.receivingThread = AglobeThreadPool.getThread(Platform.getPlatformThreadGroup(), this, "Multicast Message transport: Receiving Thread");
        this.receivingThread.setPriority(Math.min(7, 10));
        this.receivingThread.start();
        MessageTransport.logger.info("Multicast messages will be operated on " + multicastGroup.getHostAddress() + ":" + multicastPort + " with MTU=" + mtu);
    }

    private void allocateOutputBuffer(int capacity) throws IOException {
        this.outputBuffer = ByteBuffer.allocateDirect(capacity);
        this.outputStream = new ByteBufferOutputStream(this.outputBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMessageTransport() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stop = true;
            try {
                this.socket.leaveGroup(this.multicastGroup);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket.close();
            try {
                this.outgoingChannel.close();
            }
            catch (IOException iOException) {}
            while (!this.finished) {
                try {
                    this.stopLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public Object[] transmitMessage(Message m, boolean needMessageCopy, Collection<Address> receivers, boolean asReferenceOnly) throws IOException {
        byte[] binaryMsg = null;
        int msgSize = 0;
        byte[][] pReceivers = new byte[receivers.size()][];
        int[] pReceiversLength = new int[receivers.size()];
        int allReceiversLength = 0;
        int i = 0;
        for (Address elem : receivers) {
            pReceivers[i] = elem.toString().getBytes();
            pReceiversLength[i] = pReceivers[i].length;
            allReceiversLength += 2 + pReceiversLength[i];
            ++i;
        }
        int msgHeaderLength = 6 + allReceiversLength + 5;
        int initMsgPosition = 8 + msgHeaderLength;
        int msgLength = 0;
        boolean ok = false;
        this.outputBuffer.clear();
        while (!ok) {
            try {
                this.outputBuffer.position(initMsgPosition);
                m.serialize(this.outputStream);
                msgLength = this.outputBuffer.position() - initMsgPosition;
                if (needMessageCopy) {
                    binaryMsg = new byte[msgLength];
                    this.outputBuffer.position(initMsgPosition);
                    this.outputBuffer.get(binaryMsg);
                }
                ok = true;
            }
            catch (BufferOverflowException ex) {
                this.allocateOutputBuffer(this.outputBuffer.capacity() * 2);
            }
            catch (IOException ex) {
                MessageTransport.logger.severe("Message encoding error " + ex);
                throw ex;
            }
        }
        this.outputBuffer.position(8);
        UdpMessageTransportLayerImpl.writeShort(pReceiversLength.length, this.outputBuffer);
        UdpMessageTransportLayerImpl.writeInt(allReceiversLength, this.outputBuffer);
        i = 0;
        while (i < pReceiversLength.length) {
            UdpMessageTransportLayerImpl.writeShort(pReceiversLength[i], this.outputBuffer);
            this.outputBuffer.put(pReceivers[i]);
            ++i;
        }
        this.outputBuffer.put(asReferenceOnly ? (byte)1 : 0);
        UdpMessageTransportLayerImpl.writeInt(msgLength, this.outputBuffer);
        int toTransmit = msgLength + msgHeaderLength;
        int numberOfFragments = (int)Math.ceil((double)toTransmit / (double)this.usefullMsgPartContentSize);
        msgSize = toTransmit + numberOfFragments * 8;
        i = 0;
        while (i < numberOfFragments) {
            int fragmentStart = i * this.usefullMsgPartContentSize;
            int dataToSent = i != numberOfFragments - 1 ? 8 + this.usefullMsgPartContentSize : 8 + (toTransmit - (numberOfFragments - 1) * this.usefullMsgPartContentSize);
            this.outputBuffer.position(fragmentStart);
            UdpMessageTransportLayerImpl.writeShort(this.outgoingMessageID, this.outputBuffer);
            UdpMessageTransportLayerImpl.writeShort(this.usefullMsgPartContentSize, this.outputBuffer);
            UdpMessageTransportLayerImpl.writeShort(i, this.outputBuffer);
            UdpMessageTransportLayerImpl.writeShort(numberOfFragments, this.outputBuffer);
            this.outputBuffer.position(fragmentStart);
            this.outputBuffer.limit(fragmentStart + dataToSent);
            this.outgoingChannel.write(this.outputBuffer);
            while (this.outputBuffer.remaining() > 0) {
                Thread.yield();
                this.outgoingChannel.write(this.outputBuffer);
            }
            ++i;
        }
        ++this.outgoingMessageID;
        return new Object[]{binaryMsg, msgSize};
    }

    private boolean testIfIgnore(String msgId) {
        MsgToIgnore mti = this.msgToIgnore.get(msgId);
        if (mti != null) {
            mti.timestamp = System.currentTimeMillis();
            mti.prev.next = mti.next;
            mti.next.prev = mti.prev;
            this.msgToIgnoreHead.prev.next = mti;
            mti.prev = this.msgToIgnoreHead.prev;
            mti.next = this.msgToIgnoreHead;
            this.msgToIgnoreHead.prev = mti;
            return true;
        }
        return false;
    }

    private void addToIgnore(String msgId) {
        MsgToIgnore mti = new MsgToIgnore(msgId);
        this.msgToIgnore.put(msgId, mti);
        mti.timestamp = System.currentTimeMillis();
        this.msgToIgnoreHead.prev.next = mti;
        mti.prev = this.msgToIgnoreHead.prev;
        mti.next = this.msgToIgnoreHead;
        this.msgToIgnoreHead.prev = mti;
    }

    private IncompleteMsg testIfKnown(String msgId) {
        IncompleteMsg im = this.incompleteMsg.get(msgId);
        if (im != null) {
            im.timestamp = System.currentTimeMillis();
            im.prev.next = im.next;
            im.next.prev = im.prev;
            this.incompleteMsgHead.prev.next = im;
            im.prev = this.incompleteMsgHead.prev;
            im.next = this.incompleteMsgHead;
            this.incompleteMsgHead.prev = im;
            return im;
        }
        return null;
    }

    private void addToIncomplete(IncompleteMsg im) {
        this.incompleteMsg.put(im.msgId, im);
        im.timestamp = System.currentTimeMillis();
        this.incompleteMsgHead.prev.next = im;
        im.prev = this.incompleteMsgHead.prev;
        im.next = this.incompleteMsgHead;
        this.incompleteMsgHead.prev = im;
    }

    private void removeFromIncomplete(IncompleteMsg im) {
        im.prev.next = im.next;
        im.next.prev = im.prev;
        this.incompleteMsg.remove(im.msgId);
    }

    private void clearQueues() {
        MsgToIgnore mti;
        IncompleteMsg im;
        long curTime = System.currentTimeMillis();
        long msgFrom = curTime - 3000L;
        while ((im = this.incompleteMsgHead.next) != this.incompleteMsgHead && im.timestamp < msgFrom) {
            this.removeFromIncomplete(im);
            this.addToIgnore(im.msgId);
        }
        long ignoreFrom = curTime - 30000L;
        while ((mti = this.msgToIgnoreHead.next) != this.msgToIgnoreHead && mti.timestamp < ignoreFrom) {
            mti.prev.next = mti.next;
            mti.next.prev = mti.prev;
            this.msgToIgnore.remove(mti.msgId);
        }
    }

    private void parseMsg(Collection<aglobe.container.transport.MessageTransport> destinationMts, Collection<MessageReceiver> receivers, ByteBuffer inputBuffer, InputStream inputStream) {
        try {
            boolean asReference = inputBuffer.get() != 0;
            int msgLength = UdpMessageTransportLayerImpl.readInt(inputBuffer);
            inputBuffer.limit(inputBuffer.position() + msgLength);
            Message m = null;
            byte[] binaryMsg = null;
            int startp = inputBuffer.position();
            Iterator<aglobe.container.transport.MessageTransport> iter = destinationMts.iterator();
            for (MessageReceiver elem : receivers) {
                aglobe.container.transport.MessageTransport destinationMt = iter.next();
                if (!asReference || m == null) {
                    inputBuffer.position(startp);
                    m = Message.deserialize(inputStream, (ClassLoaderOwner)((Object)elem));
                } else if (asReference) {
                    m.registerMessageHolder();
                }
                elem.incomingMessage(m);
                if (!destinationMt.requestIncomingMessageCopy() || m.getDoNotSniff()) continue;
                if (binaryMsg == null) {
                    if (inputBuffer.hasArray()) {
                        binaryMsg = new byte[msgLength];
                        System.arraycopy(inputBuffer.array(), startp, binaryMsg, 0, msgLength);
                    } else {
                        inputBuffer.position(startp);
                        binaryMsg = new byte[msgLength];
                        inputBuffer.get(binaryMsg);
                    }
                }
                destinationMt.sendIncomingMessageCopy(m, binaryMsg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageTransport.logger.severe("Error parsing received message: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ByteBuffer inputBuffer = ByteBuffer.allocate(65536);
        ByteBufferInputStream inputStream = new ByteBufferInputStream(inputBuffer);
        byte[] inputArray = inputBuffer.array();
        DatagramPacket incomingPacket = new DatagramPacket(inputBuffer.array(), inputBuffer.array().length);
        ArrayList<aglobe.container.transport.MessageTransport> destinationMts = null;
        while (!this.stop) {
            try {
                MessageReceiver receiver;
                aglobe.container.transport.MessageTransport destinationMt;
                HashMap<String, aglobe.container.transport.MessageTransport> hashMap;
                Address receiverAddress;
                int pos;
                int recipientLength;
                int i;
                int allRecipientsLength;
                int numberOfRecipients;
                ArrayList<MessageReceiver> localReceivers;
                int fragmentPosition;
                this.clearQueues();
                incomingPacket.setData(inputBuffer.array());
                this.socket.receive(incomingPacket);
                InetAddress incomingPacketAddress = incomingPacket.getAddress();
                int incomingPacketPort = incomingPacket.getPort();
                if (incomingPacketPort == this.outgoingPort && incomingPacketAddress.equals(this.outgoingInetAddress)) continue;
                inputBuffer.limit(incomingPacket.getLength());
                inputBuffer.position(0);
                int fragmentMsgId = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                String msgId = String.valueOf(incomingPacketAddress.getHostAddress()) + ":" + incomingPacketPort + ":" + fragmentMsgId;
                if (this.testIfIgnore(msgId)) continue;
                IncompleteMsg im = this.testIfKnown(msgId);
                if (im != null) {
                    inputBuffer.position(4);
                    fragmentPosition = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                    inputBuffer.position(8);
                    System.arraycopy(inputArray, 8, im.msgBufferArray, fragmentPosition * im.fragmentSize, inputBuffer.remaining());
                    IncompleteMsg incompleteMsg = im;
                    incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                    if (im.parsedFragments != im.totalFragments) continue;
                    localReceivers = im.localReceivers;
                    destinationMts = im.destinationMts;
                    if (localReceivers == null) {
                        numberOfRecipients = im.numberOfRecipients;
                        if (numberOfRecipients < 0) {
                            numberOfRecipients = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                            allRecipientsLength = UdpMessageTransportLayerImpl.readInt(inputBuffer);
                        } else {
                            allRecipientsLength = im.allRecipientsLength;
                            im.msgBuffer.position(6);
                        }
                        i = 0;
                        while (i < numberOfRecipients) {
                            recipientLength = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                            pos = inputBuffer.position();
                            receiverAddress = Address.getAddress(new String(inputArray, pos, recipientLength));
                            inputBuffer.position(pos + recipientLength);
                            if (receiverAddress.isLocalPlatform()) {
                                hashMap = MessageTransport.containerMT;
                                synchronized (hashMap) {
                                    destinationMt = MessageTransport.containerMT.get(receiverAddress.getContainerName());
                                }
                                if (destinationMt != null) {
                                    receiver = destinationMt.getMessageReceiver(receiverAddress);
                                    if (receiver != null) {
                                        if (localReceivers == null) {
                                            localReceivers = new ArrayList(numberOfRecipients);
                                            destinationMts = new ArrayList();
                                        }
                                        localReceivers.add(receiver);
                                        destinationMts.add(destinationMt);
                                    } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                        MessageTransport.logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found: " + receiverAddress);
                                    }
                                } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                    MessageTransport.logger.warning("Target local container not found: " + receiverAddress);
                                }
                            }
                            ++i;
                        }
                    } else {
                        im.msgBuffer.position(6 + im.allRecipientsLength);
                    }
                    if (localReceivers != null) {
                        ByteBufferInputStream adhocInputStream = new ByteBufferInputStream(im.msgBuffer);
                        this.parseMsg((Collection<aglobe.container.transport.MessageTransport>)destinationMts, (Collection<MessageReceiver>)localReceivers, im.msgBuffer, adhocInputStream);
                    }
                    this.removeFromIncomplete(im);
                    continue;
                }
                int fragmentSize = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                fragmentPosition = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                int totalFragments = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                if (fragmentPosition == 0) {
                    numberOfRecipients = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                    allRecipientsLength = UdpMessageTransportLayerImpl.readInt(inputBuffer);
                    if (allRecipientsLength + 6 <= fragmentSize) {
                        localReceivers = null;
                        i = 0;
                        while (i < numberOfRecipients) {
                            recipientLength = UdpMessageTransportLayerImpl.readShort(inputBuffer);
                            pos = inputBuffer.position();
                            receiverAddress = Address.getAddress(new String(inputArray, pos, recipientLength));
                            inputBuffer.position(pos + recipientLength);
                            if (receiverAddress.isLocalPlatform()) {
                                hashMap = MessageTransport.containerMT;
                                synchronized (hashMap) {
                                    destinationMt = MessageTransport.containerMT.get(receiverAddress.getContainerName());
                                }
                                if (destinationMt != null) {
                                    receiver = destinationMt.getMessageReceiver(receiverAddress);
                                    if (receiver != null) {
                                        if (localReceivers == null) {
                                            localReceivers = new ArrayList<MessageReceiver>(numberOfRecipients);
                                            destinationMts = new ArrayList<aglobe.container.transport.MessageTransport>();
                                        }
                                        localReceivers.add(receiver);
                                        destinationMts.add(destinationMt);
                                    } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                        MessageTransport.logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found: " + receiverAddress);
                                    }
                                } else if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                    MessageTransport.logger.warning("Target local container not found: " + receiverAddress);
                                }
                            }
                            ++i;
                        }
                        if (localReceivers != null) {
                            if (totalFragments == 1) {
                                this.parseMsg((Collection<aglobe.container.transport.MessageTransport>)destinationMts, (Collection<MessageReceiver>)localReceivers, inputBuffer, inputStream);
                                continue;
                            }
                            inputBuffer.position(8);
                            im = new IncompleteMsg(msgId, fragmentSize, totalFragments, numberOfRecipients, allRecipientsLength);
                            im.localReceivers = localReceivers;
                            im.destinationMts = destinationMts;
                            System.arraycopy(inputArray, 8, im.msgBufferArray, fragmentPosition * fragmentSize, inputBuffer.remaining());
                            IncompleteMsg incompleteMsg = im;
                            incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                            this.addToIncomplete(im);
                            continue;
                        }
                        this.addToIgnore(msgId);
                        continue;
                    }
                    inputBuffer.position(8);
                    im = new IncompleteMsg(msgId, fragmentSize, totalFragments, numberOfRecipients, allRecipientsLength);
                    System.arraycopy(inputArray, 8, im.msgBufferArray, fragmentPosition * fragmentSize, inputBuffer.remaining());
                    IncompleteMsg incompleteMsg = im;
                    incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                    this.addToIncomplete(im);
                    continue;
                }
                im = new IncompleteMsg(msgId, fragmentSize, totalFragments, -1, -1);
                System.arraycopy(inputArray, 8, im.msgBufferArray, fragmentPosition * fragmentSize, inputBuffer.remaining());
                IncompleteMsg incompleteMsg = im;
                incompleteMsg.parsedFragments = incompleteMsg.parsedFragments + 1;
                this.addToIncomplete(im);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this.stopLock;
        synchronized (object) {
            this.finished = true;
            this.stopLock.notify();
        }
    }

    private static class MsgToIgnore {
        private final String msgId;
        private long timestamp;
        private MsgToIgnore prev;
        private MsgToIgnore next;

        private MsgToIgnore(String msgId) {
            this.msgId = msgId;
        }
    }

    private static class IncompleteMsg {
        private final String msgId;
        private long timestamp;
        private IncompleteMsg prev;
        private IncompleteMsg next;
        private final int fragmentSize;
        private final int totalFragments;
        private int parsedFragments;
        private final int allRecipientsLength;
        private final int numberOfRecipients;
        private ArrayList<MessageReceiver> localReceivers;
        private ArrayList<aglobe.container.transport.MessageTransport> destinationMts;
        private final ByteBuffer msgBuffer;
        private final byte[] msgBufferArray;

        private IncompleteMsg(String msgId, int fragmentSize, int totalFragments, int numberOfRecipients, int allRecipientsLength) {
            this.msgId = msgId;
            this.parsedFragments = 0;
            this.fragmentSize = fragmentSize;
            this.totalFragments = totalFragments;
            int bufSize = fragmentSize * totalFragments + 1;
            this.msgBuffer = ByteBuffer.allocate(bufSize);
            this.msgBuffer.flip();
            this.msgBuffer.limit(bufSize);
            this.msgBufferArray = this.msgBuffer.array();
            this.numberOfRecipients = numberOfRecipients;
            this.allRecipientsLength = allRecipientsLength;
            this.localReceivers = null;
            this.destinationMts = null;
        }
    }
}

