/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.transport;

import aglobe.container.MessageReceiver;
import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.library.LibraryObjectInputStream;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.platform.Platform;
import aglobe.platform.transport.CloneBuffer;
import aglobe.platform.transport.MessageTransportLayerImpl;
import aglobe.platform.transport.MulticastTransportLayerImpl;
import aglobe.platform.transport.TcpMessageTransportLayerImpl;
import aglobe.platform.transport.UdpMessageTransportLayerImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTransport {
    private static final String LOGGER = "platform.MessageTransport";
    public static final int INITAL_MESSAGE_BUFFER_SIZE = 65536;
    public static final int DEFAULT_MTU = 1500;
    private static Platform platform;
    static Logger logger;
    private static MessageTransportLayerImpl standardMessageTransportLayerImpl;
    private static MulticastTransportLayerImpl multicastMessageTransportLayerImpl;
    public static InetSocketAddress localAddress;
    public static String localHostAddress;
    public static int localPort;
    private static boolean initialized;
    static final HashMap<String, aglobe.container.transport.MessageTransport> containerMT;
    private static CloneBuffer cloneBuffer;
    private static ObjectOutputStream outCloningBuffer;
    private static LibraryObjectInputStream inCloningBuffer;
    private static LinkedHashSet<Address> localMulticastReceivers;
    private static LinkedHashSet<Address> remoteMulticastReceivers;
    private static CloneBuffer multicastCloneBuffer;
    private static ObjectOutputStream multicastOutCloningBuffer;
    private static LibraryObjectInputStream multicastInCloningBuffer;

    static {
        logger = Logger.getLogger(LOGGER);
        standardMessageTransportLayerImpl = null;
        multicastMessageTransportLayerImpl = null;
        initialized = false;
        containerMT = new HashMap();
        localMulticastReceivers = new LinkedHashSet();
        remoteMulticastReceivers = new LinkedHashSet();
    }

    private MessageTransport() {
    }

    public static void initialize(int port, Platform platform, boolean useTcp, boolean hwMode, int mtu, InetAddress multicastGroup, int multicastPort) throws IOException, Exception {
        MessageTransport.platform = platform;
        int useMtu = 1500;
        if (mtu != 0) {
            useMtu = mtu;
        }
        logger.fine("Starting platform MessageTransport START");
        standardMessageTransportLayerImpl = useTcp ? new TcpMessageTransportLayerImpl(port, hwMode) : new UdpMessageTransportLayerImpl(port, useMtu);
        multicastMessageTransportLayerImpl = new MulticastTransportLayerImpl(multicastGroup, multicastPort, useMtu);
        localAddress = standardMessageTransportLayerImpl.getLocalAddress();
        localHostAddress = localAddress.getAddress().getHostAddress();
        localPort = localAddress.getPort();
        logger.fine("Starting platform MessageTransport END");
        cloneBuffer = new CloneBuffer();
        outCloningBuffer = cloneBuffer.getOutputStream();
        inCloningBuffer = cloneBuffer.getInputStream();
        multicastCloneBuffer = new CloneBuffer();
        multicastOutCloningBuffer = multicastCloneBuffer.getOutputStream();
        multicastInCloningBuffer = multicastCloneBuffer.getInputStream();
        initialized = true;
    }

    public static void shutdown() {
        if (initialized) {
            if (standardMessageTransportLayerImpl != null) {
                standardMessageTransportLayerImpl.stopMessageTransport();
                standardMessageTransportLayerImpl = null;
            }
            if (multicastMessageTransportLayerImpl != null) {
                multicastMessageTransportLayerImpl.stopMessageTransport();
                multicastMessageTransportLayerImpl = null;
            }
            cloneBuffer = null;
            outCloningBuffer = null;
            inCloningBuffer = null;
            initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMessageTransport(String containerName, aglobe.container.transport.MessageTransport mt) throws Exception {
        HashMap<String, aglobe.container.transport.MessageTransport> hashMap = containerMT;
        synchronized (hashMap) {
            if (containerMT.containsKey(containerName)) {
                throw new Exception("Container name '" + containerName + "' already registred in the platform message transport.");
            }
            containerMT.put(containerName, mt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterMessageTransport(aglobe.container.transport.MessageTransport mt) {
        HashMap<String, aglobe.container.transport.MessageTransport> hashMap = containerMT;
        synchronized (hashMap) {
            containerMT.values().remove(mt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sendStandardMessage(Message m, aglobe.container.transport.MessageTransport senderMt, boolean onlyReference) throws InvisibleContainerException {
        boolean requestOutgoingMessageCopy = !m.getDoNotSniff() && senderMt.requestOutgoingMessageCopy();
        Address r = m.getReceiver();
        if (r.isLocalPlatform()) {
            aglobe.container.transport.MessageTransport destinationMt;
            HashMap<String, aglobe.container.transport.MessageTransport> hashMap = containerMT;
            synchronized (hashMap) {
                destinationMt = containerMT.get(r.getContainerName());
            }
            if (destinationMt == null) {
                senderMt.insertStandardCommunicationInfo(m, false, true, null, 0);
                if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                    logger.warning(String.valueOf(senderMt.getContainerAddress().getContainerName()) + ": Target container not reachable due to unknown local container. Original message:\n" + m);
                }
                throw new InvisibleContainerException("Target container not reachable due to unknown local container: " + r);
            }
            MessageReceiver receiver = destinationMt.getMessageReceiver(r);
            if (receiver == null) {
                senderMt.insertStandardCommunicationInfo(m, false, false, null, 0);
                if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                    logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found. Original message:\n" + m);
                }
                return 0;
            }
            boolean requestIncomingMessageCopy = !m.getDoNotSniff() && destinationMt.requestIncomingMessageCopy();
            try {
                int msgLength;
                Message newm = null;
                byte[] binaryMsg = null;
                if (onlyReference) {
                    newm = m;
                    msgLength = 4;
                    m.registerMessageHolder();
                } else {
                    CloneBuffer cloneBuffer = MessageTransport.cloneBuffer;
                    synchronized (cloneBuffer) {
                        MessageTransport.cloneBuffer.clear();
                        m.writeExternal(outCloningBuffer);
                        outCloningBuffer.flush();
                        if (requestOutgoingMessageCopy || requestIncomingMessageCopy) {
                            binaryMsg = new byte[MessageTransport.cloneBuffer.getDataSize()];
                            System.arraycopy(MessageTransport.cloneBuffer.array(), 0, binaryMsg, 0, binaryMsg.length);
                        }
                        inCloningBuffer.setClassLoader((ClassLoaderOwner)((Object)receiver));
                        msgLength = MessageTransport.cloneBuffer.getDataSize();
                        newm = Message.newInstance();
                        newm.readExternal(inCloningBuffer);
                    }
                }
                senderMt.insertStandardCommunicationInfo(m, false, false, binaryMsg, msgLength);
                receiver.incomingMessage(newm);
                if (requestIncomingMessageCopy) {
                    destinationMt.sendIncomingMessageCopy(m, binaryMsg);
                }
                return msgLength;
            }
            catch (Exception ex1) {
                logger.severe("Problem with cloning message: " + ex1 + "\nMessage: " + m);
                return 0;
            }
        }
        try {
            Object[] retVal = standardMessageTransportLayerImpl.transmitMessage(m, requestOutgoingMessageCopy);
            byte[] binaryMsg = (byte[])retVal[0];
            int msgSize = (Integer)retVal[1];
            senderMt.insertStandardCommunicationInfo(m, false, false, binaryMsg, msgSize);
            return msgSize;
        }
        catch (IOException ex) {
            senderMt.insertStandardCommunicationInfo(m, false, true, null, 0);
            if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                logger.warning(String.valueOf(senderMt.getContainerAddress().getContainerName()) + ": Target container not reachable due to I/O connection failure. Original message:\n" + m);
            }
            throw new InvisibleContainerException("Target container not reachable due to I/O connection failure: " + r, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sendMulticastMessage(Message m, aglobe.container.transport.MessageTransport senderMt, Collection<Address> visibleContainers, boolean onlyReference) {
        boolean requestOutgoingMessageCopy = !m.getDoNotSniff() && senderMt.requestOutgoingMessageCopy();
        Collection<Address> receivers = m.getReceivers();
        Message newm = null;
        byte[] binaryMsg = null;
        int msgLength = 0;
        boolean cloneBufferHolds = false;
        LinkedHashSet<Address> linkedHashSet = remoteMulticastReceivers;
        synchronized (linkedHashSet) {
            block37: {
                localMulticastReceivers.clear();
                remoteMulticastReceivers.clear();
                for (Address elem : receivers) {
                    Collection<Address> collection;
                    if (elem.isLocalPlatform()) {
                        aglobe.container.transport.MessageTransport destinationMt;
                        if (localMulticastReceivers.contains(elem)) continue;
                        if (visibleContainers != null) {
                            collection = visibleContainers;
                            synchronized (collection) {
                                if (!visibleContainers.contains(elem.deriveContainerAddress())) {
                                    if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                        logger.warning(String.valueOf(senderMt.getContainerAddress().getContainerName()) + ": Target container not reachable due to visibility restrictions: " + m.getReceiver());
                                    }
                                    continue;
                                }
                            }
                        }
                        collection = containerMT;
                        synchronized (collection) {
                            destinationMt = containerMT.get(elem.getContainerName());
                        }
                        if (destinationMt == null) {
                            if (!Platform.SHOW_UNDELIVERED_MESSAGES) continue;
                            logger.warning(String.valueOf(senderMt.getContainerAddress().getContainerName()) + ": Target container not reachable due to unknown local container. Original message:\n" + m);
                            continue;
                        }
                        MessageReceiver messageReceiver = destinationMt.getMessageReceiver(elem);
                        if (messageReceiver == null) {
                            if (!Platform.SHOW_UNDELIVERED_MESSAGES) continue;
                            logger.warning(String.valueOf(destinationMt.getContainerAddress().getContainerName()) + ": Receiver not found. Original message:\n" + m);
                            continue;
                        }
                        boolean requestIncomingMessageCopy = !m.getDoNotSniff() && destinationMt.requestIncomingMessageCopy();
                        try {
                            if (onlyReference) {
                                newm = m;
                                msgLength = 4;
                                m.registerMessageHolder();
                                messageReceiver.incomingMessage(newm);
                                if (requestIncomingMessageCopy) {
                                    if (binaryMsg == null) {
                                        multicastCloneBuffer.clear();
                                        m.writeExternal(multicastOutCloningBuffer);
                                        multicastOutCloningBuffer.flush();
                                        binaryMsg = new byte[multicastCloneBuffer.getDataSize()];
                                        System.arraycopy(multicastCloneBuffer.array(), 0, binaryMsg, 0, binaryMsg.length);
                                    }
                                    destinationMt.sendIncomingMessageCopy(m, binaryMsg);
                                }
                            } else {
                                if (!cloneBufferHolds) {
                                    multicastCloneBuffer.clear();
                                    m.writeExternal(multicastOutCloningBuffer);
                                    multicastOutCloningBuffer.flush();
                                    cloneBufferHolds = true;
                                    msgLength = multicastCloneBuffer.getDataSize();
                                } else {
                                    multicastCloneBuffer.rewind();
                                }
                                if ((requestOutgoingMessageCopy || requestIncomingMessageCopy) && binaryMsg == null) {
                                    binaryMsg = new byte[multicastCloneBuffer.getDataSize()];
                                    System.arraycopy(multicastCloneBuffer.array(), 0, binaryMsg, 0, binaryMsg.length);
                                }
                                inCloningBuffer.setClassLoader((ClassLoaderOwner)((Object)messageReceiver));
                                newm = Message.newInstance();
                                newm.readExternal(multicastInCloningBuffer);
                                messageReceiver.incomingMessage(newm);
                                if (requestIncomingMessageCopy) {
                                    destinationMt.sendIncomingMessageCopy(m, binaryMsg);
                                }
                            }
                            localMulticastReceivers.add(elem);
                        }
                        catch (Exception ex) {
                            logger.severe("Problem with cloning message: " + ex + "\nMessage: " + m);
                        }
                        continue;
                    }
                    if (remoteMulticastReceivers.contains(elem)) continue;
                    if (visibleContainers != null) {
                        collection = visibleContainers;
                        synchronized (collection) {
                            if (!visibleContainers.contains(elem.deriveContainerAddress())) {
                                if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                                    logger.warning(String.valueOf(senderMt.getContainerAddress().getContainerName()) + ": Target container not reachable due to visibility restrictions: " + m.getReceiver());
                                }
                                continue;
                            }
                        }
                    }
                    remoteMulticastReceivers.add(elem);
                }
                if (remoteMulticastReceivers.size() > 0) {
                    try {
                        Object[] retVal = multicastMessageTransportLayerImpl.transmitMessage(m, requestOutgoingMessageCopy && binaryMsg == null, remoteMulticastReceivers, onlyReference);
                        int newLength = (Integer)retVal[1];
                        if (newLength > 0) {
                            msgLength = newLength;
                        }
                        if (requestOutgoingMessageCopy && binaryMsg == null && retVal[0] != null) {
                            binaryMsg = (byte[])retVal[0];
                        }
                    }
                    catch (IOException ex1) {
                        if (!Platform.SHOW_UNDELIVERED_MESSAGES) break block37;
                        logger.warning(String.valueOf(senderMt.getContainerAddress().getContainerName()) + ": Target containers not reachable due to I/O failure. Original message:\n" + m);
                    }
                }
            }
            senderMt.insertMulticastCommunicationInfo(m, binaryMsg, msgLength, localMulticastReceivers, remoteMulticastReceivers);
        }
        return msgLength;
    }
}

