/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.transport;

import aglobe.container.library.LibraryObjectInputStream;
import aglobe.platform.transport.MessageTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class CloneBuffer {
    private static final int INIT_SIZE = 10240;
    private byte[] buf = new byte[10240];
    private int bufSize = 10240;
    private int remaining;
    private int in;
    private int out;
    private ObjectOutputStream outputStream;
    private LibraryObjectInputStream inputStream;

    public CloneBuffer() throws IOException {
        this.init();
        this.outputStream = new ObjectOutputStream(new MyOutputStream());
        this.inputStream = new LibraryObjectInputStream((InputStream)new MyInputStream(), ClassLoader.getSystemClassLoader());
    }

    private void init() {
        this.remaining = this.bufSize;
        this.in = 0;
        this.out = 0;
    }

    public byte[] array() {
        return this.buf;
    }

    public int getDataSize() {
        return this.in;
    }

    public void copyBufferWithStreamHeader(OutputStream dst) throws IOException {
        dst.write(this.buf, 0, this.in);
    }

    public void rewind() {
        this.out = 4;
    }

    public void clear() {
        this.remaining = this.bufSize - 4;
        this.in = 4;
        this.out = 4;
        try {
            this.outputStream.reset();
        }
        catch (IOException ex) {
            MessageTransport.logger.severe("Cannot reset output stream !!!");
        }
    }

    public void reset() {
        this.remaining = this.bufSize - 4;
        this.in = 4;
        this.out = 4;
    }

    private void makeBufferLarger() {
        byte[] newBuf = new byte[this.bufSize * 2];
        System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
        this.buf = newBuf;
        this.remaining += this.bufSize;
        this.bufSize *= 2;
    }

    public ObjectOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public LibraryObjectInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    private class MyInputStream
    extends InputStream {
        public int available() {
            return CloneBuffer.this.in - CloneBuffer.this.out;
        }

        public long skip(long n) throws IOException {
            throw new IOException("Not supported");
        }

        public int read() {
            if (CloneBuffer.this.out == CloneBuffer.this.in) {
                return -1;
            }
            byte[] byArray = CloneBuffer.this.buf;
            CloneBuffer cloneBuffer = CloneBuffer.this;
            int n = cloneBuffer.out;
            cloneBuffer.out = n + 1;
            return byArray[n];
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (CloneBuffer.this.out == CloneBuffer.this.in) {
                return -1;
            }
            int read = Math.min(CloneBuffer.this.in - CloneBuffer.this.out, len);
            System.arraycopy(CloneBuffer.this.buf, CloneBuffer.this.out, b, off, read);
            CloneBuffer cloneBuffer = CloneBuffer.this;
            cloneBuffer.out = cloneBuffer.out + read;
            return read;
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readlimit) {
        }

        public void reset() throws IOException {
            throw new IOException("Not supported");
        }

        public void close() {
        }
    }

    private class MyOutputStream
    extends OutputStream {
        public void write(int b) {
            if (CloneBuffer.this.remaining == 0) {
                CloneBuffer.this.makeBufferLarger();
            }
            byte[] byArray = CloneBuffer.this.buf;
            CloneBuffer cloneBuffer = CloneBuffer.this;
            int n = cloneBuffer.in;
            cloneBuffer.in = n + 1;
            byArray[n] = (byte)b;
            CloneBuffer cloneBuffer2 = CloneBuffer.this;
            cloneBuffer2.remaining = cloneBuffer2.remaining - 1;
        }

        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) {
            if (CloneBuffer.this.remaining < len) {
                CloneBuffer.this.makeBufferLarger();
            }
            System.arraycopy(b, off, CloneBuffer.this.buf, CloneBuffer.this.in, len);
            CloneBuffer cloneBuffer = CloneBuffer.this;
            cloneBuffer.in = cloneBuffer.in + len;
            CloneBuffer cloneBuffer2 = CloneBuffer.this;
            cloneBuffer2.remaining = cloneBuffer2.remaining - len;
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

