/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.transport;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer nioBuffer;

    ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.nioBuffer = byteBuffer;
    }

    public int read() throws IOException {
        return this.nioBuffer.get() & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        try {
            this.nioBuffer.get(b);
            return b.length;
        }
        catch (Exception ex) {
            throw new IOException("Not enough data available");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        block3: {
            try {
                toRead = Math.min(len, this.nioBuffer.remaining());
                if (toRead != 0) break block3;
                return -1;
            }
            catch (Exception ex) {
                throw new IOException("Not enough data available");
            }
        }
        this.nioBuffer.get(b, off, toRead);
        return toRead;
    }

    public long skip(long n) throws IOException {
        int skip = Math.min((int)n, this.nioBuffer.remaining());
        this.nioBuffer.position(this.nioBuffer.position() + skip);
        return skip;
    }

    public int available() throws IOException {
        return this.nioBuffer.remaining();
    }
}

