/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform.thread;

import aglobe.platform.Platform;
import aglobe.platform.thread.AglobeThread;
import java.util.Arrays;
import java.util.LinkedList;

public class AglobeThreadPool {
    private static final int USE_SHARED_THREADS = 20;
    private static final int MAX_READY_THREADS = 50;
    private static int numberOfSharedThreads = 0;
    static boolean initialized = false;
    static ThreadGroup threadPoolGroup = new ThreadGroup("A-globe thread pool");
    static LinkedList<AglobeThread> threadPool = new LinkedList();
    private static Preallocation prealocation;
    private static LinkedList<ToRunInThread> waitingQueue;

    static {
        waitingQueue = new LinkedList();
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        prealocation = new Preallocation();
        Thread prealocationThread = new Thread(threadPoolGroup, prealocation, "Preallocation thread", Platform.THREAD_STACK_SIZE);
        prealocationThread.setPriority(1);
        prealocationThread.setDaemon(true);
        prealocationThread.start();
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finish() {
        LinkedList<AglobeThread> linkedList = threadPool;
        synchronized (linkedList) {
            if (!initialized) {
                return;
            }
            initialized = false;
            for (AglobeThread item : threadPool) {
                item.threadFinish();
            }
        }
    }

    public static void startInNewThread(Runnable target, String name) {
        AglobeThreadPool.startInNewThread(null, target, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startInNewThread(ThreadGroup group, Runnable target, String name) {
        if (group == null) {
            group = Thread.currentThread().getThreadGroup();
        }
        LinkedList<AglobeThread> linkedList = threadPool;
        synchronized (linkedList) {
            try {
                Thread t = AglobeThreadPool.getThread(group, target, name, true);
                if (t != null) {
                    t.start();
                } else {
                    waitingQueue.add(new ToRunInThread(group, target, name));
                }
            }
            catch (Throwable ex) {
                waitingQueue.add(new ToRunInThread(group, target, name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Thread getThread(ThreadGroup group, Runnable target, String name, boolean sharedOnly) {
        if (target == null) {
            throw new RuntimeException("Target for new thread is null.");
        }
        AglobeThread newThread = null;
        LinkedList<AglobeThread> linkedList = threadPool;
        synchronized (linkedList) {
            try {
                newThread = threadPool.removeFirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sharedOnly && newThread == null && numberOfSharedThreads >= 20) {
                return null;
            }
        }
        if (newThread == null) {
            newThread = new AglobeThread(group, target, name);
            newThread.setPriority(5);
            newThread.threadStart();
            if (!sharedOnly) {
                newThread.isSharedThread = false;
                return newThread;
            }
            linkedList = threadPool;
            synchronized (linkedList) {
                ++numberOfSharedThreads;
                return newThread;
            }
        }
        newThread.setName(name);
        newThread.setNewTarget(target);
        newThread.setNewThreadGroup(group);
        if (sharedOnly) return newThread;
        newThread.isSharedThread = false;
        linkedList = threadPool;
        synchronized (linkedList) {
            --numberOfSharedThreads;
            return newThread;
        }
    }

    public static Thread getThread(ThreadGroup group, Runnable target, String name) {
        return AglobeThreadPool.getThread(group, target, name, false);
    }

    public static Thread getThread(Runnable target, String name) {
        return AglobeThreadPool.getThread(null, target, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustThreadMode(boolean isShared) {
        Thread t = Thread.currentThread();
        if (t instanceof AglobeThread) {
            AglobeThread at = (AglobeThread)t;
            if (isShared != at.isSharedThread) {
                at.isSharedThread = isShared;
                if (isShared) {
                    LinkedList<AglobeThread> linkedList = threadPool;
                    synchronized (linkedList) {
                        ++numberOfSharedThreads;
                    }
                }
                LinkedList<AglobeThread> linkedList = threadPool;
                synchronized (linkedList) {
                    --numberOfSharedThreads;
                }
            }
        }
    }

    public static Thread[] enumerateThreads(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return new Thread[0];
        }
        if (threadGroup == null) {
            return new Thread[0];
        }
        Object[] threadSubGroups = null;
        int threadSubGroupsCount = threadGroup.activeGroupCount();
        if (threadSubGroupsCount != 0) {
            threadSubGroups = new ThreadGroup[threadSubGroupsCount];
            threadGroup.enumerate((ThreadGroup[])threadSubGroups, true);
        }
        Thread[] threadList = new Thread[threadGroup.activeCount() + threadPoolGroup.activeCount()];
        int offset = threadGroup.enumerate(threadList, true);
        Thread[] threadPoolList = new Thread[threadPoolGroup.activeCount()];
        threadPoolGroup.enumerate(threadPoolList, false);
        int i = 0;
        int iList = offset;
        while (i < threadPoolList.length) {
            if (threadPoolList[i] instanceof AglobeThread) {
                boolean isSubThread = false;
                ThreadGroup tg = ((AglobeThread)threadPoolList[i]).getAglobeThreadGroup();
                if (threadSubGroups == null) {
                    isSubThread = tg == threadGroup;
                } else {
                    boolean bl = isSubThread = Arrays.binarySearch(threadSubGroups, tg) >= 0;
                }
                if (isSubThread) {
                    threadList[iList] = threadPoolList[i];
                    ++iList;
                }
            }
            ++i;
        }
        return threadList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putThreadToTheQueue(AglobeThread thread) {
        LinkedList<AglobeThread> linkedList = threadPool;
        synchronized (linkedList) {
            if (!thread.isSharedThread) {
                thread.isSharedThread = true;
                ++numberOfSharedThreads;
            }
            if (waitingQueue.size() != 0) {
                ToRunInThread to = waitingQueue.removeFirst();
                thread.setName(to.threadName);
                thread.setNewTarget(to.target);
                thread.setNewThreadGroup(to.group);
                thread.start();
                return;
            }
            threadPool.addFirst(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean stillActive() {
        LinkedList<AglobeThread> linkedList = threadPool;
        synchronized (linkedList) {
            return initialized;
        }
    }

    private static class Preallocation
    implements Runnable {
        private Preallocation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                int numReady;
                AglobeThread at = null;
                Object object = threadPool;
                synchronized (object) {
                    numReady = numberOfSharedThreads;
                }
                if (numReady < 20) {
                    Object object2;
                    try {
                        AglobeThread newThread = new AglobeThread();
                        newThread.setPriority(5);
                        newThread.threadStart();
                        object2 = threadPool;
                        synchronized (object2) {
                            numberOfSharedThreads = numberOfSharedThreads + 1;
                            if (waitingQueue.size() == 0) {
                                threadPool.addFirst(newThread);
                            } else {
                                ToRunInThread to = (ToRunInThread)waitingQueue.removeFirst();
                                newThread.setName(to.threadName);
                                newThread.setNewTarget(to.target);
                                newThread.setNewThreadGroup(to.group);
                                newThread.start();
                            }
                            continue;
                        }
                    }
                    catch (Throwable ex1) {
                        object2 = this;
                        synchronized (object2) {
                            try {
                                this.wait(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                }
                if (numReady > 50) {
                    object = threadPool;
                    synchronized (object) {
                        if (threadPool.size() > 0) {
                            at = threadPool.removeLast();
                            numberOfSharedThreads = numberOfSharedThreads - 1;
                        }
                    }
                    if (at != null) {
                        at.threadFinish();
                        at = null;
                        continue;
                    }
                    object = this;
                    synchronized (object) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class ToRunInThread {
        private final ThreadGroup group;
        private final Runnable target;
        private final String threadName;

        private ToRunInThread(ThreadGroup group, Runnable target, String threadName) {
            this.group = group;
            this.target = target;
            this.threadName = threadName;
        }
    }
}

