/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform;

import aglobe.ontology.AgentInfo;
import aglobe.ontology.AgentList;
import aglobe.ontology.Libraries;
import aglobe.platform.Platform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StartingServer
implements Runnable {
    private final Platform owner;
    private DatagramSocket socket = null;
    private boolean killing = false;

    public StartingServer(Platform owner, int platformNumber) throws SocketException {
        this.owner = owner;
        this.socket = new DatagramSocket(6000 + platformNumber);
        this.socket.setSoTimeout(5000);
    }

    public void run() {
        while (!this.killing) {
            byte[] buf = new byte[10240];
            DatagramPacket dp = new DatagramPacket(buf, buf.length);
            try {
                this.socket.receive(dp);
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dp.getData(), 0, dp.getLength()));
                try {
                    byte[] replyBuf;
                    LinkedList ll = (LinkedList)in.readObject();
                    String[] args = new String[ll.size()];
                    int i = 0;
                    while (i < ll.size()) {
                        String item;
                        args[i] = item = (String)ll.get(i);
                        ++i;
                    }
                    try {
                        AgentList al = new AgentList();
                        int j = args.length - 1;
                        while (j >= 0) {
                            String par = args[j];
                            int k = par.indexOf(":");
                            if (k <= 0) break;
                            String aname = par.substring(0, k);
                            String mainclass = par.substring(k + 1);
                            AgentInfo ai = new AgentInfo();
                            ai.setName(aname);
                            ai.setReadableName(aname);
                            ai.setMainClass(mainclass);
                            Libraries lib = new Libraries();
                            ai.setLibraries(lib);
                            al.getAgentInfo().add(ai);
                            --j;
                        }
                        if (al.getAgentInfo().size() == 0) {
                            al = null;
                        }
                        Platform.startNewContainer(args, al, null, null);
                        replyBuf = "Started".toString().getBytes();
                    }
                    catch (Exception ex1) {
                        this.owner.logger.severe("Problem during starting new A-globe container:\n" + ex1.toString());
                        replyBuf = ex1.toString().getBytes();
                    }
                    DatagramPacket reply = new DatagramPacket(replyBuf, replyBuf.length, dp.getAddress(), dp.getPort());
                    this.socket.send(reply);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (SocketTimeoutException in) {
            }
            catch (IOException ex) {
                Logger.getLogger("StartingServer").log(Level.SEVERE, "Receiving exeption", ex);
            }
        }
    }

    public void kill() {
        this.killing = true;
    }
}

