/*
 * Decompiled with CFR 0.152.
 */
package aglobe.platform;

import aglobe.container.AgentContainer;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AgentList;
import aglobe.ontology.Libraries;
import aglobe.ontology.ServiceList;
import aglobe.platform.StartingServer;
import aglobe.platform.thread.AglobeThreadPool;
import aglobe.platform.transport.MessageTransport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Platform {
    public static final int MAJOR_VERSION = 4;
    public static final int MINOR_VERSION = 1;
    public static final int DEFAULT_PLATFORM_NUBMER = 0;
    public static final int BASE_PLATFORM_PORT = 6000;
    public static final int STARTING_TIMEOUT = 8000;
    public static final Timer TIMER = new Timer();
    public static final String STARTED = "Started";
    public static long THREAD_STACK_SIZE = 0L;
    private static final int DEFAULTPORT = 0;
    public static boolean SHOW_UNDELIVERED_MESSAGES;
    private String[] args;
    private List<String> params;
    private int platformNumber;
    private StartingServer ss;
    private Thread ssThread;
    private static ThreadGroup platformThreadGroup;
    private static HashMap<String, AgentContainer> containers;
    Logger logger = Logger.getLogger("Platform");
    private static Object waitForFinish;

    static {
        containers = new HashMap();
        waitForFinish = new Object();
    }

    public Platform(String[] args) {
        this.params = Arrays.asList(args);
        if (this.params.indexOf("-noSkin") < 0) {
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                final Class<?> cSkinLookAndFeel = cl.loadClass("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
                Class<?> cSkin = cl.loadClass("com.l2fprod.gui.plaf.skin.Skin");
                Object skin = null;
                try {
                    InputStream in = this.getClass().getResourceAsStream("atg.zip");
                    Method mLoadThemePack2 = cSkinLookAndFeel.getMethod("loadThemePack", InputStream.class);
                    skin = mLoadThemePack2.invoke(null, in);
                }
                catch (Exception in) {
                    // empty catch block
                }
                if (skin == null) {
                    Method mLoadThemePack = cSkinLookAndFeel.getMethod("loadThemePack", String.class);
                    try {
                        skin = mLoadThemePack.invoke(null, "../../aglobe/skin/atg.zip");
                    }
                    catch (Exception mLoadThemePack2) {
                        // empty catch block
                    }
                    if (skin == null) {
                        skin = mLoadThemePack.invoke(null, "../aglobe/skin/atg.zip");
                    }
                }
                Method mSetSkin = cSkinLookAndFeel.getMethod("setSkin", cSkin);
                mSetSkin.invoke(null, skin);
                final Object lnf = cSkinLookAndFeel.newInstance();
                UIManager.setLookAndFeel((LookAndFeel)lnf);
                UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        Object newLF = evt.getNewValue();
                        if (!cSkinLookAndFeel.isInstance(newLF)) {
                            try {
                                UIManager.setLookAndFeel((LookAndFeel)lnf);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            catch (Exception cl) {
                // empty catch block
            }
        }
        boolean noInfoLogging = false;
        try {
            if (this.params.indexOf("-noFileLogging") != -1) {
                if (this.params.indexOf("-noInfoLogging") != -1) {
                    LogManager.getLogManager().readConfiguration(Platform.class.getResourceAsStream("logging2_warning.properties"));
                    noInfoLogging = true;
                } else {
                    LogManager.getLogManager().readConfiguration(Platform.class.getResourceAsStream("logging2.properties"));
                }
            } else if (this.params.indexOf("-noInfoLogging") != -1) {
                LogManager.getLogManager().readConfiguration(Platform.class.getResourceAsStream("logging_warning.properties"));
                noInfoLogging = true;
            } else {
                LogManager.getLogManager().readConfiguration(Platform.class.getResourceAsStream("logging.properties"));
            }
        }
        catch (IOException cSkinLookAndFeel) {
        }
        catch (SecurityException cSkinLookAndFeel) {
            // empty catch block
        }
        if (noInfoLogging) {
            this.logger.warning("Showing only warning and higher lever log messages.");
        }
        SHOW_UNDELIVERED_MESSAGES = this.params.indexOf("-showUndeliveredMessages") != -1;
        if (this.params.indexOf("-help") != -1 || this.params.indexOf("-name") == -1) {
            this.logger.info("\n\nA-Globe Platform V4.1\nAuthor: David Sislak (sislakd@feld.cvut.cz)\nAgent Technology Group, Gerstner Laboratory: http://agents.felk.cvut.cz\n\nUsage:\n  java -jar AGlobe.jar -help (for this help)\n  java -jar AGlobe.jar -name {name} [optional_container_params] [optional_platform_params] [[agent_name:main_class] ...]\n\nContainer params:\n  -name {name}    = set the 'name' as container name\n  -gui          = show container GUI\n  -store {dir}    = root directory to use by Store\n  -noStoreChange= store of the agent container cannot be modified  -p {name}={value}= special parametr\n  -server       = start as server container (starts gis/master service)\n  -bridgeServer = betaversion\n  -bridgeClient = betaversion\n  -client       = start as client container (starts gis/client service)\n  -hardwareVisibility {network base IP/range}= start as agent container where visibility is given by true network state (start special gis/client service)\n  -serverAddress {aglobe://host:port/server_container_name/} = address of server container\n  -systemName {name}= system name used for server address autodetection (default '', serverAddress has priority)\n  -platform {nnn}= connect to or create platform number nnn <0-999>\n  -noCommand    = don't start command service\n  -noDirectory  = don't start Yellow pages service\n  -noMigration  = don't start library loader, deploy, library directory and agent mover services\n  -agentMonitor = start agent monitoring service\n  -linkName {name}= link name is used for automatical container lincation of container with the same name on the local network\n\nPlatform params (has effect only during startup of the first container in the platform):\n  -showUndeliveredMessages = show all undelivered messages in the platform log\n  -tcp          = start TCP message transport layer (has higher priority than -udp if used concurrently)\n  -udp          = start UDP message transport layer (default option for hardware visibility mode, otherwise tcp is default)\n  -mtu {nnnn}   = MTU in bytes used for the UDP & multicast message transport layer (default value 1500)\n  -port {nnn}   = message transport will accept incoming TCP/UDP unicast messages on port nnn\n  -multicast {IP:port} = specify multicast group IP and port where platform will send and receive multicast messages, if not specified IP and port is automatically generated from the first started container system name\n  -hardwareVisibility {network base IP/range}= each connection between containers is used only for transmission of one message (related to the TCP message transport layer only)\n  -noFileLogging= don't write loggin messages to the log file\n  -noInfoLogging= log only warning or higher level log messages\n  -noSkin       = do not apply aglobe skin\n\n[[agent_name:main_class] ...]\n  If agent for startup are specified in the starting parameters, the agents from previous run of A-globe are not started again.\n\n\n");
            System.exit(0);
        }
        this.platformNumber = 0;
        int i = this.params.indexOf("-platform");
        if (i != -1) {
            this.platformNumber = Integer.parseInt(this.params.get(i + 1));
            if (this.platformNumber < 0 || this.platformNumber > 999) {
                this.logger.severe("Platform number must be number between 0 and 999");
                System.exit(1);
            }
        }
        this.args = args;
    }

    public static void main(String[] args) {
        Platform platform = new Platform(args);
        platform.run();
        System.exit(0);
    }

    public static ThreadGroup getPlatformThreadGroup() {
        return platformThreadGroup;
    }

    public static Collection<AgentContainer> getContainers() {
        return containers.values();
    }

    public static AgentContainer getContainer(String containerName) {
        return containers.get(containerName);
    }

    public void run() {
        platformThreadGroup = new ThreadGroup(new String("Platform: " + this.platformNumber));
        try {
            this.ss = new StartingServer(this, this.platformNumber);
            this.logger.info("Creating new platform number: " + this.platformNumber);
            if (!SHOW_UNDELIVERED_MESSAGES) {
                this.logger.info("Undelivered messages will not be logged by Message Transport Layer (use '-showUndeliveredMessages').");
            }
            AglobeThreadPool.initialize();
            this.ssThread = AglobeThreadPool.getThread(platformThreadGroup, this.ss, "StartingServer of platform number " + this.platformNumber);
            this.ssThread.setPriority(Math.min(7, 10));
            this.ssThread.start();
            int agentsFrom = 0;
            int port = 0;
            boolean hwMode = false;
            boolean useTcp = true;
            int mtu = 0;
            int i = this.params.indexOf("-port");
            if (i != -1) {
                try {
                    port = Integer.parseInt(this.params.get(i + 1));
                    this.logger.fine("Platform will use port: " + port);
                }
                catch (Exception ex2) {
                    this.logger.warning("-port option has no number, use default option");
                }
            }
            if ((i = this.params.indexOf("-hardwareVisibility")) != -1) {
                hwMode = true;
                useTcp = false;
            }
            if ((i = this.params.indexOf("-udp")) != -1) {
                useTcp = false;
            }
            if ((i = this.params.indexOf("-tcp")) != -1) {
                useTcp = true;
            }
            if (!useTcp && (i = this.params.indexOf("-mtu")) != -1) {
                try {
                    mtu = Integer.parseInt(this.params.get(i + 1));
                    if (mtu < 576 || mtu > 65535) {
                        mtu = 0;
                        this.logger.warning("MTU is out of allowed range 576 - 65535. Use default option.");
                    }
                }
                catch (Exception ex4) {
                    this.logger.warning("-mtu option has no number parameter, use default option");
                }
            }
            if (!useTcp) {
                this.logger.info("The message transport layer will use UDP for message transmission (MTU=" + (mtu == 0 ? 1500 : mtu) + ").");
            }
            String systemName = "default";
            i = this.params.indexOf("-systemName");
            if (i != -1) {
                try {
                    systemName = this.params.get(i + 1);
                }
                catch (Exception ex5) {
                    this.logger.warning("-systemName has no {name} specified, use default option");
                }
            }
            InetAddress multicastGroup = null;
            int multicastPort = 0;
            i = this.params.indexOf("-multicast");
            if (i != -1) {
                try {
                    String tmp = this.params.get(i + 1);
                    String[] parts = tmp.split(":");
                    if (parts.length != 2) {
                        throw new Exception();
                    }
                    agentsFrom = i + 2;
                    multicastGroup = InetAddress.getByName(parts[0]);
                    multicastPort = Integer.parseInt(parts[1]);
                    if (multicastPort < 0 || multicastPort > 65535) {
                        throw new Exception();
                    }
                    byte[] addr = multicastGroup.getAddress();
                    int first = addr[0] & 0xFF;
                    if (first < 224 || first > 239) {
                        this.logger.warning("No multicast address specified in -multicast attribute, will use automatically generated one");
                        multicastGroup = null;
                    } else if (first == 224 && addr[1] == 0 && addr[2] == 0) {
                        this.logger.warning("Multicast address from reserved space was specified in -multicast attribute, will use automatically generated one");
                        multicastGroup = null;
                    }
                }
                catch (Exception ex6) {
                    this.logger.warning("-multicast has no {IP:port} specified or in wrong format, will use automatically generated one");
                    multicastGroup = null;
                }
            }
            if (multicastGroup == null) {
                int systemNameHash = systemName.hashCode();
                try {
                    multicastGroup = InetAddress.getByAddress(new byte[]{-23, (byte)(systemNameHash >> 24 & 0xFF), (byte)(systemNameHash >> 16 & 0xFF), (byte)(systemNameHash >> 8 & 0xFF)});
                    multicastPort = systemNameHash & 0xFFFF;
                }
                catch (Exception ex7) {
                    ex7.printStackTrace();
                    System.exit(1);
                }
            }
            try {
                MessageTransport.initialize(port, this, useTcp, hwMode, mtu, multicastGroup, multicastPort);
                try {
                    AgentList al = new AgentList();
                    int j = this.args.length - 1;
                    while (j >= 0) {
                        String par;
                        String[] twin;
                        if (j < agentsFrom || (twin = (par = this.args[j]).split(":")).length != 2) break;
                        String aname = twin[0];
                        String mainclass = twin[1];
                        AgentInfo ai = new AgentInfo();
                        ai.setName(aname);
                        ai.setReadableName(aname);
                        ai.setMainClass(mainclass);
                        Libraries lib = new Libraries();
                        ai.setLibraries(lib);
                        al.getAgentInfo().add(ai);
                        --j;
                    }
                    if (al.getAgentInfo().size() == 0) {
                        al = null;
                    }
                    Platform.startNewContainer(this.args, al, null, null);
                    this.waitForFinish();
                }
                catch (Exception ex1) {
                    this.logger.severe("Couldn't start container.");
                }
            }
            catch (Exception ex3) {
                this.logger.severe("Problem during message platform initialization: " + ex3);
            }
            AglobeThreadPool.finish();
        }
        catch (SocketException ex) {
            this.startRemote();
        }
        TIMER.cancel();
        MessageTransport.shutdown();
        this.logger.info("A-globe platform " + this.platformNumber + " removed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFinish() {
        while (true) {
            HashMap<String, AgentContainer> hashMap;
            try {
                hashMap = waitForFinish;
                synchronized (hashMap) {
                    waitForFinish.wait(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            hashMap = containers;
            synchronized (hashMap) {
                if (containers.size() == 0) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void containerFinishedNotify(String containerName) {
        HashMap<String, AgentContainer> hashMap = containers;
        synchronized (hashMap) {
            containers.remove(containerName);
            Object object = waitForFinish;
            synchronized (object) {
                waitForFinish.notify();
            }
        }
    }

    private void startRemote() {
        this.logger.info("Trying to start new container in the existing platform: " + this.platformNumber);
        LinkedList ll = new LinkedList(Arrays.asList(this.args));
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(8000);
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream(10240);
            new ObjectOutputStream(outBytes).writeObject(ll);
            byte[] outBuf = outBytes.toByteArray();
            DatagramPacket dp = new DatagramPacket(outBuf, outBuf.length, InetAddress.getLocalHost(), 6000 + this.platformNumber);
            socket.send(dp);
            byte[] inBuf = new byte[1024];
            DatagramPacket recdp = new DatagramPacket(inBuf, inBuf.length);
            try {
                socket.receive(recdp);
                String response = new String(recdp.getData(), 0, recdp.getLength());
                if (!response.equals(STARTED)) {
                    this.logger.severe("The container wasn't started with folowing error message:\n" + response);
                    System.exit(1);
                }
                this.logger.info("The container was started on platform: " + this.platformNumber);
                System.exit(0);
            }
            catch (IOException ex) {
                this.logger.severe("The container wasn't started during timeout 8000 ms.");
                System.exit(1);
            }
        }
        catch (Exception ex) {
            this.logger.severe("Couldn't create new socket.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startNewContainer(String[] args, AgentList agentList, ServiceList serviceList, Address librarySourceContainer) throws Exception {
        String cname;
        List<String> params = Arrays.asList(args);
        int i = params.indexOf("-name");
        if (i == -1) {
            throw new Exception("Missing container name starting attribute");
        }
        try {
            cname = params.get(i + 1);
        }
        catch (Exception ex) {
            throw new Exception("Wrong format of container name starting attribute");
        }
        if (containers.containsKey(cname)) {
            throw new Exception("Container with name '" + cname + "' already exists.");
        }
        HashMap<String, AgentContainer> hashMap = containers;
        synchronized (hashMap) {
            AgentContainer ac = new AgentContainer(args, agentList, serviceList, librarySourceContainer);
            containers.put(cname, ac);
        }
    }
}

