/*
 * Decompiled with CFR 0.152.
 */
package aglobe.ontology;

import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastCommunicationInfo
implements Externalizable {
    private Address _From;
    private ArrayList<Address> _Receivers;
    private int _DataLength;

    public MulticastCommunicationInfo(Address from, Collection<Address> localReceivers, Collection<Address> remoteReceivers, int dataLength) {
        this._From = from;
        this._Receivers = new ArrayList(localReceivers.size() + remoteReceivers.size());
        this._Receivers.addAll(localReceivers);
        this._Receivers.addAll(remoteReceivers);
        this._DataLength = dataLength;
    }

    public Address getFrom() {
        return this._From;
    }

    public Collection<Address> getReceivers() {
        return this._Receivers;
    }

    public int getDataLength() {
        return this._DataLength;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof MulticastCommunicationInfo)) {
            return false;
        }
        MulticastCommunicationInfo tob = (MulticastCommunicationInfo)ob;
        if (this._From != null) {
            if (tob._From == null) {
                return false;
            }
            if (!this._From.equals(tob._From)) {
                return false;
            }
        } else if (tob._From != null) {
            return false;
        }
        if (this._Receivers != null) {
            if (tob._Receivers == null) {
                return false;
            }
            if (!this._Receivers.equals(tob._Receivers)) {
                return false;
            }
        } else if (tob._Receivers != null) {
            return false;
        }
        return this._DataLength == tob._DataLength;
    }

    public int hashCode() {
        int h = 0;
        h = 127 * h + (this._From != null ? this._From.hashCode() : 0);
        h = 127 * h + (this._Receivers != null ? this._Receivers.hashCode() : 0);
        h = 31 * h + this._DataLength;
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<<CommunicationInfo");
        if (this._From != null) {
            sb.append(" From=");
            sb.append(this._From.toString());
        }
        if (this._Receivers != null) {
            for (Address elem : this._Receivers) {
                sb.append(" Receiver=");
                sb.append(elem.toString());
            }
        }
        sb.append(" DataLength=");
        sb.append(Integer.toString(this._DataLength));
        sb.append(">>");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Message.writeString(out, this._From.toString());
        out.writeShort(this._Receivers.size());
        for (Address elem : this._Receivers) {
            Message.writeString(out, elem.toString());
        }
        out.writeInt(this._DataLength);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this._From = Address.getAddress(Message.readString(in));
        int cnt = in.readShort();
        this._Receivers = new ArrayList(cnt);
        while (cnt > 0) {
            this._Receivers.add(Address.getAddress(Message.readString(in)));
            --cnt;
        }
        this._DataLength = in.readInt();
    }
}

