/*
 * Decompiled with CFR 0.152.
 */
package aglobe.ontology;

import aglobe.container.library.ClassLoaderOwner;
import aglobe.container.library.LibraryObjectInputStream;
import aglobe.container.transport.Address;
import aglobe.util.AglobeXMLtools;
import aglobe.util.concurrent.NonblockingArrayFIFO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Message
implements Externalizable {
    private static final NonblockingArrayFIFO<Message> freeMessages = new NonblockingArrayFIFO(1000000);
    private static final NonblockingArrayFIFO<ArrayList<Address>> freeArrayListAddress = new NonblockingArrayFIFO(10000);
    private static final NonblockingArrayFIFO<ArrayList<String>> freeArrayListString = new NonblockingArrayFIFO(10000);
    private static final NonblockingArrayFIFO<ByteArrayOutputStream> freeByteArrayOutputStream = new NonblockingArrayFIFO(100);
    private static final int NULL_CONTENT = 0;
    private static final int STRING_CONTENT = 1;
    private static final int BYTE_CONTENT = 2;
    private static final int EXTERNALIZABLE_CONTENT = 3;
    private static final int OTHER_SERIALIZED_CONTENT = 4;
    private int _ContentType = 0;
    private boolean _IsMulticast = false;
    private Address _Sender;
    private boolean _SenderIsInObject = true;
    private String _SenderAsString;
    private Address _Receiver;
    private boolean _ReceiverIsInObject = true;
    private String _ReceiverAsString;
    private ArrayList<Address> _Receivers = null;
    private ArrayList<String> _ReceiversAsString = null;
    private String _Performative;
    private Object _Content;
    private String _Protocol;
    private String _Ontology;
    private String _ConversationID;
    private String _InReplyTo;
    private String _ReplyWith;
    private String _Reason;
    private boolean _IsReply = false;
    private long _VisibilityID;
    private boolean _DoNotSniff;
    private transient int predictedMessageSize = 0;
    private AtomicInteger holders = new AtomicInteger(1);

    private Message() {
    }

    public static Message newInstance() {
        Message retVal = freeMessages.pop();
        if (retVal != null) {
            retVal.holders.set(1);
            return retVal;
        }
        return new Message();
    }

    public static Message newInstance(String _performative, Address _sender, Address _receiver) {
        Message retVal = Message.newInstance();
        retVal._Performative = _performative;
        retVal._Sender = _sender;
        retVal._SenderAsString = _sender.toString();
        retVal._Receiver = _receiver;
        retVal._ReceiverAsString = _receiver.toString();
        return retVal;
    }

    public static Message newInstance(String _performative, Address _sender, Collection<Address> _receivers) {
        Message retVal = Message.newInstance();
        retVal._Performative = _performative;
        retVal._Sender = _sender;
        retVal._SenderAsString = _sender.toString();
        retVal._IsMulticast = true;
        retVal._Receivers = freeArrayListAddress.pop();
        if (retVal._Receivers == null) {
            retVal._Receivers = new ArrayList<Address>(_receivers);
        } else {
            retVal._Receivers.addAll(_receivers);
        }
        retVal._ReceiversAsString = freeArrayListString.pop();
        if (retVal._ReceiversAsString == null) {
            retVal._ReceiversAsString = new ArrayList(retVal._Receivers.size());
        }
        for (Address elem : retVal._Receivers) {
            retVal._ReceiversAsString.add(elem.toString());
        }
        return retVal;
    }

    public static Message newInstance(String _performative) {
        Message retVal = Message.newInstance();
        retVal._Performative = _performative;
        return retVal;
    }

    public void registerMessageHolder() {
        this.holders.incrementAndGet();
    }

    public void release() {
        if (this.holders.decrementAndGet() != 0) {
            return;
        }
        this._SenderIsInObject = true;
        this._ReceiverIsInObject = true;
        this._IsReply = false;
        this._IsMulticast = false;
        if (this._Receivers != null) {
            this._Receivers.clear();
            freeArrayListAddress.push(this._Receivers);
            this._Receivers = null;
        }
        if (this._ReceiversAsString != null) {
            this._ReceiversAsString.clear();
            freeArrayListString.push(this._ReceiversAsString);
            this._ReceiversAsString = null;
        }
        this._Sender = null;
        this._SenderAsString = null;
        this._Receiver = null;
        this._ReceiverAsString = null;
        this._Performative = null;
        this._Content = null;
        this._Protocol = null;
        this._Ontology = null;
        this._ConversationID = null;
        this._InReplyTo = null;
        this._ReplyWith = null;
        this._Reason = null;
        this._DoNotSniff = false;
        this._ContentType = 0;
        this.predictedMessageSize = 0;
        freeMessages.push(this);
    }

    public Message getReply() {
        if (this._IsMulticast) {
            throw new RuntimeException("getReply() method is not supported for the multicast message. Use getReply(Address sender) instead.");
        }
        Message m = Message.newInstance();
        m._IsReply = true;
        m._ConversationID = this._ConversationID;
        m._InReplyTo = this._ReplyWith;
        m._Receiver = this._Sender;
        m._ReceiverAsString = this._SenderAsString;
        m._ReceiverIsInObject = this._SenderIsInObject;
        m._Sender = this._Receiver;
        m._SenderAsString = this._ReceiverAsString;
        m._SenderIsInObject = this._ReceiverIsInObject;
        m._Protocol = this._Protocol;
        m._VisibilityID = this._VisibilityID;
        return m;
    }

    public Message getReply(Address sender) {
        Message m = Message.newInstance();
        m._IsReply = true;
        m._ConversationID = this._ConversationID;
        m._InReplyTo = this._ReplyWith;
        m._Receiver = this._Sender;
        m._ReceiverAsString = this._SenderAsString;
        m._ReceiverIsInObject = this._SenderIsInObject;
        m._Sender = sender;
        m._SenderAsString = sender.toString();
        m._SenderIsInObject = true;
        m._Protocol = this._Protocol;
        m._VisibilityID = this._VisibilityID;
        return m;
    }

    public boolean isMulticast() {
        return this._IsMulticast;
    }

    public Address getSender() {
        if (!this._SenderIsInObject) {
            this._Sender = Address.getAddress(this._SenderAsString);
            this._SenderAsString = this._Sender.toString();
            this._SenderIsInObject = true;
        }
        return this._Sender;
    }

    public void setSender(Address _Sender) {
        this._Sender = _Sender;
        this._SenderAsString = _Sender == null ? null : this._Sender.toString();
        this.predictedMessageSize = 0;
    }

    public Address getReceiver() {
        if (this._IsMulticast) {
            throw new RuntimeException("The method is not supported for the multicast message. Use getReceivers() method instead.");
        }
        if (!this._ReceiverIsInObject) {
            this._Receiver = Address.getAddress(this._ReceiverAsString);
            this._ReceiverIsInObject = true;
        }
        return this._Receiver;
    }

    public Collection<Address> getReceivers() {
        if (!this._IsMulticast) {
            throw new RuntimeException("The method is supported only for the multicast message. Use getReceiver() for the standard message.");
        }
        if (!this._ReceiverIsInObject) {
            this._Receivers = freeArrayListAddress.pop();
            if (this._Receivers == null) {
                this._Receivers = new ArrayList(this._ReceiversAsString.size());
            }
            for (String elem : this._ReceiversAsString) {
                this._Receivers.add(Address.getAddress(elem));
            }
            this._ReceiverIsInObject = true;
        }
        return this._Receivers;
    }

    public void setReceiver(Address _Receiver) {
        this._Receiver = _Receiver;
        this._ReceiverIsInObject = true;
        this._IsMulticast = false;
        if (this._Receivers != null) {
            this._Receivers.clear();
            freeArrayListAddress.push(this._Receivers);
            this._Receivers = null;
        }
        if (this._ReceiversAsString != null) {
            this._ReceiversAsString.clear();
            freeArrayListString.push(this._ReceiversAsString);
            this._ReceiversAsString = null;
        }
        this._ReceiverAsString = _Receiver == null ? null : this._Receiver.toString();
        this.predictedMessageSize = 0;
    }

    public void setReceivers(Collection<Address> _Receivers) {
        this._IsMulticast = true;
        this._Receiver = null;
        this._ReceiverAsString = null;
        this._Receivers = freeArrayListAddress.pop();
        if (this._Receivers == null) {
            this._Receivers = new ArrayList<Address>(_Receivers);
        } else {
            this._Receivers.addAll(_Receivers);
        }
        this._ReceiverIsInObject = true;
        this._ReceiversAsString = freeArrayListString.pop();
        if (this._ReceiversAsString == null) {
            this._ReceiversAsString = new ArrayList(this._Receivers.size());
        }
        for (Address elem : this._Receivers) {
            this._ReceiversAsString.add(((Object)elem).toString());
        }
        this.predictedMessageSize = 0;
    }

    public void addReceiver(Address _Receiver) {
        if (_Receiver == null) {
            throw new IllegalArgumentException("Cannot add null receiver");
        }
        this.predictedMessageSize = 0;
        if (!this._IsMulticast) {
            this._IsMulticast = true;
            this._Receivers = freeArrayListAddress.pop();
            if (this._Receivers == null) {
                this._Receivers = new ArrayList();
            }
            this._ReceiversAsString = freeArrayListString.pop();
            if (this._ReceiversAsString == null) {
                this._ReceiversAsString = new ArrayList();
            }
            if (this._ReceiverAsString != null) {
                if (this._ReceiverIsInObject) {
                    this._Receivers.add(this._Receiver);
                } else {
                    this._Receivers.add(Address.getAddress(this._ReceiverAsString));
                }
                this._ReceiversAsString.add(this._ReceiverAsString);
                this._Receiver = null;
                this._ReceiverAsString = null;
            }
            this._ReceiverIsInObject = true;
        }
        if (this._ReceiverIsInObject) {
            this._Receivers.add(_Receiver);
        }
        this._ReceiversAsString.add(_Receiver.toString());
    }

    public void clearReceivers() {
        this._IsMulticast = false;
        if (this._Receivers != null) {
            this._Receivers.clear();
            freeArrayListAddress.push(this._Receivers);
            this._Receivers = null;
        }
        if (this._ReceiversAsString != null) {
            this._ReceiversAsString.clear();
            freeArrayListString.push(this._ReceiversAsString);
            this._ReceiversAsString = null;
        }
        this._Receiver = null;
        this._ReceiverAsString = null;
        this._ReceiverIsInObject = true;
        this.predictedMessageSize = 0;
    }

    public String getPerformative() {
        return this._Performative;
    }

    public void setPerformative(String _Performative) {
        this._Performative = _Performative;
        this.predictedMessageSize = 0;
    }

    public Object getContent() {
        return this._Content;
    }

    public void setContent(Object _Content) {
        this.predictedMessageSize = 0;
        this._Content = _Content;
        if (_Content != null) {
            if (_Content instanceof String) {
                this._ContentType = 1;
            } else if (_Content instanceof byte[]) {
                this._ContentType = 2;
            } else if (_Content instanceof Externalizable) {
                this._ContentType = 3;
            } else if (_Content instanceof Serializable) {
                this._ContentType = 4;
            } else {
                throw new RuntimeException("Content type: " + _Content.getClass().getName() + " is not allowed to be content of the A-globe message.");
            }
            this._Ontology = _Content.getClass().getName();
        } else {
            this._ContentType = 0;
            this._Ontology = null;
        }
    }

    public String getProtocol() {
        return this._Protocol;
    }

    public void setProtocol(String _Protocol) {
        this._Protocol = _Protocol;
        if (_Protocol != null) {
            this._DoNotSniff = _Protocol.equals("COMMUNICATION_INFO") || _Protocol.equals("OUTGOING_MESSAGE_COPY") || _Protocol.equals("INCOMING_MESSAGE_COPY");
        }
        this.predictedMessageSize = 0;
    }

    public String getOntology() {
        return this._Ontology;
    }

    public String getConversationID() {
        return this._ConversationID;
    }

    public void setConversationID(String _ConversationID) {
        this._ConversationID = _ConversationID;
        this.predictedMessageSize = 0;
    }

    public String getInReplyTo() {
        return this._InReplyTo;
    }

    public void setInReplyTo(String _InReplyTo) {
        this._InReplyTo = _InReplyTo;
        this.predictedMessageSize = 0;
    }

    public String getReplyWith() {
        return this._ReplyWith;
    }

    public void setReplyWith(String _ReplyWith) {
        this._ReplyWith = _ReplyWith;
        this.predictedMessageSize = 0;
    }

    public String getReason() {
        return this._Reason;
    }

    public void setReason(String _Reason) {
        this._Reason = _Reason;
        this.predictedMessageSize = 0;
    }

    public void setVisibilityID(long visibilityID) {
        this._VisibilityID = visibilityID;
    }

    public boolean getIsReply() {
        return this._IsReply;
    }

    public long getVisibilityID() {
        return this._VisibilityID;
    }

    public boolean getDoNotSniff() {
        return this._DoNotSniff;
    }

    public int predictMessageSize() {
        if (this.predictedMessageSize != 0) {
            return this.predictedMessageSize;
        }
        ByteArrayOutputStream bos = freeByteArrayOutputStream.pop();
        if (bos == null) {
            bos = new ByteArrayOutputStream(10240);
        }
        try {
            this.serialize(bos);
            this.predictedMessageSize = bos.size();
        }
        catch (IOException ex) {
            this.predictedMessageSize = -1;
        }
        bos.reset();
        freeByteArrayOutputStream.push(bos);
        return this.predictedMessageSize;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof Message)) {
            return false;
        }
        Message tob = (Message)ob;
        if (this._SenderAsString != null) {
            if (tob._SenderAsString == null) {
                return false;
            }
            if (!this._SenderAsString.equals(tob._SenderAsString)) {
                return false;
            }
        } else if (tob._SenderAsString != null) {
            return false;
        }
        if (this._IsMulticast != tob._IsMulticast) {
            return false;
        }
        if (this._IsMulticast) {
            if (this._ReceiversAsString != null) {
                if (tob._ReceiversAsString == null) {
                    return false;
                }
                if (!this._ReceiversAsString.equals(tob._ReceiversAsString)) {
                    return false;
                }
            } else if (tob._ReceiversAsString != null) {
                return false;
            }
        } else if (this._ReceiverAsString != null) {
            if (tob._ReceiverAsString == null) {
                return false;
            }
            if (!this._ReceiverAsString.equals(tob._ReceiverAsString)) {
                return false;
            }
        } else if (tob._ReceiverAsString != null) {
            return false;
        }
        if (this._Performative != null) {
            if (tob._Performative == null) {
                return false;
            }
            if (!this._Performative.equals(tob._Performative)) {
                return false;
            }
        } else if (tob._Performative != null) {
            return false;
        }
        if (this.getContent() != null) {
            if (tob.getContent() == null) {
                return false;
            }
            if (!this.getContent().equals(tob.getContent())) {
                return false;
            }
        } else if (tob.getContent() != null) {
            return false;
        }
        if (this._Protocol != null) {
            if (tob._Protocol == null) {
                return false;
            }
            if (!this._Protocol.equals(tob._Protocol)) {
                return false;
            }
        } else if (tob._Protocol != null) {
            return false;
        }
        if (this._Ontology != null) {
            if (tob._Ontology == null) {
                return false;
            }
            if (!this._Ontology.equals(tob._Ontology)) {
                return false;
            }
        } else if (tob._Ontology != null) {
            return false;
        }
        if (this._ConversationID != null) {
            if (tob._ConversationID == null) {
                return false;
            }
            if (!this._ConversationID.equals(tob._ConversationID)) {
                return false;
            }
        } else if (tob._ConversationID != null) {
            return false;
        }
        if (this._InReplyTo != null) {
            if (tob._InReplyTo == null) {
                return false;
            }
            if (!this._InReplyTo.equals(tob._InReplyTo)) {
                return false;
            }
        } else if (tob._InReplyTo != null) {
            return false;
        }
        if (this._ReplyWith != null) {
            if (tob._ReplyWith == null) {
                return false;
            }
            if (!this._ReplyWith.equals(tob._ReplyWith)) {
                return false;
            }
        } else if (tob._ReplyWith != null) {
            return false;
        }
        if (this._Reason != null) {
            if (tob._Reason == null) {
                return false;
            }
            if (!this._Reason.equals(tob._Reason)) {
                return false;
            }
        } else if (tob._Reason != null) {
            return false;
        }
        if (this._VisibilityID != tob._VisibilityID) {
            return false;
        }
        return this._DoNotSniff == tob._DoNotSniff;
    }

    public int hashCode() {
        int h = 0;
        h = 127 * h + (this._SenderAsString != null ? this._SenderAsString.hashCode() : 0);
        if (this._IsMulticast) {
            h = 127 * h + 1231;
            if (this._ReceiversAsString != null) {
                for (String elem : this._ReceiversAsString) {
                    h = 127 * h + elem.hashCode();
                }
            }
        } else {
            h = 127 * h + 1237;
            h = 127 * h + (this._ReceiverAsString != null ? this._ReceiverAsString.hashCode() : 0);
        }
        h = 127 * h + (this._Performative != null ? this._Performative.hashCode() : 0);
        h = 127 * h + (this.getContent() != null ? this.getContent().hashCode() : 0);
        h = 127 * h + (this._Protocol != null ? this._Protocol.hashCode() : 0);
        h = 127 * h + (this._Ontology != null ? this._Ontology.hashCode() : 0);
        h = 127 * h + (this._ConversationID != null ? this._ConversationID.hashCode() : 0);
        h = 127 * h + (this._InReplyTo != null ? this._InReplyTo.hashCode() : 0);
        h = 127 * h + (this._ReplyWith != null ? this._ReplyWith.hashCode() : 0);
        h = 127 * h + (this._Reason != null ? this._Reason.hashCode() : 0);
        h = 127 * h + (int)this._VisibilityID;
        h = 127 * h + (this._DoNotSniff ? 1231 : 1237);
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<<Message");
        sb.append(this._IsMulticast ? " Multicast" : " Standard");
        if (this._SenderAsString != null) {
            sb.append(" Sender=");
            sb.append(this._SenderAsString);
        }
        if (this._IsMulticast) {
            if (this._ReceiversAsString != null) {
                for (String elem : this._ReceiversAsString) {
                    sb.append(" Receiver=");
                    sb.append(elem);
                }
            }
        } else if (this._ReceiverAsString != null) {
            sb.append(" Receiver=");
            sb.append(this._ReceiverAsString);
        }
        if (this._Performative != null) {
            sb.append(" Performative=");
            sb.append(this._Performative.toString());
        }
        if (this._Content != null) {
            sb.append(" Content=");
            sb.append(AglobeXMLtools.printObject(this._Content));
        }
        if (this._Protocol != null) {
            sb.append(" Protocol=");
            sb.append(this._Protocol.toString());
        }
        if (this._Ontology != null) {
            sb.append(" Ontology=");
            sb.append(this._Ontology.toString());
        }
        if (this._ConversationID != null) {
            sb.append(" ConversationID=");
            sb.append(this._ConversationID.toString());
        }
        if (this._InReplyTo != null) {
            sb.append(" InReplyTo=");
            sb.append(this._InReplyTo.toString());
        }
        if (this._ReplyWith != null) {
            sb.append(" ReplyWith=");
            sb.append(this._ReplyWith.toString());
        }
        if (this._Reason != null) {
            sb.append(" Reason=");
            sb.append(this._Reason.toString());
        }
        sb.append(" VisibilityID=");
        sb.append(Long.toString(this._VisibilityID));
        if (this._DoNotSniff) {
            sb.append(" DoNotSniff");
        }
        sb.append(">>");
        return sb.toString();
    }

    public Object clone() {
        Message m = Message.newInstance();
        m._IsMulticast = this._IsMulticast;
        if (this._Receivers != null) {
            m._Receivers = freeArrayListAddress.pop();
            if (m._Receivers == null) {
                m._Receivers = new ArrayList<Address>(this._Receivers);
            } else {
                m._Receivers.addAll(this._Receivers);
            }
        }
        if (this._ReceiversAsString != null) {
            m._ReceiversAsString = freeArrayListString.pop();
            if (m._ReceiversAsString == null) {
                m._ReceiversAsString = new ArrayList<String>(this._ReceiversAsString);
            } else {
                m._ReceiversAsString.addAll(this._ReceiversAsString);
            }
        }
        m._IsReply = this._IsReply;
        m._Sender = this._Sender;
        m._SenderIsInObject = this._SenderIsInObject;
        m._SenderAsString = this._SenderAsString;
        m._Receiver = this._Receiver;
        m._ReceiverIsInObject = this._ReceiverIsInObject;
        m._ReceiverAsString = this._ReceiverAsString;
        m._Performative = this._Performative;
        m._Protocol = this._Protocol;
        m._Ontology = this._Ontology;
        m._ConversationID = this._ConversationID;
        m._InReplyTo = this._InReplyTo;
        m._ReplyWith = this._ReplyWith;
        m._Reason = this._Reason;
        m._VisibilityID = this._VisibilityID;
        m._DoNotSniff = this._DoNotSniff;
        m._ContentType = this._ContentType;
        m._Content = this._Content;
        return m;
    }

    public void serialize(OutputStream _out) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(_out);
        this.writeExternal(out);
        out.close();
    }

    public static Message deserialize(InputStream _in, ClassLoaderOwner context) throws ClassNotFoundException, IOException {
        LibraryObjectInputStream in = new LibraryObjectInputStream(_in, context);
        Message m = Message.newInstance();
        m.readExternal(in);
        return m;
    }

    public static void writeString(ObjectOutput out, String string) throws IOException {
        if (string == null) {
            out.writeInt(-1);
        } else {
            int len = string.length();
            out.writeInt(len);
            char[] chars = new char[len];
            string.getChars(0, len, chars, 0);
            int i = 0;
            while (i < len) {
                out.writeChar(chars[i]);
                ++i;
            }
        }
    }

    public static String readString(ObjectInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return new String();
        }
        char[] buf = new char[len];
        int i = 0;
        while (i < len) {
            buf[i] = in.readChar();
            ++i;
        }
        return new String(buf);
    }

    public static void writeByteArray(ObjectOutput out, byte[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(array.length);
            out.write(array);
        }
    }

    public static byte[] readByteArray(ObjectInput in) throws IOException {
        int remaining = in.readInt();
        if (remaining == -1) {
            return null;
        }
        byte[] retVal = new byte[remaining];
        int pos = 0;
        while (remaining > 0) {
            int cur = in.read(retVal, pos, remaining);
            if (cur < 0) {
                throw new IOException("End of stream");
            }
            pos += cur;
            remaining -= cur;
        }
        return retVal;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._VisibilityID = in.readLong();
        this._DoNotSniff = in.readBoolean();
        this._IsMulticast = in.readBoolean();
        if (this._IsMulticast) {
            int cnt = in.readShort();
            this._ReceiversAsString = freeArrayListString.pop();
            if (this._ReceiverAsString == null) {
                this._ReceiversAsString = new ArrayList(cnt);
            }
            while (cnt > 0) {
                this._ReceiversAsString.add(Message.readString(in));
                --cnt;
            }
        } else {
            this._ReceiverAsString = Message.readString(in);
        }
        this._SenderAsString = Message.readString(in);
        this._Performative = Message.readString(in);
        this._Protocol = Message.readString(in);
        this._Reason = Message.readString(in);
        this._ConversationID = Message.readString(in);
        this._InReplyTo = Message.readString(in);
        this._ReplyWith = Message.readString(in);
        this._ContentType = in.readByte();
        if (this._ContentType != 0) {
            this._Ontology = Message.readString(in);
            switch (this._ContentType) {
                case 1: {
                    this._Content = Message.readString(in);
                    break;
                }
                case 2: {
                    this._Content = Message.readByteArray(in);
                    break;
                }
                case 3: {
                    try {
                        ClassLoader cl = in instanceof LibraryObjectInputStream ? ((LibraryObjectInputStream)in).getClassLoader() : this.getClass().getClassLoader();
                        Class<?> c = cl.loadClass(this._Ontology);
                        Externalizable e = (Externalizable)c.newInstance();
                        e.readExternal(in);
                        this._Content = e;
                    }
                    catch (Exception ex1) {
                        Logger.getLogger("Message").severe("Cannot deserialize message content: " + ex1.toString());
                        this._Content = "Cannot deserialize message content: " + ex1.toString();
                        this._Ontology = String.class.getName();
                    }
                    break;
                }
                default: {
                    try {
                        this._Content = in.readObject();
                        break;
                    }
                    catch (Exception ex) {
                        Logger.getLogger("Message").severe("Cannot deserialize message content: " + ex.toString());
                        this._Content = "Cannot deserialize message content: " + ex.toString();
                        this._Ontology = String.class.getName();
                    }
                }
            }
        }
        this._SenderIsInObject = false;
        this._ReceiverIsInObject = false;
        this._IsReply = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._VisibilityID);
        out.writeBoolean(this._DoNotSniff);
        out.writeBoolean(this._IsMulticast);
        if (this._IsMulticast) {
            out.writeShort(this._ReceiversAsString.size());
            for (String elem : this._ReceiversAsString) {
                Message.writeString(out, elem);
            }
        } else {
            Message.writeString(out, this._ReceiverAsString);
        }
        Message.writeString(out, this._SenderAsString);
        Message.writeString(out, this._Performative);
        Message.writeString(out, this._Protocol);
        Message.writeString(out, this._Reason);
        Message.writeString(out, this._ConversationID);
        Message.writeString(out, this._InReplyTo);
        Message.writeString(out, this._ReplyWith);
        out.writeByte(this._ContentType);
        if (this._ContentType != 0) {
            Message.writeString(out, this._Ontology);
            switch (this._ContentType) {
                case 1: {
                    Message.writeString(out, (String)this._Content);
                    break;
                }
                case 2: {
                    byte[] c = (byte[])this._Content;
                    Message.writeByteArray(out, c);
                    break;
                }
                case 3: {
                    Externalizable e = (Externalizable)this._Content;
                    e.writeExternal(out);
                    break;
                }
                case 4: {
                    out.writeObject(this._Content);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws Exception {
        throw new Exception("Not supported");
    }

    private void readObject(ObjectInputStream s) throws Exception {
        throw new Exception("Not supported");
    }

    public static Message getMessageFormBinarySerializedData(byte[] src, ClassLoaderOwner context) throws IOException, ClassNotFoundException {
        return Message.deserialize(new ByteArrayInputStream(src), context);
    }
}

