/*
 * Decompiled with CFR 0.152.
 */
package aglobe.ontology;

import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AgentList;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Libraries;
import aglobe.ontology.Message;
import aglobe.ontology.ServiceInfo;
import aglobe.ontology.ServiceList;
import aglobe.util.AglobeXMLtools;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerStartup
implements Externalizable {
    private AgentList _AgentList;
    private ServiceList _ServiceList;
    private List<String> _Attribute = new LinkedList<String>();
    private Address _LibrarySourceContainer;

    public AgentList getAgentList() {
        return this._AgentList;
    }

    public void setAgentList(AgentList _agentList) {
        this._AgentList = _agentList;
    }

    public ServiceList getServiceList() {
        return this._ServiceList;
    }

    public void setServiceList(ServiceList _serviceList) {
        this._ServiceList = _serviceList;
    }

    public List<String> getAttribute() {
        return this._Attribute;
    }

    public Address getLibrarySourceContainer() {
        return this._LibrarySourceContainer;
    }

    public void setLibrarySourceContainer(Address _librarySourceContainer) {
        this._LibrarySourceContainer = _librarySourceContainer;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof ContainerStartup)) {
            return false;
        }
        ContainerStartup tob = (ContainerStartup)ob;
        if (this._AgentList != null) {
            if (tob._AgentList == null) {
                return false;
            }
            if (!this._AgentList.equals(tob._AgentList)) {
                return false;
            }
        } else if (tob._AgentList != null) {
            return false;
        }
        if (this._ServiceList != null) {
            if (tob._ServiceList == null) {
                return false;
            }
            if (!this._ServiceList.equals(tob._ServiceList)) {
                return false;
            }
        } else if (tob._ServiceList != null) {
            return false;
        }
        if (this._Attribute != null) {
            if (tob._Attribute == null) {
                return false;
            }
            if (!this._Attribute.equals(tob._Attribute)) {
                return false;
            }
        } else if (tob._Attribute != null) {
            return false;
        }
        if (this._LibrarySourceContainer != null) {
            if (tob._LibrarySourceContainer == null) {
                return false;
            }
            if (!this._LibrarySourceContainer.equals(tob._LibrarySourceContainer)) {
                return false;
            }
        } else if (tob._LibrarySourceContainer != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        h = 127 * h + (this._AgentList != null ? this._AgentList.hashCode() : 0);
        h = 127 * h + (this._ServiceList != null ? this._ServiceList.hashCode() : 0);
        h = 127 * h + (this._Attribute != null ? this._Attribute.hashCode() : 0);
        h = 127 * h + (this._LibrarySourceContainer != null ? this._LibrarySourceContainer.hashCode() : 0);
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<<ContainerStartup");
        if (this._AgentList != null) {
            sb.append(" AgentList=");
            sb.append(this._AgentList.toString());
        }
        if (this._ServiceList != null) {
            sb.append(" ServiceList=");
            sb.append(this._ServiceList.toString());
        }
        if (this._Attribute != null) {
            sb.append(" Attribute=");
            sb.append(this._Attribute.toString());
        }
        if (this._LibrarySourceContainer != null) {
            sb.append(" LibrarySourceContainer=");
            sb.append(this._LibrarySourceContainer.toString());
        }
        sb.append(">>");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._AgentList != null) {
            out.writeBoolean(true);
            out.writeObject(this._AgentList);
        } else {
            out.writeBoolean(false);
        }
        if (this._ServiceList != null) {
            out.writeBoolean(true);
            out.writeObject(this._ServiceList);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this._Attribute.size());
        for (String item : this._Attribute) {
            Message.writeString(out, item);
        }
        if (this._LibrarySourceContainer != null) {
            out.writeBoolean(true);
            Message.writeString(out, this._LibrarySourceContainer.toString());
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this._AgentList = (AgentList)in.readObject();
        }
        if (in.readBoolean()) {
            this._ServiceList = (ServiceList)in.readObject();
        }
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            this._Attribute.add(Message.readString(in));
            ++i;
        }
        if (in.readBoolean()) {
            this._LibrarySourceContainer = Address.getAddress(Message.readString(in));
        }
    }

    public void addAgent(String name, String mainClass, List<String> libraries, LinkedHashMap<String, String> params) {
        AgentInfo ai = new AgentInfo();
        ai.setName(name);
        ai.setReadableName(name);
        ai.setMainClass(mainClass);
        Libraries lib = new Libraries();
        ai.setLibraries(lib);
        if (libraries != null) {
            for (String elem : libraries) {
                lib.getLibrary().add(elem);
            }
        }
        if (params != null) {
            List<AglobeParam> ap = ai.getAglobeParam();
            for (Map.Entry<String, String> elem : params.entrySet()) {
                ap.add(AglobeXMLtools.makeAglobeParam(elem.getKey(), elem.getValue()));
            }
        }
        if (this._AgentList == null) {
            this._AgentList = new AgentList();
        }
        this._AgentList.getAgentInfo().add(ai);
    }

    public void addService(String name, String mainClass, List<String> libraries) {
        ServiceInfo si = new ServiceInfo();
        si.setName(name);
        si.setMainClass(mainClass);
        Libraries lib = new Libraries();
        si.setLibraries(lib);
        if (libraries != null) {
            for (String elem : libraries) {
                lib.getLibrary().add(elem);
            }
        }
        if (this._ServiceList == null) {
            this._ServiceList = new ServiceList();
        }
        this._ServiceList.getServiceInfo().add(si);
    }
}

