/*
 * Decompiled with CFR 0.152.
 */
package aglobe.ontology;

import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommunicationInfo
implements Externalizable {
    private Address _From;
    private Address _To;
    private boolean _Local;
    private boolean _Undeliverable;
    private int _DataLength;

    public CommunicationInfo() {
    }

    public CommunicationInfo(Address from, Address to, boolean local, boolean undeliverable, int dataLength) {
        this._From = from;
        this._To = to;
        this._Local = local;
        this._Undeliverable = undeliverable;
        this._DataLength = dataLength;
    }

    public Address getFrom() {
        return this._From;
    }

    public Address getTo() {
        return this._To;
    }

    public boolean getLocal() {
        return this._Local;
    }

    public boolean getUndeliverable() {
        return this._Undeliverable;
    }

    public int getDataLength() {
        return this._DataLength;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof CommunicationInfo)) {
            return false;
        }
        CommunicationInfo tob = (CommunicationInfo)ob;
        if (this._From != null) {
            if (tob._From == null) {
                return false;
            }
            if (!this._From.equals(tob._From)) {
                return false;
            }
        } else if (tob._From != null) {
            return false;
        }
        if (this._To != null) {
            if (tob._To == null) {
                return false;
            }
            if (!this._To.equals(tob._To)) {
                return false;
            }
        } else if (tob._To != null) {
            return false;
        }
        if (this._Local != tob._Local) {
            return false;
        }
        if (this._Undeliverable != tob._Undeliverable) {
            return false;
        }
        return this._DataLength == tob._DataLength;
    }

    public int hashCode() {
        int h = 0;
        h = 127 * h + (this._From != null ? this._From.hashCode() : 0);
        h = 127 * h + (this._To != null ? this._To.hashCode() : 0);
        h = 31 * h + (this._Local ? 137 : 139);
        h = 31 * h + (this._Undeliverable ? 137 : 139);
        h = 31 * h + this._DataLength;
        return h;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<<CommunicationInfo");
        if (this._From != null) {
            sb.append(" From=");
            sb.append(this._From.toString());
        }
        if (this._To != null) {
            sb.append(" To=");
            sb.append(this._To.toString());
        }
        sb.append(" Local=");
        sb.append((Object)this._Local);
        sb.append(" Undeliverable=");
        sb.append((Object)this._Undeliverable);
        sb.append(" DataLength=");
        sb.append(Integer.toString(this._DataLength));
        sb.append(">>");
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Message.writeString(out, this._From.toString());
        Message.writeString(out, this._To.toString());
        out.writeBoolean(this._Local);
        out.writeBoolean(this._Undeliverable);
        out.writeInt(this._DataLength);
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this._From = Address.getAddress(Message.readString(in));
        this._To = Address.getAddress(Message.readString(in));
        this._Local = in.readBoolean();
        this._Undeliverable = in.readBoolean();
        this._DataLength = in.readInt();
    }
}

