/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.transport;

import aglobe.container.AgentContainer;
import aglobe.container.MessageReceiver;
import aglobe.container.RecepientNotFound;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.CommunicationInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MulticastCommunicationInfo;
import aglobe.ontology.VisibilityUpdate;
import aglobe.platform.Platform;
import aglobe.platform.transport.CloneBuffer;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.link.LinkService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageTransport
implements GISTopicListener {
    private static final String LOGGER = "container.MessageTransport";
    public static final String TOPIC_VISIBILITY_UPDATES = "VISIBILITY_UPDATES";
    public static final String TOPIC_COMMUNICATION_INFO = "COMMUNICATION_INFO";
    public static final String TOPIC_OUTGOING_MESSAGE_COPY = "OUTGOING_MESSAGE_COPY";
    public static final String TOPIC_INCOMING_MESSAGE_COPY = "INCOMING_MESSAGE_COPY";
    private static final int INITAL_MESSAGE_BUFFER_SIZE = 65536;
    private final AgentContainer container;
    private Address containerAddress;
    private Logger logger = Logger.getLogger("container.MessageTransport");
    private final Object cntLock = new Object();
    private int IDcnt = 0;
    private String IDstart = null;
    private boolean controlVisibility = false;
    private Collection<Address> visible = new HashSet<Address>();
    private long visibilityID = 0L;
    private Address serverContainerAddress;
    private Address thisContainerAddress;
    private GISClientService.Shell clientShell = null;
    private GISServerService.Shell masterShell = null;
    private LinkService.Shell linkShell = null;
    private final CloneBuffer bufCommunicationInfo = new CloneBuffer();
    private final CloneBuffer bufMulticastCommunicationInfo = new CloneBuffer();
    private boolean registered = false;

    public void aferContainerInit() {
    }

    public MessageTransport(AgentContainer container) throws IOException {
        this.container = container;
        this.logger.fine("Starting container MessageTransport");
        this.IDstart = String.valueOf(container.getContainerName()) + "-";
    }

    public Address getContainerAddress() {
        return this.containerAddress;
    }

    public void afterInit() throws Exception {
        this.containerAddress = Address.getLocalContainerAddress(this.container);
        aglobe.platform.transport.MessageTransport.registerMessageTransport(this.container.getContainerName(), this);
        this.registered = true;
    }

    public void afterServicesInit() {
        this.clientShell = (GISClientService.Shell)this.container.getServiceManager().getService(null, "gis/client");
        if (this.clientShell != null) {
            this.clientShell.subscribeTopic(TOPIC_VISIBILITY_UPDATES, this);
        } else {
            this.masterShell = (GISServerService.Shell)this.container.getServiceManager().getService(null, "gis/master");
            if (this.masterShell == null) {
                this.linkShell = (LinkService.Shell)this.container.getServiceManager().getService(null, "container/link");
            }
        }
    }

    public MessageReceiver getMessageReceiver(Address receiver) {
        MessageReceiver mr = receiver.isAgent() ? this.container.getAgentManager() : this.container.getServiceManager();
        try {
            return mr.getMessageReceiver(receiver.getName());
        }
        catch (RecepientNotFound ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendStandardMessage(Message m, boolean onlyReference) throws InvisibleContainerException {
        this.ensureMessageIDs(m);
        boolean invisible = false;
        if (!m.getDoNotSniff()) {
            Collection<Address> collection = this.visible;
            synchronized (collection) {
                if (this.controlVisibility && (!m.getIsReply() || m.getVisibilityID() < this.visibilityID)) {
                    m.setVisibilityID(this.visibilityID);
                    if (!this.visible.contains(m.getReceiver().deriveContainerAddress())) {
                        invisible = true;
                    }
                }
            }
        }
        if (invisible) {
            this.insertStandardCommunicationInfo(m, false, true, null, 0);
            if (Platform.SHOW_UNDELIVERED_MESSAGES) {
                this.logger.warning(String.valueOf(this.container.getContainerName()) + ": Target container not reachable due to visibility restrictions: " + m.getReceiver());
            }
            throw new InvisibleContainerException("Target container not visible due to visibility restrictions: " + m.getReceiver());
        }
        return aglobe.platform.transport.MessageTransport.sendStandardMessage(m, this, onlyReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMulticastMessage(Message m, boolean onlyReference) {
        this.ensureMessageIDs(m);
        boolean checkVisibility = false;
        if (!m.getDoNotSniff()) {
            Collection<Address> collection = this.visible;
            synchronized (collection) {
                if (this.controlVisibility && (!m.getIsReply() || m.getVisibilityID() < this.visibilityID)) {
                    m.setVisibilityID(this.visibilityID);
                    checkVisibility = true;
                }
            }
        }
        return aglobe.platform.transport.MessageTransport.sendMulticastMessage(m, this, checkVisibility ? this.visible : null, onlyReference);
    }

    public boolean requestOutgoingMessageCopy() {
        return this.clientShell != null && this.clientShell.hasSomeOutgoingMessageCopySubscriber() || this.masterShell != null && this.masterShell.hasSomeOutgoingMessageCopySubscriber() || this.linkShell != null && this.linkShell.hasSomeMessageCopySubscriber();
    }

    public boolean requestIncomingMessageCopy() {
        return this.clientShell != null && this.clientShell.hasSomeIncomingMessageCopySubscriber() || this.masterShell != null && this.masterShell.hasSomeIncomingMessageCopySubscriber();
    }

    public void ensureMessageIDs(Message m) {
        if (m.getReplyWith() == null || m.getReplyWith().equals("")) {
            m.setReplyWith(this.generateID());
        }
        if (m.getConversationID() == null || m.getConversationID().equals("")) {
            m.setConversationID(this.generateID());
        }
    }

    public void stopMessageTransport() {
        if (this.registered) {
            aglobe.platform.transport.MessageTransport.deregisterMessageTransport(this);
            this.registered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateID() {
        Object object = this.cntLock;
        synchronized (object) {
            return this.IDstart + ++this.IDcnt;
        }
    }

    @Override
    public void addEvent(Runnable r) {
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equals(TOPIC_VISIBILITY_UPDATES)) {
            VisibilityUpdate gi = (VisibilityUpdate)content;
            Collection<Address> collection = this.visible;
            synchronized (collection) {
                this.visible.clear();
                if (this.serverContainerAddress == null) {
                    this.serverContainerAddress = this.clientShell.getServerAddress().deriveContainerAddress();
                }
                this.visible.add(this.serverContainerAddress);
                if (this.thisContainerAddress == null) {
                    this.thisContainerAddress = Address.getLocalContainerAddress(this.container);
                }
                this.visible.add(this.thisContainerAddress);
                for (Address item : gi.getVisibleContainerAddress()) {
                    this.visible.add(item);
                }
                this.visibilityID = gi.getVisibilityID();
                this.controlVisibility = true;
            }
            return;
        }
        this.logger.warning("Unexpected incoming topic: " + topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendIncomingMessageCopy(Message m, byte[] binaryMsg) {
        try {
            if (binaryMsg == null) {
                CloneBuffer cloneBuffer = this.bufCommunicationInfo;
                synchronized (cloneBuffer) {
                    this.bufCommunicationInfo.clear();
                    m.writeExternal(this.bufCommunicationInfo.getOutputStream());
                    this.bufCommunicationInfo.getOutputStream().flush();
                    binaryMsg = new byte[this.bufCommunicationInfo.getDataSize()];
                    System.arraycopy(this.bufCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                }
            }
            final byte[] binM = binaryMsg;
            if (this.clientShell != null) {
                this.clientShell.getServiceInstance().addEvent(new Runnable(){

                    public void run() {
                        MessageTransport.this.clientShell.submitTopic(MessageTransport.TOPIC_INCOMING_MESSAGE_COPY, binM);
                    }
                });
            }
            if (this.masterShell != null) {
                this.masterShell.getServiceInstance().addEvent(new Runnable(){

                    public void run() {
                        MessageTransport.this.masterShell.sendTopicToLocal(MessageTransport.TOPIC_INCOMING_MESSAGE_COPY, binM);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStandardCommunicationInfo(Message m, boolean local, boolean undeliverable, byte[] binaryMsg, int msgSize) {
        block20: {
            Object gc;
            if (m.getDoNotSniff()) {
                return;
            }
            if (this.clientShell != null && this.clientShell.hasSomeCommunicationInfoSubscriber()) {
                gc = new CommunicationInfo(m.getSender(), m.getReceiver(), local, undeliverable, msgSize);
                this.clientShell.submitTopic(TOPIC_COMMUNICATION_INFO, gc);
            } else if (this.masterShell != null && this.masterShell.hasSomeCommunicationInfoSubscriber()) {
                gc = new CommunicationInfo(m.getSender(), m.getReceiver(), local, undeliverable, msgSize);
                this.masterShell.sendTopicToLocal(TOPIC_COMMUNICATION_INFO, gc);
            }
            try {
                if (this.clientShell != null && this.clientShell.hasSomeOutgoingMessageCopySubscriber()) {
                    if (binaryMsg == null) {
                        gc = this.bufCommunicationInfo;
                        synchronized (gc) {
                            this.bufCommunicationInfo.clear();
                            m.writeExternal(this.bufCommunicationInfo.getOutputStream());
                            this.bufCommunicationInfo.getOutputStream().flush();
                            binaryMsg = new byte[this.bufCommunicationInfo.getDataSize()];
                            System.arraycopy(this.bufCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                        }
                    }
                    this.clientShell.submitTopic(TOPIC_OUTGOING_MESSAGE_COPY, binaryMsg, Boolean.toString(undeliverable));
                    return;
                }
                if (this.masterShell != null && this.masterShell.hasSomeOutgoingMessageCopySubscriber()) {
                    if (binaryMsg == null) {
                        gc = this.bufCommunicationInfo;
                        synchronized (gc) {
                            this.bufCommunicationInfo.clear();
                            m.writeExternal(this.bufCommunicationInfo.getOutputStream());
                            this.bufCommunicationInfo.getOutputStream().flush();
                            binaryMsg = new byte[this.bufCommunicationInfo.getDataSize()];
                            System.arraycopy(this.bufCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                        }
                    }
                    this.masterShell.sendTopicToLocal(TOPIC_OUTGOING_MESSAGE_COPY, binaryMsg, Boolean.toString(undeliverable));
                    return;
                }
                if (this.linkShell == null || !this.linkShell.hasSomeMessageCopySubscriber()) break block20;
                if (binaryMsg == null) {
                    gc = this.bufCommunicationInfo;
                    synchronized (gc) {
                        this.bufCommunicationInfo.clear();
                        m.writeExternal(this.bufCommunicationInfo.getOutputStream());
                        this.bufCommunicationInfo.getOutputStream().flush();
                        binaryMsg = new byte[this.bufCommunicationInfo.getDataSize()];
                        System.arraycopy(this.bufCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                    }
                }
                this.linkShell.distributeMessageCopy(binaryMsg, Boolean.toString(undeliverable));
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void insertMulticastCommunicationInfo(Message m, byte[] binaryMsg, int msgSize, Collection<Address> localReceivers, Collection<Address> remoteReceivers) {
        MulticastCommunicationInfo gc;
        if (msgSize == 0) {
            return;
        }
        if (m.getDoNotSniff()) {
            return;
        }
        if (this.clientShell != null && this.clientShell.hasSomeCommunicationInfoSubscriber()) {
            gc = new MulticastCommunicationInfo(m.getSender(), localReceivers, remoteReceivers, msgSize);
            this.clientShell.submitTopic(TOPIC_COMMUNICATION_INFO, gc);
        } else if (this.masterShell != null && this.masterShell.hasSomeCommunicationInfoSubscriber()) {
            gc = new MulticastCommunicationInfo(m.getSender(), localReceivers, remoteReceivers, msgSize);
            this.masterShell.sendTopicToLocal(TOPIC_COMMUNICATION_INFO, gc);
        }
        try {
            if (this.clientShell != null && this.clientShell.hasSomeOutgoingMessageCopySubscriber()) {
                if (binaryMsg == null) {
                    this.bufMulticastCommunicationInfo.clear();
                    m.writeExternal(this.bufMulticastCommunicationInfo.getOutputStream());
                    this.bufMulticastCommunicationInfo.getOutputStream().flush();
                    binaryMsg = new byte[this.bufMulticastCommunicationInfo.getDataSize()];
                    System.arraycopy(this.bufMulticastCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                }
                this.clientShell.submitTopic(TOPIC_OUTGOING_MESSAGE_COPY, binaryMsg, Boolean.toString(true));
                return;
            }
            if (this.masterShell != null && this.masterShell.hasSomeOutgoingMessageCopySubscriber()) {
                if (binaryMsg == null) {
                    this.bufMulticastCommunicationInfo.clear();
                    m.writeExternal(this.bufMulticastCommunicationInfo.getOutputStream());
                    this.bufMulticastCommunicationInfo.getOutputStream().flush();
                    binaryMsg = new byte[this.bufMulticastCommunicationInfo.getDataSize()];
                    System.arraycopy(this.bufMulticastCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                }
                this.masterShell.sendTopicToLocal(TOPIC_OUTGOING_MESSAGE_COPY, binaryMsg, Boolean.toString(true));
                return;
            }
            if (this.linkShell != null && this.linkShell.hasSomeMessageCopySubscriber()) {
                if (binaryMsg == null) {
                    this.bufMulticastCommunicationInfo.clear();
                    m.writeExternal(this.bufMulticastCommunicationInfo.getOutputStream());
                    this.bufMulticastCommunicationInfo.getOutputStream().flush();
                    binaryMsg = new byte[this.bufMulticastCommunicationInfo.getDataSize()];
                    System.arraycopy(this.bufMulticastCommunicationInfo.array(), 0, binaryMsg, 0, binaryMsg.length);
                }
                this.linkShell.distributeMessageCopy(binaryMsg, Boolean.toString(true));
                return;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

