/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.transport;

import aglobe.container.transport.Address;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class AddressPanel
extends JPanel {
    private static final String AGENT = "A";
    private static final String SERVICE = "S";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel containerLabel = new JLabel();
    private JLabel nameLabel = new JLabel();
    private JTextField hostTextField = new JTextField();
    private JTextField containerTextField = new JTextField();
    private JTextField nameTextField = new JTextField();
    private JLabel semincolonLabel = new JLabel();
    private JLabel slashLabel = new JLabel();
    private JLabel slashLabel2 = new JLabel();
    private JTextField portTextField = new JTextField();
    private JComboBox typeCombo = new JComboBox<Object>(new Object[]{"A", "S"});
    private Border border1;
    private TitledBorder titledBorder1;
    private Border border2;

    public AddressPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AddressPanel(String title) {
        this.init();
        this.setTitle(title);
    }

    public AddressPanel(String title, Address a) {
        this.init();
        this.setTitle(title);
        this.setAddress(a);
    }

    public void setTitle(String title) {
        this.titledBorder1.setTitle(title);
    }

    public void setAddress(Address a) {
        this.hostTextField.setText(a.getHost());
        this.portTextField.setText(String.valueOf(a.getPort()));
        this.containerTextField.setText(a.getContainerName());
        this.nameTextField.setText(a.getName());
        if (a.isAgent()) {
            this.typeCombo.setSelectedItem(AGENT);
        } else {
            this.typeCombo.setSelectedItem(SERVICE);
        }
    }

    public Address getAddress() {
        String host = this.hostTextField.getText();
        int port = 1024;
        try {
            port = Integer.parseInt(this.portTextField.getText());
        }
        catch (NumberFormatException ex) {
            this.portTextField.setText("1024");
        }
        String containerName = this.containerTextField.getText();
        String name = this.nameTextField.getText();
        Address a = this.typeCombo.getSelectedItem() == AGENT ? Address.getAgentAddress(host, port, containerName, name) : Address.getServiceAddress(host, port, containerName, name);
        return a;
    }

    public void setHost(String container) {
        this.hostTextField.setText(container);
    }

    public void setPort(int port) {
        this.portTextField.setText(String.valueOf(port));
    }

    public void setContainerName(String containerName) {
        this.containerTextField.setText(containerName);
    }

    private void init() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(165, 163, 151));
        this.titledBorder1 = new TitledBorder(this.border1, "Address");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.containerLabel.setText("Container:");
        this.setLayout(this.gridBagLayout1);
        this.nameLabel.setText("Name:");
        this.hostTextField.setColumns(20);
        this.nameTextField.setColumns(20);
        this.containerTextField.setColumns(20);
        this.semincolonLabel.setText(":");
        this.slashLabel.setText("/");
        this.slashLabel2.setText("/");
        this.portTextField.setText("1024");
        this.portTextField.setColumns(5);
        this.setBorder(this.border2);
        this.add((Component)this.containerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.1, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.add((Component)this.hostTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.nameTextField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.semincolonLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.portTextField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.slashLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.containerTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.slashLabel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.typeCombo, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
    }
}

