/*
 * Decompiled with CFR 0.152.
 */
package aglobe.container.transport;

import aglobe.container.AgentContainer;
import aglobe.container.agent.Agent;
import aglobe.container.service.Service;
import aglobe.platform.transport.MessageTransport;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Address
implements Comparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7901035087721824144L;
    private static final Map<String, Address> addressesCache;
    private static StringBuilder tmpKey1;
    private static StringBuilder tmpKey2;
    private static StringBuilder tmpKey3;
    private static StringBuilder tmpKey4;
    private static StringBuilder tmpKey5;
    private static StringBuilder tmpKey6;
    private static StringBuilder tmpKey7;
    private static StringBuilder tmpKey8;
    private static StringBuilder tmpKey9;
    private static StringBuilder tmpKey10;
    private static StringBuilder tmpKey11;
    private static StringBuilder tmpKey12;
    public static final String PROTOCOL = "aglobe";
    public static final String SERVICEPREFIX = "service";
    public static final String AGENTPREFIX = "agent";
    private static final String PROTPREFIX = "aglobe://";
    private static final int PROTPREFIX_LENGTH;
    private static final char PORTDELIMITER = ':';
    private static final char SLASH = '/';
    private static final String LOCALHOST = "localhost";
    private static final String LOCAL_HOSTNAME;
    private final boolean isPlatform;
    private final boolean isContainer;
    private final boolean isAgent;
    private final String name;
    private final String containerName;
    private final int port;
    private final String host;
    private final int _hashCode;
    private final String _stringValue;
    private transient boolean hasContainerAddress = false;
    private transient Address derivedContainerAddress;
    private transient boolean hasPlatformAddress = false;
    private transient Address derivedPlatformAddress;

    static {
        String s;
        addressesCache = Collections.synchronizedMap(new HashMap());
        tmpKey1 = new StringBuilder(150);
        tmpKey2 = new StringBuilder(150);
        tmpKey3 = new StringBuilder(150);
        tmpKey4 = new StringBuilder(150);
        tmpKey5 = new StringBuilder(150);
        tmpKey6 = new StringBuilder(150);
        tmpKey7 = new StringBuilder(150);
        tmpKey8 = new StringBuilder(150);
        tmpKey9 = new StringBuilder(150);
        tmpKey10 = new StringBuilder(150);
        tmpKey11 = new StringBuilder(150);
        tmpKey12 = new StringBuilder(150);
        PROTPREFIX_LENGTH = PROTPREFIX.length();
        try {
            s = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            s = LOCALHOST;
        }
        LOCAL_HOSTNAME = s;
    }

    public static Address getAddress(String str) {
        Address retVal = addressesCache.get(str);
        if (retVal == null) {
            retVal = new Address(str);
            addressesCache.put(retVal.toString(), retVal);
        }
        return retVal;
    }

    private Address(String str) {
        int typeIndex;
        this.hasContainerAddress = false;
        this.hasPlatformAddress = false;
        String strLow = str.toLowerCase();
        if (!strLow.startsWith(PROTPREFIX)) {
            throw new IllegalArgumentException("An address does not start with aglobe://");
        }
        int portIndex = strLow.indexOf(58, PROTPREFIX_LENGTH);
        if (portIndex < 0) {
            throw new IllegalArgumentException("Invalid address: " + str);
        }
        int containerNameIndex = strLow.indexOf(47, portIndex + 1);
        if (containerNameIndex > 0 && containerNameIndex < strLow.length() - 1) {
            typeIndex = strLow.indexOf(47, containerNameIndex + 1);
            boolean isAgent = false;
            boolean isService = false;
            if (typeIndex != -1) {
                isAgent = strLow.startsWith(AGENTPREFIX, typeIndex + 1);
                if (!isAgent) {
                    this.isAgent = false;
                    isService = strLow.startsWith(SERVICEPREFIX, typeIndex + 1);
                } else {
                    this.isAgent = true;
                }
            } else {
                this.isAgent = false;
            }
            this.isPlatform = false;
            this.isContainer = !isAgent && !isService;
        } else {
            typeIndex = strLow.length();
            this.isPlatform = true;
            this.isContainer = false;
            this.isAgent = false;
        }
        int nameIndex = strLow.indexOf(47, typeIndex + 1);
        if (!this.isContainer && !this.isPlatform) {
            if (nameIndex < 0) {
                throw new IllegalArgumentException("Invalid address: " + str);
            }
            this.name = str.substring(nameIndex + 1).trim();
        } else {
            this.name = "";
        }
        this.host = str.substring(PROTPREFIX_LENGTH, portIndex);
        try {
            this.port = Integer.parseInt(str.substring(portIndex + 1, containerNameIndex));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid address: " + str);
        }
        this.containerName = !this.isPlatform ? (typeIndex < 0 ? str.substring(containerNameIndex + 1) : str.substring(containerNameIndex + 1, typeIndex)) : "";
        this._hashCode = this.myToHashCode();
        this._stringValue = this.myToString();
        if (!this._stringValue.startsWith(str)) {
            throw new IllegalArgumentException("Invalid address: " + str);
        }
    }

    private Address(StringBuilder stringRepresentation, String _host, int _port, String _containerName, boolean _isagent, String _name) {
        this.host = _host;
        this.port = _port;
        this.isAgent = _isagent;
        this.hasContainerAddress = false;
        if (_name == null || _name.length() == 0) {
            this.name = "";
            if (_containerName == null || _containerName.length() == 0) {
                this.isPlatform = true;
                this.isContainer = false;
                this.containerName = "";
            } else {
                this.isPlatform = false;
                this.isContainer = true;
                this.containerName = _containerName;
            }
        } else {
            this.containerName = _containerName;
            this.name = _name;
            this.isPlatform = false;
            this.isContainer = false;
        }
        this._hashCode = this.myToHashCode();
        this._stringValue = stringRepresentation.toString();
    }

    private int myToHashCode() {
        int retVal = 19;
        retVal = 37 * retVal + this.host.hashCode();
        retVal = 37 * retVal + this.port;
        if (this.isPlatform) {
            retVal = 37 * retVal + 1;
        }
        retVal = 37 * retVal + this.containerName.hashCode();
        if (this.isContainer) {
            retVal = 37 * retVal + 1;
        }
        if (this.isAgent) {
            retVal = 37 * retVal + 1;
        }
        retVal = 37 * retVal + this.name.hashCode();
        return retVal;
    }

    public int hashCode() {
        return this._hashCode;
    }

    private static StringBuilder fillAddress(StringBuilder destination, String _host, int _port, boolean _isPlatform, String _containerName, boolean _isContainer, boolean _isAgent, String _name) {
        destination.append(PROTPREFIX).append(_host).append(':').append(_port).append('/');
        if (!_isPlatform) {
            destination.append(_containerName).append('/');
            if (!_isContainer) {
                if (_isAgent) {
                    destination.append(AGENTPREFIX);
                } else {
                    destination.append(SERVICEPREFIX);
                }
                destination.append('/').append(_name);
            }
        }
        return destination;
    }

    private String myToString() {
        return Address.fillAddress(new StringBuilder(), this.host, this.port, this.isPlatform, this.containerName, this.isContainer, this.isAgent, this.name).toString();
    }

    public String toString() {
        return this._stringValue;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public boolean isAgent() {
        return this.isAgent && !this.isContainer;
    }

    public boolean isService() {
        return !this.isAgent && !this.isContainer;
    }

    public boolean isContainerAddress() {
        return this.isContainer;
    }

    public boolean isPlatformAddress() {
        return this.isPlatform;
    }

    private static boolean isSameHost(String h1, String h2) {
        return h1 != null && h2 != null && (h1.equalsIgnoreCase(h2) || LOCALHOST.equalsIgnoreCase(h1) && LOCAL_HOSTNAME.equalsIgnoreCase(h2) || LOCALHOST.equalsIgnoreCase(h2) && LOCAL_HOSTNAME.equalsIgnoreCase(h1));
    }

    public boolean isSamePlatform(Address a) {
        return a != null && a.port == this.port && Address.isSameHost(this.host, a.host);
    }

    public boolean isSameContainer(Address a) {
        return a != null && a.port == this.port && Address.isSameHost(this.host, a.host) && this.containerName.equals(a.containerName);
    }

    public boolean isLocalPlatform() {
        return this.port == MessageTransport.localPort && this.host.equals(MessageTransport.localHostAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getLocalPlatformAddress() {
        Address retVal;
        String localHostAddress = MessageTransport.localHostAddress;
        int localPort = MessageTransport.localPort;
        StringBuilder stringBuilder = tmpKey11;
        synchronized (stringBuilder) {
            tmpKey11.setLength(0);
            Address.fillAddress(tmpKey11, localHostAddress, localPort, true, null, true, false, null);
            retVal = addressesCache.get(tmpKey11.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey11, localHostAddress, localPort, null, false, null);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getLocalContainerAddress(AgentContainer container) {
        Address retVal;
        String localHostAddress = MessageTransport.localHostAddress;
        int localPort = MessageTransport.localPort;
        String containerName = container.getContainerName();
        StringBuilder stringBuilder = tmpKey1;
        synchronized (stringBuilder) {
            tmpKey1.setLength(0);
            Address.fillAddress(tmpKey1, localHostAddress, localPort, false, containerName, true, false, null);
            retVal = addressesCache.get(tmpKey1.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey1, localHostAddress, localPort, containerName, false, null);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    public static Address getLocalContainerAddress(Agent agent) {
        return Address.getLocalContainerAddress(agent.getContainer());
    }

    public static Address getLocalContainerAddress(Service service) {
        return Address.getLocalContainerAddress(service.getContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getLocalAgentAddress(AgentContainer container, String name) {
        Address retVal;
        String localHostAddress = MessageTransport.localHostAddress;
        int localPort = MessageTransport.localPort;
        String containerName = container.getContainerName();
        StringBuilder stringBuilder = tmpKey2;
        synchronized (stringBuilder) {
            tmpKey2.setLength(0);
            Address.fillAddress(tmpKey2, localHostAddress, localPort, false, containerName, false, true, name);
            retVal = addressesCache.get(tmpKey2.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey2, localHostAddress, localPort, containerName, true, name);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    public static Address getLocalAgentAddress(Agent agent, String name) {
        return Address.getLocalAgentAddress(agent.getContainer(), name);
    }

    public static Address getLocalAgentAddress(Service service, String name) {
        return Address.getLocalAgentAddress(service.getContainer(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getLocalServiceAddress(AgentContainer container, String name) {
        Address retVal;
        String localHostAddress = MessageTransport.localHostAddress;
        int localPort = MessageTransport.localPort;
        String containerName = container.getContainerName();
        StringBuilder stringBuilder = tmpKey3;
        synchronized (stringBuilder) {
            tmpKey3.setLength(0);
            Address.fillAddress(tmpKey3, localHostAddress, localPort, false, containerName, false, false, name);
            retVal = addressesCache.get(tmpKey3.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey3, localHostAddress, localPort, containerName, false, name);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    public static Address getLocalServiceAddress(Agent agent, String name) {
        return Address.getLocalServiceAddress(agent.getContainer(), name);
    }

    public static Address getLocalServiceAddress(Service service, String name) {
        return Address.getLocalServiceAddress(service.getContainer(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getPlatformAddress(String host, int port) {
        Address retVal;
        StringBuilder stringBuilder = tmpKey12;
        synchronized (stringBuilder) {
            tmpKey12.setLength(0);
            Address.fillAddress(tmpKey12, host, port, true, null, true, false, null);
            retVal = addressesCache.get(tmpKey12.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey12, host, port, null, false, null);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getContainerAddress(String host, int port, String containerName) {
        Address retVal;
        StringBuilder stringBuilder = tmpKey4;
        synchronized (stringBuilder) {
            tmpKey4.setLength(0);
            Address.fillAddress(tmpKey4, host, port, false, containerName, true, false, null);
            retVal = addressesCache.get(tmpKey4.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey4, host, port, containerName, false, null);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getAgentAddress(String host, int port, String containerName, String name) {
        Address retVal;
        StringBuilder stringBuilder = tmpKey5;
        synchronized (stringBuilder) {
            tmpKey5.setLength(0);
            Address.fillAddress(tmpKey5, host, port, false, containerName, false, true, name);
            retVal = addressesCache.get(tmpKey5.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey5, host, port, containerName, true, name);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address getServiceAddress(String host, int port, String containerName, String name) {
        Address retVal;
        StringBuilder stringBuilder = tmpKey6;
        synchronized (stringBuilder) {
            tmpKey6.setLength(0);
            Address.fillAddress(tmpKey6, host, port, false, containerName, false, false, name);
            retVal = addressesCache.get(tmpKey6.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey6, host, port, containerName, false, name);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address derivePlatformAddress() {
        Address retVal;
        if (this.hasPlatformAddress) {
            return this.derivedPlatformAddress;
        }
        StringBuilder stringBuilder = tmpKey10;
        synchronized (stringBuilder) {
            tmpKey10.setLength(0);
            Address.fillAddress(tmpKey10, this.host, this.port, true, null, true, false, null);
            retVal = addressesCache.get(tmpKey10.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey10, this.host, this.port, null, false, null);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        this.hasPlatformAddress = true;
        this.derivedPlatformAddress = retVal;
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address deriveContainerAddress() {
        Address retVal;
        if (this.hasContainerAddress) {
            return this.derivedContainerAddress;
        }
        StringBuilder stringBuilder = tmpKey7;
        synchronized (stringBuilder) {
            tmpKey7.setLength(0);
            Address.fillAddress(tmpKey7, this.host, this.port, false, this.containerName, true, false, null);
            retVal = addressesCache.get(tmpKey7.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey7, this.host, this.port, this.containerName, false, null);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        this.hasContainerAddress = true;
        this.derivedContainerAddress = retVal;
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address deriveAgentAddress(String name) {
        Address retVal;
        StringBuilder stringBuilder = tmpKey8;
        synchronized (stringBuilder) {
            tmpKey8.setLength(0);
            Address.fillAddress(tmpKey8, this.host, this.port, false, this.containerName, false, true, name);
            retVal = addressesCache.get(tmpKey8.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey8, this.host, this.port, this.containerName, true, name);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address deriveServiceAddress(String name) {
        Address retVal;
        StringBuilder stringBuilder = tmpKey9;
        synchronized (stringBuilder) {
            tmpKey9.setLength(0);
            Address.fillAddress(tmpKey9, this.host, this.port, false, this.containerName, false, false, name);
            retVal = addressesCache.get(tmpKey9.toString());
            if (retVal == null) {
                retVal = new Address(tmpKey9, this.host, this.port, this.containerName, false, name);
                addressesCache.put(retVal.toString(), retVal);
            }
        }
        return retVal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Address) {
            if (this._hashCode != other.hashCode()) {
                return false;
            }
            Address o = (Address)other;
            return this.host.equalsIgnoreCase(o.host) && this.port == o.port && this.containerName.equalsIgnoreCase(o.containerName) && this.isContainer == o.isContainer && this.isPlatform == o.isPlatform && (this.isContainer || this.isAgent == o.isAgent && this.name.equalsIgnoreCase(o.name));
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof Address) {
            return this.toString().compareToIgnoreCase(((Address)o).toString());
        }
        throw new ClassCastException();
    }

    public Object clone() {
        return this;
    }
}

